/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.gcube.queries;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.gcube.resourcemanagement.support.server.gcube.queries.QueryLocation;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;

public class QueryLoader {
    private static final HashMap<QueryLocation, String> cachedQueries = new HashMap();
    private static final String LOG_PREFIX = "[QUERY-LOADER]";

    public static String getQuery(QueryLocation query) throws Exception {
        if (query == null) {
            throw new Exception("Invalid query parameter. Null not allowed.");
        }
        ServerConsole.trace(LOG_PREFIX, "loading " + query.name());
        if (query != null && cachedQueries.containsKey((Object)query)) {
            return cachedQueries.get((Object)query);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(query.getFileName()));
        StringBuilder retval = new StringBuilder();
        String currLine = null;
        while ((currLine = in.readLine()) != null) {
            if (currLine.trim().length() > 0 && currLine.trim().startsWith("#") || currLine.trim().length() == 0) continue;
            retval.append(currLine + System.getProperty("line.separator"));
        }
        in.close();
        String tmp = retval.toString();
        if (cachedQueries != null) {
            cachedQueries.put(query, tmp);
        }
        return tmp;
    }
}

