/****************************************************************************
 *  This software is part of the gCube System.
 *  Site: http://www.gcube-system.org/
 ****************************************************************************
 * The gCube/gCore software is licensed as Free Open Source software
 * conveying to the EUPL (http://ec.europa.eu/idabc/eupl).
 * The software and documentation is provided by its authors/distributors
 * "as is" and no expressed or
 * implied warranty is given for its use, quality or fitness for a
 * particular case.
 ****************************************************************************
 * Filename: MetadataCollectionManager.java
 ****************************************************************************
 * @author <a href="mailto:daniele.strollo@isti.cnr.it">Daniele Strollo</a>
 ***************************************************************************/

package org.gcube.resourcemanagement.support.managers.resources;

import java.io.StringReader;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.resourcemanagement.support.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.types.AllowedResourceTypes;

/**
 * @author Daniele Strollo (ISTI-CNR)
 *
 */
public class ViewManager extends AbstractResourceManager {

	/**
	 * @deprecated discouraged use. With no ID some operations cannot be accessed.
	 */
	public ViewManager()
	throws ResourceParameterException,
	ResourceAccessException {
		super(AllowedResourceTypes.VIEW);
	}

	public ViewManager(final String id)
	throws ResourceParameterException,
	ResourceAccessException {
		super(id, AllowedResourceTypes.VIEW);
	}

	/**
	 * @param id
	 * @param name
	 * @param type
	 * @throws ResourceParameterException
	 * @throws ResourceAccessException
	 */
	public ViewManager(final String id, final String name)
	throws ResourceParameterException,
	ResourceAccessException {
		super(id, name, AllowedResourceTypes.VIEW);
	}

	/**
	 * @param id
	 * @param name
	 * @param type
	 * @param subtype
	 * @throws ResourceParameterException
	 * @throws ResourceAccessException
	 */
	public ViewManager(final String id, final String name, final String subtype)
	throws ResourceParameterException, ResourceAccessException {
		super(id, name, AllowedResourceTypes.VIEW, subtype);
	}

	@Override
	protected final GCUBEResource buildGCUBEResource(final String xmlRepresentation)
	throws AbstractResourceException {
		try {
			GCUBEMCollection impl =	GHNContext.getImplementation(GCUBEMCollection.class);
			impl.load(new StringReader(xmlRepresentation));
			return impl;
		} catch (Exception e) {
			throw new ResourceAccessException("Cannot load the stub for resource " + this.getType(), e);
		}
	}
}
