<!--
    gets the compressed description of all GHNs published in a scope
-->


for $profiles in collection('/db/Profiles/GHN')//Resource
let $gcf-version := $profiles//Resource/Profile/GHNDescription/RunTimeEnv/Variable[Key/text() = 'gCF-version']/Value/text()
let $ghn-version := $profiles//Resource/Profile/GHNDescription/RunTimeEnv/Variable[Key/text() = 'GHN-distribution-version']/Value/text()
let $scopes := string-join( $profiles/Scopes//Scope/text(), ';')
let $subtype := $profiles//Resource/Profile/Site/Domain/text()
<RES_SUBTYPE ISdefault =''/> 
    return 
    <Resource>
        {$profiles//Resource/ID}
        <Type>{$profiles//Resource/Type/text()}</Type>
        <SubType>{$subtype}</SubType>
        <Status>{$profiles//Resource/Profile/GHNDescription/Status/text()}</Status>
        <Name>{$profiles//Resource/Profile/GHNDescription/Name/text()}</Name>
        <Uptime>{$profiles//Resource/Profile/GHNDescription/Uptime/text()}</Uptime>
        <LastUpdate>{$profiles//Resource/Profile/GHNDescription/LastUpdate/text()}</LastUpdate>
        <LocalAvailableSpace>{$profiles//Resource/Profile/GHNDescription/LocalAvailableSpace/text()}</LocalAvailableSpace>
       	<VirtualSize>{$profiles//Resource/Profile/GHNDescription/MainMemory/string(@VirtualSize)}</VirtualSize>
       	<VirtualAvailable>{$profiles//Resource/Profile/GHNDescription/MainMemory/string(@VirtualAvailable)}</VirtualAvailable>
        <LoadLast1Min>{$profiles//Resource/Profile/GHNDescription/Load/string(@Last1Min)}</LoadLast1Min>
        <LoadLast5Min>{$profiles//Resource/Profile/GHNDescription/Load/string(@Last5Min)}</LoadLast5Min>
        <LoadLast15Min>{$profiles//Resource/Profile/GHNDescription/Load/string(@Last15Min)}</LoadLast15Min>
        <gcf-version>{$gcf-version}</gcf-version>
        <ghn-version>{$ghn-version}</ghn-version>
        <Scopes>{$scopes}</Scopes>
    </Resource>