package org.gcube.portlets.admin.resourcemanagement.shared.resource;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.utils.ElementMapper;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.NetworkingFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimplePropertyFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.StateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Configuration;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.entities.resources.VirtualService;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasPersistentMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasVolatileMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author pieve mail:alessandro.pieve@isti.cnr.it
 *
 */
public class UtilityResource {

	private static Logger logger = LoggerFactory.getLogger(UtilityResource.class);

	public static ArrayList<String> getSubResourcesTree(ResourceRegistryClient resourceRegistryClient, String entity,
			String scope) throws Exception {
		ArrayList<String> list = new ArrayList<>();

		String s = resourceRegistryClient.getInstances(entity, true);
		List<Resource> resources = ElementMapper.unmarshalList(Resource.class, s);

		for (Resource r : resources) {
			List<? extends IsIdentifiedBy> iibs = r.getConsistsOf(IsIdentifiedBy.class);
			for (IsIdentifiedBy iib : iibs) {

				Facet f = (Facet) iib.getTarget();

				switch (entity) {
				case "HostingNode":
					if (f instanceof NetworkingFacet) {
						NetworkingFacet nf = (NetworkingFacet) f;
						if (!list.contains(nf.getDomainName())) {
							list.add(nf.getDomainName());
						}
					}
					break;

				case "Configuration":
					if (f instanceof SoftwareFacet) {
						// logger.info("------------Configuration--SoftwareFacet--
						// identified by GenericResource");
						SoftwareFacet sf = (SoftwareFacet) f;
						if (!list.contains(sf.getGroup())) {
							list.add(sf.getGroup());
						}
					}
					break;

				case "EService": // GcoreEndPoint
					if (f instanceof SoftwareFacet) {
						logger.info(
								"------------EService--SoftwareFacet-- identified by Gcore End point and Service End Point");
						SoftwareFacet sf = (SoftwareFacet) f;
						if (!list.contains(sf.getGroup()))
							list.add(sf.getGroup());
					}
					break;
				case "VirtualService": // Service
					if (f instanceof SoftwareFacet) {
						logger.info(
								"------------VirtualService--SoftwareFacet-- identified Service End Point");
						SoftwareFacet sf = (SoftwareFacet) f;
						if (!list.contains(sf.getGroup()))
							list.add(sf.getGroup());
					}
					break;
				}

			}
		}
		return list;

	}

	public static ArrayList<String> getSubResourcesTreeQuery(ResourceRegistryClient resourceRegistryClient,
			String entity) throws Exception {

		ArrayList<String> list = new ArrayList<>();
		String field = null;
		String identifiedFacet = null;
		switch (entity) {

		case "HostingNode":
			field = "domainName";
			identifiedFacet = "NetworkingFacet";
			break;

		case "Configuration":
			field = "group";
			identifiedFacet = "SoftwareFacet";
			break;

		case "EService": // GcoreEndPoint
			field = "group";
			identifiedFacet = "SoftwareFacet";
			break;
			
		case "VirtualService": // Service
			field = "group";
			identifiedFacet = "SoftwareFacet";
			break;
	
		default:
			return new ArrayList<>(0);

		}

		try {
			String query = "SELECT DISTINCT(" + field + ") AS " + field + " "
					+ "FROM (TRAVERSE outE('IsIdentifiedBy'),inV('" + identifiedFacet + "') FROM " + entity + ")";

			logger.info("------------query----------->" + query);

			String result = resourceRegistryClient.rawQuery(query, true);

			if (result != null && !result.isEmpty()) {
				logger.info("--------result-------->" + result);
				JSONArray jsonArray = new JSONArray(result);
				for (int i = 0; i < jsonArray.length(); i++) {
					list.add(jsonArray.getJSONObject(i).get(field).toString());
				}
			} else {
				logger.info("--------result-------->Attention invalid result!");
			}
		} catch (Exception e) {
			logger.error(e.getLocalizedMessage(), e);
		}
		return list;

	}

	/***
	 * Create a list for configuration (aka GenericResourceObject)
	 * 
	 * @param scope
	 * @param typeE
	 * @return
	 * @throws Exception
	 */
	public static List<String> createListConfigurationQuery(ResourceRegistryClient resourceRegistryClient, String typeC,
			String subTypeC) throws Exception {

		String query = null;
		if (subTypeC == null) {
			query = "SELECT header,name, description  FROM (TRAVERSE outE('IsIdentifiedBy'),inV('SoftwareFacet') "
					+ "		FROM Configuration WHILE $depth<=0)";
		} else {
			query = "SELECT header,name, description  FROM (TRAVERSE outE('IsIdentifiedBy'),inV('SoftwareFacet') "
					+ "		FROM Configuration ) where group='" + subTypeC + "'";
		}
		logger.info("------------query list configuration----------->" + query);

		JAXBContext context = JAXBContext.newInstance(GenericResourceObject.class);
		Marshaller m = context.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		m.setProperty(Marshaller.JAXB_FRAGMENT, true);

		List<String> resource = new ArrayList<String>();
		String id = "";
		// String type="EService";
		String type = "GenericResource";
		String subType = "";
		String name = "";
		String description = "";

		String result = resourceRegistryClient.rawQuery(query, true);
		try {
			if (result != null && !result.isEmpty()) {
				logger.info("--------result-------->" + result);
				JSONArray jsonArray = new JSONArray(result);

				for (int i = 0; i < jsonArray.length(); i++) {
					// TODO
					// id=jsonArray.getJSONObject(i).getString("header");
					// id="b981efde-18ea-4867-98e7-5d024fcfc0cb"+i;
					JSONObject header = new JSONObject(jsonArray.getJSONObject(i).get("header").toString());
					id = (String) header.get("uuid");
					logger.info("------------id----------->" + id);

					try {
						name = jsonArray.getJSONObject(i).getString("name");
					} catch (Exception e) {
						name = "";
					}
					try {
						description = jsonArray.getJSONObject(i).getString("description");
					} catch (Exception e) {
						description = "";
					}

					GenericResourceObject temp = new GenericResourceObject(id, type, subType, name, description,
							ScopeProvider.instance.get());
					StringWriter sw = new StringWriter();
					m.marshal(temp, sw);

					// ER
					// configurationRegistry=resourceRegistryClient.getInstance(Configuration.class,
					// uuid);
					// CacheList.resourceid.put(id, new ResourceObject(name,
					// configurationRegistry.toString()));

					resource.add(sw.toString());
				}

			} else {
				logger.info("--------result-------->Attention invalid result!");
			}
		} catch (Exception e) {
			logger.error(e.getLocalizedMessage(), e);
		}

		return resource;
	}

	/***
	 * Create a list for eservice (aka gcore endpoint)
	 * 
	 * @param scope
	 * @param typeE
	 * @return
	 * @throws Exception
	 */
	public static List<String> createListEservice(ResourceRegistryClient resourceRegistryClient, String typeC,
			String subTypeC) throws Exception {
		JAXBContext context = JAXBContext.newInstance(GcoreEndPointObject.class);
		Marshaller m = context.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		m.setProperty(Marshaller.JAXB_FRAGMENT, true);

		List<String> resource = new ArrayList<String>();
		String id = "";
		String type = "EService";
		// String type="RunningInstance";
		String subType = "";
		String serviceClass = "";
		String serviceName = "";
		String version = "";
		String status = "";
		String ghnName = "";

		List<EService> eservices = (List<EService>) resourceRegistryClient.getInstances(EService.class, false);
		for (EService et : eservices) {
			id = et.getHeader().getUUID().toString();
			List<? extends Facet> facets = et.getIdentificationFacets();
			for (Facet f : facets) {
				if (f instanceof SoftwareFacet) {
					SoftwareFacet sf = (SoftwareFacet) f;
					version = sf.getVersion();
					serviceName = sf.getName();
					serviceClass = sf.getGroup();
					subType = sf.getGroup();
					version = sf.getVersion();
				}
			}
			CacheList.resourceid.put(id, new ResourceObject(serviceName, et.toString()));

			ghnName = "";
			status = "";
			List<ConsistsOf<? extends Resource, ? extends Facet>> consist = et.getConsistsOf();
			for (ConsistsOf<? extends Resource, ? extends Facet> c : consist) {
				if (c instanceof ConsistsOf) {
					if (c.getTarget() instanceof AccessPointFacet) {
						AccessPointFacet af = (AccessPointFacet) c.getTarget();
						try {
							ghnName = af.getEndpoint().getHost().toString();
						} catch (Exception e) {
							ghnName = "";
						}
					}
					if (c.getTarget() instanceof StateFacet) {
						StateFacet stf = (StateFacet) c.getTarget();
						try {
							status = stf.getValue().toLowerCase();
						} catch (Exception e) {
							status = "";
						}
					}
				}
			}
			GcoreEndPointObject temp = new GcoreEndPointObject(id, type, subType, ScopeProvider.instance.get(),
					serviceClass, serviceName, version, status, ghnName);
			StringWriter sw = new StringWriter();
			m.marshal(temp, sw);

			if (subTypeC != null) {
				if (subType.equals(subTypeC)) {
					resource.add(sw.toString());
				}
			} else
				resource.add(sw.toString());

		}
		return resource;
	}

	/***
	 * Create a list for configuration (aka GenericResourceObject)
	 * 
	 * @param scope
	 * @param typeE
	 * @return
	 * @throws Exception
	 */
	public static List<String> createListConfiguration(ResourceRegistryClient resourceRegistryClient, String typeC,
			String subTypeC) throws Exception {

		JAXBContext context = JAXBContext.newInstance(GenericResourceObject.class);
		Marshaller m = context.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		m.setProperty(Marshaller.JAXB_FRAGMENT, true);

		List<String> resource = new ArrayList<String>();
		String id = "";
		// String type="EService";
		String type = "GenericResource";
		String subType = "";
		String name = "";
		String description = "";
		List<Configuration> econfiguration = (List<Configuration>) resourceRegistryClient
				.getInstances(Configuration.class, false);
		for (Configuration et : econfiguration) {
			id = et.getHeader().getUUID().toString();
			List<? extends Facet> facets = et.getIdentificationFacets();
			for (Facet f : facets) {
				if (f instanceof SoftwareFacet) {
					SoftwareFacet sf = (SoftwareFacet) f;
					name = sf.getName();
					subType = sf.getGroup();
					description = sf.getDescription();

				}
			}

			CacheList.resourceid.put(id, new ResourceObject(name, et.toString()));
			GenericResourceObject temp = new GenericResourceObject(id, type, subType, name, description,
					ScopeProvider.instance.get());

			StringWriter sw = new StringWriter();
			m.marshal(temp, sw);
			// filter to subtype
			if (subTypeC != null) {
				if (subType.equals(subTypeC)) {
					resource.add(sw.toString());
				}
			} else
				resource.add(sw.toString());

		}
		return resource;

	}

	/***
	 * Create a list for hosting node (aka GHN)
	 * 
	 * @param scope
	 * @param typeE
	 * @return
	 * @throws Exception
	 * @throws Exception
	 */
	public static List<String> createListHostingNode(ResourceRegistryClient resourceRegistryClient, String typeC,
			String subTypeC) throws Exception {

		JAXBContext context = JAXBContext.newInstance(HostingNodeObject.class);
		Marshaller m = context.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		m.setProperty(Marshaller.JAXB_FRAGMENT, true);

		List<String> resource = new ArrayList<String>();
		String id = "";
		// String type="HostingNode";
		String type = "GHN";
		String subType = "";// --
		String status = "";// ---
		String name = "";//
		String upTime = "-";
		String lastUpdate = "-";
		long localAvailableSpace = 0;
		long virtualSize = 0;
		long virtualAvailable = 0;
		String loadLast1Min = "-";
		String loadLast5Min = "-";
		String loadLast15Min = "-";
		String gcfVersion = "";
		String ghnVersion = "";

		List<HostingNode> ehosting = (List<HostingNode>) resourceRegistryClient.getInstances(HostingNode.class, false);
		for (HostingNode eh : ehosting) {
			id = eh.getHeader().getUUID().toString();
			lastUpdate = eh.getHeader().getLastUpdateTime().toString();
			List<? extends Facet> facets = eh.getIdentificationFacets();
			for (Facet f : facets) {
				if (f instanceof NetworkingFacet) {
					NetworkingFacet nf = (NetworkingFacet) f;
					subType = nf.getDomainName();
					name = nf.getHostName();
				}
			}

			CacheList.resourceid.put(id, new ResourceObject(name, eh.toString()));
			List<ConsistsOf<? extends Resource, ? extends Facet>> consist = eh.getConsistsOf();
			for (ConsistsOf<? extends Resource, ? extends Facet> c : consist) {
				// logger.info("------------ConsistsOf--ConsistsOf--
				// c"+c.toString());
				if (c instanceof ConsistsOf) {

					if (c.getTarget() instanceof SimplePropertyFacet) {
						SimplePropertyFacet sp = (SimplePropertyFacet) c.getTarget();
						try {
							gcfVersion = sp.getAdditionalProperty("SmartGearsDistribution").toString();
							ghnVersion = sp.getAdditionalProperty("SmartGears").toString();
						} catch (Exception e) {
							gcfVersion = "";
							ghnVersion = "";
						}
					}
					// get disk space
					if (c instanceof HasPersistentMemory) {
						HasPersistentMemory hpm = (HasPersistentMemory) c;
						try {
							MemoryFacet mfh = (MemoryFacet) hpm.getTarget();
							localAvailableSpace = mfh.getSize() - mfh.getUsed();
						} catch (Exception e) {
							localAvailableSpace = 0;
						}
					}
					// get ram space
					if (c instanceof HasVolatileMemory) {
						HasVolatileMemory hvm = (HasVolatileMemory) c;
						try {
							if (hvm.getAdditionalProperty("memoryType").equals("RAM")) {
								MemoryFacet mf = (MemoryFacet) hvm.getTarget();
								virtualAvailable = mf.getSize() - mf.getUsed();
								virtualSize = mf.getSize();
							}
						} catch (Exception e) {
							virtualAvailable = 0;
							virtualSize = 0;
						}
					}
					// get status
					if (c.getTarget() instanceof StateFacet) {
						StateFacet st = (StateFacet) c.getTarget();
						try {
							status = st.getValue();
						} catch (Exception e) {
							status = "";
						}
					}
				}
			}
			HostingNodeObject temp = new HostingNodeObject(id, type, subType, status, name, upTime, lastUpdate,
					localAvailableSpace, virtualSize, virtualAvailable, loadLast1Min, loadLast5Min, loadLast15Min,
					gcfVersion, ghnVersion, ScopeProvider.instance.get());

			StringWriter sw = new StringWriter();
			m.marshal(temp, sw);
			// filter to subtype
			if (subTypeC != null) {
				if (subType.equals(subTypeC)) {
					resource.add(sw.toString());
				}
			} else
				resource.add(sw.toString());

		}
		return resource;
	}

	public static List<String> createListVirtualService(ResourceRegistryClient resourceRegistryClient, String typeC,
			String subTypeC) throws Exception{
		JAXBContext context = JAXBContext.newInstance(GenericResourceObject.class);
		Marshaller m = context.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		m.setProperty(Marshaller.JAXB_FRAGMENT, true);

		List<String> resource = new ArrayList<String>();
		String id = "";
		String type = "VirtualService";
		String subType = "";
		String serviceClass = "";
		String serviceName = "";
		//String version = "";

		List<VirtualService> virtualServices = (List<VirtualService>) resourceRegistryClient.getInstances(VirtualService.class, false);
		if(virtualServices!=null){
			logger.info("VirtualServices found: {}", virtualServices.size());
		} else {
			logger.info("VirtualServices not found");
			return resource;
		}
		for (VirtualService vs : virtualServices) {
			id = vs.getHeader().getUUID().toString();

			List<? extends Facet> facets = vs.getIdentificationFacets();
			for (Facet f : facets) {
				if (f instanceof SoftwareFacet) {
					SoftwareFacet sf = (SoftwareFacet) f;
					//version = sf.getVersion();
				
					serviceName = sf.getName();
					serviceClass = sf.getGroup();
					subType = sf.getGroup();
				}
			}
			CacheList.resourceid.put(id, new ResourceObject(serviceName, vs.toString()));

			
			GenericResourceObject temp = new GenericResourceObject(id, type, subType, 
					serviceName,serviceClass, ScopeProvider.instance.get());
			
			StringWriter sw = new StringWriter();
			m.marshal(temp, sw);

			if (subTypeC != null) {
				if (subType.equals(subTypeC)) {
					resource.add(sw.toString());
				}
			} else
				resource.add(sw.toString());

		}
		logger.info("Virtual Service: {}",resource);
		return resource;
	}

}
