/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.resourcemanagement.client.forms;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.DualListField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.ListField;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.admin.resourcemanagement.client.remote.ProxyRegistry;
import org.gcube.portlets.admin.resourcemanagement.client.utils.Commands;
import org.gcube.resourcemanagement.support.client.utils.StatusHandler;
import org.gcube.resourcemanagement.support.client.views.ResourceTypeDecorator;

public class DeployServicesForm {
    private ContentPanel rootPanel = null;
    private ContentPanel ghnContainer = null;
    private ContentPanel serviceContainer = null;
    private final ListStore<ModelData> GHNstore = new ListStore();
    private final ListStore<ModelData> selectedGHNs = new ListStore();
    private final Window window = new Window();
    private int resourceLoaded = 0;

    public DeployServicesForm() {
        this.ghnContainer = new ContentPanel((Layout)new FitLayout());
        this.serviceContainer = new ContentPanel((Layout)new FitLayout());
        this.ghnContainer.getHeader().setStyleName("x-hide-panel-header");
        this.ghnContainer.setHeaderVisible(false);
        this.serviceContainer.getHeader().setStyleName("x-hide-panel-header");
        this.serviceContainer.setHeaderVisible(false);
        this.ghnContainer.add((Widget)new Text());
        this.serviceContainer.add((Widget)new Text());
        this.init();
    }

    private void markResourceLoaded() {
        ++this.resourceLoaded;
        if (this.resourceLoaded >= 2) {
            Commands.unmask((Component)Commands.getViewport());
            Commands.unmask((Component)this.rootPanel);
        }
    }

    private void loadGHNs(String scope) {
        ProxyRegistry.getProxyInstance().getResourcesModel(scope, ResourceTypeDecorator.GHN.name(), null, null, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void closeDialog() {
        this.window.hide();
    }

    private Component createGHNForm() {
        FormPanel panel = new FormPanel();
        panel.setFrame(true);
        panel.getHeader().setStyleName("x-hide-panel-header");
        DualListField lists = new DualListField();
        lists.setFieldLabel("GHNs");
        ListField from = lists.getFromList();
        from.setDisplayField("name");
        this.GHNstore.setStoreSorter(new StoreSorter());
        this.GHNstore.setSortField("name");
        from.setStore(this.GHNstore);
        ListField to = lists.getToList();
        to.setDisplayField("name");
        to.setStore(this.selectedGHNs);
        panel.addButton((Button)new /* Unavailable Anonymous Inner Class!! */);
        panel.addButton((Button)new /* Unavailable Anonymous Inner Class!! */);
        panel.add((Widget)lists, (LayoutData)new FormData("100%"));
        return panel;
    }

    private List<ModelData> getSelectedGHNs() {
        return this.selectedGHNs.getModels();
    }

    private List<ModelData> getSelectedSoftwares() {
        Vector<ModelData> retval = new Vector<ModelData>();
        if (this.serviceContainer.getWidget(0) == null || !(this.serviceContainer.getWidget(0) instanceof Grid)) {
            return null;
        }
        Grid grid = (Grid)this.serviceContainer.getWidget(0);
        if (grid.getSelectionModel().getSelectedItems() == null) {
            return null;
        }
        Object toDeploy = null;
        for (ModelData m : grid.getStore().getModels()) {
            toDeploy = m.get("toDeploy");
            if (toDeploy == null || !Boolean.parseBoolean(toDeploy.toString())) continue;
            retval.add(m);
        }
        return retval;
    }

    private void loadSoftwares(String scope) {
        ProxyRegistry.getProxyInstance().getResourcesByType(scope, ResourceTypeDecorator.Service.name(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void init() {
        this.rootPanel = new ContentPanel();
        this.rootPanel.getHeader().setStyleName("x-hide-panel-header");
        this.rootPanel.setHeaderVisible(false);
        this.rootPanel.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        this.rootPanel.add((Widget)this.ghnContainer, (LayoutData)new RowData(1.0, 0.4, new Margins(4)));
        this.rootPanel.add((Widget)this.serviceContainer, (LayoutData)new RowData(1.0, 0.6, new Margins(0, 4, 0, 4)));
        String scope = StatusHandler.getStatus().getCurrentScope();
        Commands.mask((String)("Loading Deployment Resources in scope: " + scope), (Component)Commands.getViewport());
        Commands.mask((String)("Loading Deployment Resources in scope: " + scope), (Component)this.rootPanel);
        this.loadGHNs(scope);
        this.loadSoftwares(scope);
    }

    public final void show() {
        this.window.setPlain(true);
        this.window.setSize(800, 600);
        this.window.setHeading("Software Deployment");
        this.window.setLayout((Layout)new FitLayout());
        this.window.add((Widget)this.rootPanel);
        this.window.show();
        this.window.layout(true);
    }

    static /* synthetic */ ContentPanel access$0(DeployServicesForm deployServicesForm) {
        return deployServicesForm.ghnContainer;
    }

    static /* synthetic */ Component access$1(DeployServicesForm deployServicesForm) {
        return deployServicesForm.createGHNForm();
    }

    static /* synthetic */ ListStore access$2(DeployServicesForm deployServicesForm) {
        return deployServicesForm.GHNstore;
    }

    static /* synthetic */ void access$3(DeployServicesForm deployServicesForm) {
        deployServicesForm.markResourceLoaded();
    }

    static /* synthetic */ void access$4(DeployServicesForm deployServicesForm) {
        deployServicesForm.closeDialog();
    }

    static /* synthetic */ List access$5(DeployServicesForm deployServicesForm) {
        return deployServicesForm.getSelectedGHNs();
    }

    static /* synthetic */ List access$6(DeployServicesForm deployServicesForm) {
        return deployServicesForm.getSelectedSoftwares();
    }

    static /* synthetic */ ContentPanel access$7(DeployServicesForm deployServicesForm) {
        return deployServicesForm.serviceContainer;
    }
}

