/**
 * 
 */
package org.gcube.portlets.admin.gcubereleases.server.persistence;

import org.gcube.portlets.admin.gcubereleases.shared.Accounting;

/**
 * The Interface AccountingObject.
 *
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Feb 19, 2015
 */
public interface AccountingObject {
	
	/**
	 * Gets the accounting package.
	 *
	 * @return the accounting package
	 */
	Accounting getAccountingPackage();
	
	/**
	 * Increment download nmb.
	 *
	 * @param packageId the package id
	 */
	void incrementDownloadNmb(int packageId);
	
	/**
	 * Increment javadoc nmb.
	 *
	 * @param packageId the package id
	 */
	void incrementJavadocNmb(int packageId);
	
	/**
	 * Increment sourcecode nmb.
	 *
	 * @param packageId the package id
	 */
	void incrementSourcecodeNmb(int packageId);
	
	/**
	 * Increment wiki nmb.
	 *
	 * @param packageId the package id
	 */
	void incrementWikiNmb(int packageId);

}
