/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.createusers.client.ui;

import com.github.gwtbootstrap.client.ui.AlertBlock;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.Form;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.admin.createusers.client.CreateUsersPanel;
import org.gcube.portlets.admin.createusers.client.HandleUsersServiceAsync;
import org.gcube.portlets.admin.createusers.client.ui.AddUserForm;

public class AddUserForm
extends Composite {
    private static AddUserFormUiBinder uiBinder = (AddUserFormUiBinder)GWT.create(AddUserFormUiBinder.class);
    public static final String imagePath = GWT.getModuleBaseURL() + "../images/loader.gif";
    @UiField
    Form form;
    @UiField
    Button submit;
    @UiField
    CheckBox sendMailCheckbox;
    @UiField
    Image performingRequest;
    @UiField
    TextBox emailTextbox;
    @UiField
    TextBox nameTextbox;
    @UiField
    TextBox surnameTextbox;
    @UiField
    TextBox companyTextbox;
    @UiField
    AlertBlock errorBlock;
    @UiField
    AlertBlock successBlock;
    private static final String NAME_SURNAME_PATTERN = "^[a-zA-Z\\s]*$";
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final int HIDE_AFTER_MILLISECONDS = 10000;
    private final HandleUsersServiceAsync registrationService;
    private final HandlerManager eventBus;
    private final CreateUsersPanel parent;

    public AddUserForm(HandleUsersServiceAsync userServices, HandlerManager eventBus, CreateUsersPanel parent) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.registrationService = userServices;
        this.eventBus = eventBus;
        this.parent = parent;
        this.performingRequest.setUrl(imagePath);
    }

    protected void onAttach() {
        super.onAttach();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"submit"})
    void onClick(ClickEvent e) {
        String actualName = this.nameTextbox.getText().trim();
        String actualSurname = this.surnameTextbox.getText().trim();
        String actualEmail = this.emailTextbox.getText().trim();
        String actualCompany = this.companyTextbox.getText().trim();
        if (actualEmail.isEmpty() || !actualEmail.matches(EMAIL_PATTERN)) {
            this.showError("Wrong or empty Email field");
            return;
        }
        if (actualName.isEmpty() || !actualName.matches(NAME_SURNAME_PATTERN)) {
            this.showError("Wrong or empty Name field");
            return;
        }
        if (actualSurname.isEmpty() || !actualSurname.matches(NAME_SURNAME_PATTERN)) {
            this.showError("Wrong or empty Surname field");
            return;
        }
        boolean presentTable = this.parent.isUserPresent(actualEmail);
        if (presentTable) {
            this.showAlertBlockThenHide(this.errorBlock, "Please note that a user with this email already exists", 10000);
        } else {
            this.performingRequest.setVisible(true);
            this.submit.setEnabled(false);
            this.registrationService.register(actualName, actualSurname, actualCompany, actualEmail, this.sendMailCheckbox.getValue().booleanValue(), true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.form.reset();
    }

    private void showAlertBlockThenHide(AlertBlock alert, String msg, int hideAfterMs) {
        this.performingRequest.setVisible(false);
        this.submit.setEnabled(true);
        alert.setText(msg);
        alert.setVisible(true);
        3 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(hideAfterMs);
    }

    private void showError(String msg) {
        this.errorBlock.setText(msg);
        this.errorBlock.setVisible(true);
    }

    private void hideAlertBlocks() {
        this.errorBlock.setVisible(false);
        this.successBlock.setVisible(false);
    }

    @UiHandler(value={"emailTextbox"})
    void onChangeEmailTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    @UiHandler(value={"nameTextbox"})
    void onChangeNameTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    @UiHandler(value={"surnameTextbox"})
    void onChangeSurnameTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    @UiHandler(value={"companyTextbox"})
    void onChangeCompanyTextbox(KeyUpEvent event) {
        this.hideAlertBlocks();
    }

    static /* synthetic */ void access$000(AddUserForm x0, AlertBlock x1, String x2, int x3) {
        x0.showAlertBlockThenHide(x1, x2, x3);
    }

    static /* synthetic */ HandlerManager access$100(AddUserForm x0) {
        return x0.eventBus;
    }
}

