/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpSession;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.admin.accountingmanager.server.SessionUtil;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCaller;
import org.gcube.portlets.admin.accountingmanager.server.amservice.cache.AccountingCache;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.server.util.ServiceCredentials;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskRequest;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskStatus;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskWrapper;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingClientCallable
implements Callable<TaskStatus> {
    private static Logger logger = LoggerFactory.getLogger(AccountingClientCallable.class);
    private TaskRequest taskRequest;
    private AccountingCache accountingCache;

    public AccountingClientCallable(TaskRequest taskRequest, AccountingCache accountingCache) {
        this.taskRequest = taskRequest;
        this.accountingCache = accountingCache;
        logger.debug("AccountingClientCallable: " + taskRequest);
    }

    @Override
    public TaskStatus call() throws Exception {
        try {
            HttpSession httpSession = this.taskRequest.getHttpSession();
            if (httpSession == null) {
                logger.error("Error retrieving HttpSession in AccountingClientCallable: is null");
                return TaskStatus.ERROR;
            }
            logger.info("Set SecurityToken: " + this.taskRequest.getServiceCredentials().getToken());
            SecurityTokenProvider.instance.set(this.taskRequest.getServiceCredentials().getToken());
            logger.info("Set ScopeProvider: " + this.taskRequest.getServiceCredentials().getScope());
            ScopeProvider.instance.set(this.taskRequest.getServiceCredentials().getScope());
            AccountingCaller accountingCaller = new AccountingCaller();
            SeriesResponse seriesResponse = null;
            try {
                seriesResponse = accountingCaller.getSeries(this.taskRequest.getAccountingType(), this.taskRequest.getSeriesRequest());
            }
            catch (ServiceException e) {
                TaskWrapper taskWrapper = new TaskWrapper(this.taskRequest.getOperationId(), TaskStatus.ERROR, e.getLocalizedMessage());
                HashMap<String, TaskWrapper> taskWrapperMap = SessionUtil.getTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials());
                if (taskWrapperMap == null) {
                    taskWrapperMap = new HashMap<String, TaskWrapper>();
                    SessionUtil.setTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials(), taskWrapperMap);
                }
                taskWrapperMap.put(taskWrapper.getOperationId(), taskWrapper);
                return TaskStatus.ERROR;
            }
            String key = new String(this.taskRequest.getServiceCredentials().getScope() + "_" + this.taskRequest.getAccountingType().name() + "_" + this.taskRequest.getSeriesRequest().toString());
            this.accountingCache.putSeries(key, seriesResponse);
            AccountingStateData accountingStateData = new AccountingStateData(this.taskRequest.getAccountingType(), this.taskRequest.getSeriesRequest(), seriesResponse);
            SessionUtil.setAccountingStateData((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials(), (AccountingType)this.taskRequest.getAccountingType(), (AccountingStateData)accountingStateData);
            TaskWrapper taskWrapper = new TaskWrapper(this.taskRequest.getOperationId(), TaskStatus.COMPLETED, seriesResponse);
            HashMap<String, TaskWrapper> taskWrapperMap = SessionUtil.getTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials());
            if (taskWrapperMap == null) {
                taskWrapperMap = new HashMap<String, TaskWrapper>();
                SessionUtil.setTaskWrapperMap((HttpSession)httpSession, (ServiceCredentials)this.taskRequest.getServiceCredentials(), taskWrapperMap);
            }
            taskWrapperMap.put(taskWrapper.getOperationId(), taskWrapper);
            return TaskStatus.COMPLETED;
        }
        catch (Throwable e) {
            logger.error("AccountingClientDaemon Execute(): " + e.getLocalizedMessage(), e);
            return TaskStatus.ERROR;
        }
    }
}

