/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.common.portal.PortalContext;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingState;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.server.util.ServiceCredentials;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionUtil {
    private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

    public static ServiceCredentials getServiceCredentials(HttpServletRequest httpServletRequest) throws ServiceException {
        return SessionUtil.getServiceCredentials((HttpServletRequest)httpServletRequest, null, null);
    }

    public static ServiceCredentials getServiceCredentials(HttpServletRequest httpServletRequest, String scopeGroupId, String currUserId) throws ServiceException {
        ServiceCredentials sCredentials = null;
        String userName = null;
        String scope = null;
        String token = null;
        String groupId = null;
        String groupName = null;
        logger.info("Retrieving credential in session!");
        PortalContext pContext = PortalContext.getConfiguration();
        boolean hasScopeGroupId = false;
        boolean hasCurrUserId = false;
        hasScopeGroupId = scopeGroupId != null && !scopeGroupId.isEmpty();
        hasCurrUserId = currUserId != null && !currUserId.isEmpty();
        scope = hasScopeGroupId ? pContext.getCurrentScope(scopeGroupId) : pContext.getCurrentScope(httpServletRequest);
        logger.debug("Scope: " + scope);
        if (scope == null || scope.isEmpty()) {
            String error = "Error retrieving scope: " + scope;
            logger.error(error);
            throw new ServiceException(error);
        }
        GCubeUser gCubeUser = null;
        if (hasCurrUserId) {
            try {
                gCubeUser = new LiferayUserManager().getUserById(Long.valueOf(currUserId).longValue());
            }
            catch (Exception e) {
                String error = "Error retrieving gCubeUser for: [userId= " + currUserId + ", scope: " + scope + "]";
                logger.error(error, (Throwable)e);
                throw new ServiceException(error);
            }
        } else {
            gCubeUser = pContext.getCurrentUser(httpServletRequest);
        }
        if (gCubeUser == null) {
            String error = "Error retrieving gCubeUser in scope " + scope + ": " + gCubeUser;
            logger.error(error);
            throw new ServiceException(error);
        }
        userName = gCubeUser.getUsername();
        logger.debug("UserName: " + userName);
        if (userName == null || userName.isEmpty()) {
            String error = "Error retrieving username in scope " + scope + ": " + userName;
            logger.error(error);
            throw new ServiceException(error);
        }
        if (hasCurrUserId) {
            try {
                token = pContext.getCurrentUserToken(scope, Long.valueOf(currUserId).longValue());
            }
            catch (Exception e) {
                String error = "Error retrieving token for: [userId= " + currUserId + ", scope: " + scope + "]";
                logger.error(error, (Throwable)e);
                throw new ServiceException(error);
            }
        } else {
            token = pContext.getCurrentUserToken(httpServletRequest);
        }
        logger.debug("Token: " + token);
        if (token == null || token.isEmpty()) {
            String error = "Error retrieving token for " + userName + " in " + scope + ": " + token;
            logger.error(error);
            throw new ServiceException(error);
        }
        String name = gCubeUser.getFirstName();
        String lastName = gCubeUser.getLastName();
        String fullName = gCubeUser.getFullname();
        String userAvatarURL = gCubeUser.getUserAvatarURL();
        String email = gCubeUser.getEmail();
        if (hasScopeGroupId) {
            GCubeGroup group;
            long gId;
            groupId = scopeGroupId;
            try {
                gId = Long.parseLong(scopeGroupId);
            }
            catch (Throwable e) {
                String error = "Error retrieving groupId: " + scopeGroupId;
                logger.error(error, e);
                throw new ServiceException(error);
            }
            try {
                group = new LiferayGroupManager().getGroup(gId);
            }
            catch (Throwable e) {
                String error = "Error retrieving group: " + groupName;
                logger.error(error);
                throw new ServiceException(error);
            }
            groupName = group.getGroupName();
        } else {
            groupId = String.valueOf(pContext.getCurrentGroupId(httpServletRequest));
            groupName = pContext.getCurrentGroupName(httpServletRequest);
        }
        sCredentials = new ServiceCredentials(userName, fullName, name, lastName, email, scope, groupId, groupName, userAvatarURL, token);
        logger.info("ServiceCredentials: " + sCredentials);
        return sCredentials;
    }

    public static void setAccountingStateData(HttpSession httpSession, AccountingType accountingType, AccountingStateData accountingStateData) {
        AccountingState accountingState = (AccountingState)httpSession.getAttribute("ACCOUNTING_STATE");
        if (accountingState == null) {
            accountingState = new AccountingState();
            accountingState.setState(accountingType, accountingStateData);
            httpSession.setAttribute("ACCOUNTING_STATE", (Object)accountingState);
        } else {
            accountingState.setState(accountingType, accountingStateData);
        }
    }

    public static AccountingStateData getAccountingStateData(HttpSession httpSession, AccountingType accountingType) {
        AccountingState accountingState = (AccountingState)httpSession.getAttribute("ACCOUNTING_STATE");
        if (accountingState == null) {
            return null;
        }
        return accountingState.getState(accountingType);
    }

    public static Context getContext(ServiceCredentials serviceCredentials) throws ServiceException {
        try {
            logger.info("Current context is " + serviceCredentials.getScope());
            ArrayList<String> contexts = new ArrayList<String>();
            contexts.add(serviceCredentials.getScope());
            LiferayGroupManager gm = new LiferayGroupManager();
            long currentGroupId = gm.getGroupIdFromInfrastructureScope(serviceCredentials.getScope());
            GCubeGroup currentGroup = gm.getGroup(currentGroupId);
            if (!gm.isVRE(currentGroupId).booleanValue()) {
                if (gm.isVO(currentGroupId).booleanValue()) {
                    List children = currentGroup.getChildren();
                    for (GCubeGroup gCubeGroup : children) {
                        contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                    }
                } else {
                    List children = currentGroup.getChildren();
                    for (GCubeGroup gCubeGroup : children) {
                        contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                        List childrenVO = gCubeGroup.getChildren();
                        for (GCubeGroup voChildren : childrenVO) {
                            contexts.add(gm.getInfrastructureScope(voChildren.getGroupId()));
                        }
                    }
                }
            }
            Context context = new Context(contexts);
            return context;
        }
        catch (Exception e) {
            logger.error("Error retrieving context!", (Throwable)e);
            throw new ServiceException("Error retrieving context!", (Throwable)e);
        }
    }
}

