/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.jsr107.Eh107Configuration;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCache
implements Serializable {
    private static final long serialVersionUID = -4352823042594405108L;
    private static Logger logger = LoggerFactory.getLogger(AccountingCache.class);
    private static final String ACCOUNTING_CACHE = "AccountingCache";
    private CacheManager cacheManager;
    private CacheConfiguration<String, SeriesResponse> cacheConfiguration;

    public AccountingCache() throws ServiceException {
        try {
            CachingProvider cachingProvider = Caching.getCachingProvider();
            this.cacheManager = cachingProvider.getCacheManager();
            logger.info("AccountingCache URI: " + this.cacheManager.getURI());
            ResourcePoolsBuilder builder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(60L, (ResourceUnit)MemoryUnit.MB).offheap(240L, MemoryUnit.MB);
            this.cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, SeriesResponse.class, (Builder)builder).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)30L, (TimeUnit)TimeUnit.MINUTES))).withSizeOfMaxObjectSize(50L, MemoryUnit.MB).build();
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    private Cache<String, SeriesResponse> initCache() throws ServiceException {
        try {
            String cacheName = ACCOUNTING_CACHE;
            Cache cache = this.cacheManager.getCache(cacheName, String.class, SeriesResponse.class);
            if (cache == null) {
                cache = this.cacheManager.createCache(cacheName, Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)this.cacheConfiguration));
                this.cacheManager.enableManagement(cacheName, true);
                this.cacheManager.enableStatistics(cacheName, true);
            }
            return cache;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void put(String key, SeriesResponse value) throws ServiceException {
        logger.debug("Cache put: [" + key + ", " + value + "]");
        Cache cache = this.initCache();
        cache.put((Object)key, (Object)value);
        logger.debug("Cached: [" + key + ", " + value + "]");
    }

    public SeriesResponse get(String key) throws ServiceException {
        logger.debug("Cache get: [" + key + "]");
        Cache cache = this.initCache();
        SeriesResponse value = (SeriesResponse)cache.get((Object)key);
        logger.debug("Cached value: [" + key + ", " + value + "]");
        return value;
    }

    public void finalize() throws Throwable {
        logger.debug("Release the cache resources");
        if (this.cacheManager != null) {
            try {
                for (String cacheName : this.cacheManager.getCacheNames()) {
                    this.cacheManager.destroyCache(cacheName);
                }
            }
            catch (Throwable e) {
                logger.error("Error destroying the AccountingCache: " + e.getLocalizedMessage(), e);
            }
            try {
                this.cacheManager.close();
            }
            catch (Throwable e) {
                logger.error("Error closing AccountingCache manager: " + e.getLocalizedMessage(), e);
            }
        }
        super.finalize();
    }
}

