/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.is;

import java.util.Iterator;
import java.util.List;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.admin.accountingmanager.server.is.EnableTabsJAXB;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.impl.JAXBParser;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationSystemUtils {
    private static Logger logger = LoggerFactory.getLogger(InformationSystemUtils.class);

    public static EnableTabsJAXB retrieveEnableTab(String scope) throws ServiceException {
        try {
            if (scope == null || scope.length() == 0) {
                return null;
            }
            ScopeProvider.instance.set(scope);
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType/text() eq 'AccountingProfile'").addCondition("$resource/Profile/Name/text() eq 'AccountingManager'").setResult("$resource");
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List accountingResources = client.submit((Query)query);
            logger.debug("Resources: " + accountingResources);
            EnableTabsJAXB enableTabs = null;
            for (GenericResource genericResource : accountingResources) {
                if (genericResource.scopes() == null) continue;
                ScopeGroup scopes = genericResource.scopes();
                Iterator iterator = scopes.iterator();
                String scopeFound = null;
                boolean found = false;
                while (iterator.hasNext() && !found) {
                    scopeFound = (String)iterator.next();
                    if (scopeFound.compareTo(scope) != 0) continue;
                    found = true;
                }
                if (!found) continue;
                try {
                    JAXBParser parser = new JAXBParser(EnableTabsJAXB.class);
                    logger.debug("Body: " + genericResource.profile().bodyAsString());
                    enableTabs = (EnableTabsJAXB)parser.parse(genericResource.profile().bodyAsString());
                    logger.debug("Enable: " + enableTabs);
                    break;
                }
                catch (Throwable e) {
                    String error = "Error in discovery Accounting Manager enabled tab in scope " + scope + ". " + "Resource parsing failed!";
                    logger.error(error);
                    logger.error("Error {resource=" + genericResource + ", error=" + e.getLocalizedMessage() + "}");
                    e.printStackTrace();
                    throw new ServiceException(error, e);
                }
            }
            return enableTabs;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = "Error in discovery Accounting Manager enabled tab in scope: " + scope;
            logger.error(error);
            logger.error("Error: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(error, e);
        }
    }
}

