/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCallerInterface;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCallerTester;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.Spaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesSpace;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.service.SeriesServiceTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.space.SeriesSpaceData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.space.SeriesSpaceDataSpaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.space.SeriesSpaceSpaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCallerTester
implements AccountingCallerInterface {
    private static Logger logger = LoggerFactory.getLogger(AccountingCallerTester.class);
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy MMMMM dd");

    public ArrayList<FilterKey> getFilterKeys(AccountingType accountingType) throws ServiceException {
        try {
            logger.debug("getFilterKeys(): [AccountingType=" + accountingType + "]");
            if (accountingType == null) {
                return new ArrayList<FilterKey>();
            }
            ArrayList<FilterKey> filterKeys = new ArrayList<FilterKey>();
            FilterKey key = new FilterKey("ConsumerId");
            filterKeys.add(key);
            key = new FilterKey("ClassName");
            filterKeys.add(key);
            for (int i = 0; i < 20; ++i) {
                key = new FilterKey("ServiceName" + i);
                filterKeys.add(key);
            }
            logger.debug("List FilterKeys:" + filterKeys);
            return filterKeys;
        }
        catch (Throwable e) {
            logger.error("Error in getFilterKeys(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("No keys available!");
        }
    }

    public FilterValuesResponse getFilterValues(FilterValuesRequest filterValuesRequest) throws ServiceException {
        try {
            logger.debug("getFilterValue(): [FilterValueRequest=" + filterValuesRequest + "]");
            FilterValuesResponse filterValuesResponse = null;
            if (filterValuesRequest == null || filterValuesRequest.getAccountingType() == null || filterValuesRequest.getFilterKey() == null) {
                filterValuesResponse = new FilterValuesResponse(new ArrayList());
                return filterValuesResponse;
            }
            ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>();
            String[] vals = new String[]{"giancarlo.panichi", "gianpaolo.coro"};
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[filterValuesRequest.getAccountingType().ordinal()]) {
                default: 
            }
            List<String> values = Arrays.asList(vals);
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                filterValues.add(new FilterValue(value));
            }
            filterValuesResponse = new FilterValuesResponse(filterValues);
            return filterValuesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in getFilterValues(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("No values available!");
        }
    }

    public SeriesResponse getSeries(AccountingType accountingType, SeriesRequest seriesRequest) throws ServiceException {
        try {
            logger.debug("getSeries(): [AccountingType=" + accountingType + " , seriesRequest=" + seriesRequest + "]");
            SeriesJob seriesResponse = null;
            Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
            try {
                startCalendar.setTime(this.sdf.parse(seriesRequest.getAccountingPeriod().getStartDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ServiceException("Start Date not valid!");
            }
            Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
            try {
                endCalendar.setTime(this.sdf.parse(seriesRequest.getAccountingPeriod().getEndDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ServiceException("End Date not valid!");
            }
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
                case 1: {
                    SeriesJobBasic serieJobDefinition = null;
                    if (seriesRequest.getAccountingFilterDefinition().getChartType() != null) {
                        ArrayList<SeriesJobData> seriesJobData = new ArrayList<SeriesJobData>();
                        for (int i = 0; i < 30; ++i) {
                            SeriesJobData data = new SeriesJobData(new Date(), Long.valueOf(new Double(10.0 * Math.random()).longValue()), Long.valueOf(new Double(10.0 * Math.random()).longValue()), Long.valueOf(new Double(10.0 * Math.random()).longValue()), Long.valueOf(new Double(100.0 * Math.random()).longValue()));
                            seriesJobData.add(data);
                        }
                        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[seriesRequest.getAccountingFilterDefinition().getChartType().ordinal()]) {
                            case 1: {
                                serieJobDefinition = new SeriesJobBasic(seriesJobData);
                                break;
                            }
                            case 2: {
                                AccountingFilterTop accountingFilterTop = (AccountingFilterTop)seriesRequest.getAccountingFilterDefinition();
                                ArrayList<SeriesJobDataTop> seriesJobDataTopList = new ArrayList<SeriesJobDataTop>();
                                for (int i = 0; i < accountingFilterTop.getTopNumber(); ++i) {
                                    SeriesJobDataTop seriesJobDataTop = new SeriesJobDataTop(new FilterValue("User" + i), seriesJobData);
                                    seriesJobDataTopList.add(seriesJobDataTop);
                                }
                                serieJobDefinition = new SeriesJobTop(accountingFilterTop.getTopNumber(), seriesJobDataTopList);
                                break;
                            }
                        }
                    }
                    seriesResponse = new SeriesJob(serieJobDefinition);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    SeriesServiceBasic serieServiceDefinition = null;
                    if (seriesRequest.getAccountingFilterDefinition().getChartType() != null) {
                        ArrayList<SeriesServiceData> seriesServiceData = new ArrayList<SeriesServiceData>();
                        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingPeriodMode[seriesRequest.getAccountingPeriod().getPeriod().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                for (int i = 0; i < 30; ++i) {
                                    SeriesServiceData data = new SeriesServiceData(new Date(), Long.valueOf(new Double(50.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()));
                                    seriesServiceData.add(data);
                                }
                                break;
                            }
                            case 4: {
                                while (startCalendar.compareTo(endCalendar) <= 0) {
                                    SeriesServiceData data = new SeriesServiceData(startCalendar.getTime(), Long.valueOf(new Double(50.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()));
                                    seriesServiceData.add(data);
                                    startCalendar.add(2, 1);
                                }
                                break;
                            }
                            case 5: {
                                while (startCalendar.compareTo(endCalendar) <= 0) {
                                    SeriesServiceData data = new SeriesServiceData(startCalendar.getTime(), Long.valueOf(new Double(50.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()), Long.valueOf(new Double(10000.0 * Math.random()).longValue()));
                                    seriesServiceData.add(data);
                                    startCalendar.add(1, 1);
                                }
                                break;
                            }
                        }
                        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[seriesRequest.getAccountingFilterDefinition().getChartType().ordinal()]) {
                            case 1: {
                                serieServiceDefinition = new SeriesServiceBasic(seriesServiceData);
                                break;
                            }
                            case 2: {
                                AccountingFilterTop accountingFilterTop = (AccountingFilterTop)seriesRequest.getAccountingFilterDefinition();
                                ArrayList<SeriesServiceDataTop> seriesServiceDataTopList = new ArrayList<SeriesServiceDataTop>();
                                for (int i = 0; i < accountingFilterTop.getTopNumber(); ++i) {
                                    SeriesServiceDataTop seriesServiceDataTop1 = new SeriesServiceDataTop(new FilterValue("User" + i), seriesServiceData);
                                    seriesServiceDataTopList.add(seriesServiceDataTop1);
                                }
                                serieServiceDefinition = new SeriesServiceTop(accountingFilterTop.getTopNumber(), seriesServiceDataTopList);
                                break;
                            }
                        }
                    }
                    seriesResponse = new SeriesService(serieServiceDefinition);
                    break;
                }
                case 6: {
                    SeriesSpaceSpaces serieSpaceDefinition = null;
                    if (seriesRequest.getAccountingFilterDefinition().getChartType() != null) {
                        ArrayList<SeriesSpaceData> seriesSpaceData = new ArrayList<SeriesSpaceData>();
                        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingPeriodMode[seriesRequest.getAccountingPeriod().getPeriod().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                for (int i = 0; i < 30; ++i) {
                                    SeriesSpaceData data = new SeriesSpaceData(new Date(), Long.valueOf(new Double(10000.0 * Math.random()).longValue()));
                                    seriesSpaceData.add(data);
                                }
                                break;
                            }
                            case 4: {
                                while (startCalendar.compareTo(endCalendar) <= 0) {
                                    SeriesSpaceData data = new SeriesSpaceData(startCalendar.getTime(), Long.valueOf(new Double(10000.0 * Math.random()).longValue()));
                                    seriesSpaceData.add(data);
                                    startCalendar.add(2, 1);
                                }
                                break;
                            }
                            case 5: {
                                while (startCalendar.compareTo(endCalendar) <= 0) {
                                    SeriesSpaceData data = new SeriesSpaceData(startCalendar.getTime(), Long.valueOf(new Double(10000.0 * Math.random()).longValue()));
                                    seriesSpaceData.add(data);
                                    startCalendar.add(1, 1);
                                }
                                break;
                            }
                        }
                        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[seriesRequest.getAccountingFilterDefinition().getChartType().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                ArrayList<SeriesSpaceDataSpaces> seriesSpaceDataSpacesList = new ArrayList<SeriesSpaceDataSpaces>();
                                ArrayList<String> spacesList = new ArrayList<String>();
                                for (int i = 1; i < 3; ++i) {
                                    String space = new String("Space" + i);
                                    spacesList.add(space);
                                    SeriesSpaceDataSpaces seriesSpaceDataSpaces = new SeriesSpaceDataSpaces(space, seriesSpaceData);
                                    seriesSpaceDataSpacesList.add(seriesSpaceDataSpaces);
                                }
                                Spaces spaces = new Spaces(spacesList);
                                serieSpaceDefinition = new SeriesSpaceSpaces(spaces, seriesSpaceDataSpacesList);
                            }
                        }
                    }
                    seriesResponse = new SeriesSpace(serieSpaceDefinition);
                    break;
                }
                case 4: {
                    SeriesStorageBasic serieStorageDefinition = null;
                    if (seriesRequest.getAccountingFilterDefinition().getChartType() != null) {
                        ArrayList<SeriesStorageData> seriesStorageData = new ArrayList<SeriesStorageData>();
                        for (int i = 0; i < 30; ++i) {
                            SeriesStorageData data = new SeriesStorageData(new Date(), Long.valueOf(new Double(1048576.0 * Math.random()).longValue()), Long.valueOf(new Double(100.0 * Math.random()).longValue()));
                            seriesStorageData.add(data);
                        }
                        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[seriesRequest.getAccountingFilterDefinition().getChartType().ordinal()]) {
                            case 1: {
                                for (SeriesStorageData serieStorageData : seriesStorageData) {
                                    serieStorageData.setDataVolume(Long.valueOf(serieStorageData.getDataVolume() * 1000L));
                                    serieStorageData.setOperationCount(Long.valueOf(serieStorageData.getOperationCount() * 1000L));
                                }
                                serieStorageDefinition = new SeriesStorageBasic(seriesStorageData);
                                break;
                            }
                            case 2: {
                                AccountingFilterTop accountingFilterTop = (AccountingFilterTop)seriesRequest.getAccountingFilterDefinition();
                                ArrayList<SeriesStorageDataTop> seriesStorageDataTopList = new ArrayList<SeriesStorageDataTop>();
                                for (int i = 0; i < accountingFilterTop.getTopNumber(); ++i) {
                                    SeriesStorageDataTop seriesStorageDataTop = new SeriesStorageDataTop(new FilterValue("User" + i), seriesStorageData);
                                    seriesStorageDataTopList.add(seriesStorageDataTop);
                                }
                                serieStorageDefinition = new SeriesStorageTop(accountingFilterTop.getTopNumber(), seriesStorageDataTopList);
                                break;
                            }
                        }
                    }
                    seriesResponse = new SeriesStorage(serieStorageDefinition);
                    break;
                }
                case 5: {
                    break;
                }
            }
            if (seriesResponse == null) {
                throw new ServiceException("Error creating series response!");
            }
            logger.debug("SeriesResponse Created: " + seriesResponse);
            return seriesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in GetSeries(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("No data available!");
        }
    }

    public Spaces getSpaces() throws ServiceException {
        ArrayList<String> categoriesList = new ArrayList<String>();
        categoriesList.add("Space1");
        categoriesList.add("Space2");
        Spaces categories = new Spaces(categoriesList);
        return categories;
    }
}

