/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4JobTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4JobTop.class);
    private Integer topNumber;
    private SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM;

    public SeriesResponse4JobTop(Integer topNumber, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) {
        this.topNumber = topNumber;
        this.topSM = topSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.topSM == null || this.topSM.isEmpty()) {
                logger.error("Error creating series for job accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesJobDataTop> seriesJobDataTopList = new ArrayList<SeriesJobDataTop>();
            for (NumberedFilter topValue : this.topSM.keySet()) {
                ArrayList<SeriesJobData> series = new ArrayList<SeriesJobData>();
                SortedMap infos = (SortedMap)this.topSM.get(topValue);
                for (Info info : infos.values()) {
                    JsonNode jso = info.getValue();
                    Long duration = jso.get("duration").asLong();
                    Long operationCount = jso.get("operationCount").asLong();
                    Long maxInvocationTime = jso.get("maxInvocationTime").asLong();
                    Long minInvocationTime = jso.get("minInvocationTime").asLong();
                    series.add(new SeriesJobData(info.getCalendar().getTime(), operationCount, duration, maxInvocationTime, minInvocationTime));
                }
                SeriesJobDataTop seriesJobDataTop = new SeriesJobDataTop(new FilterValue(topValue.getValue()), series);
                seriesJobDataTopList.add(seriesJobDataTop);
            }
            SeriesJobTop seriesJobTop = new SeriesJobTop(this.topNumber, seriesJobDataTopList);
            SeriesJob seriesService = new SeriesJob((SeriesJobDefinition)seriesJobTop);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesService);
        }
        catch (Throwable e) {
            logger.error("Error creating series for job accounting top chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for job accounting top chart: " + e.getLocalizedMessage());
        }
    }
}

