/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommand;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4JobTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4PortletTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4ServiceTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4StorageTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4TaskTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseDirector;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCommandTop
implements AccountingCommand<SeriesResponse> {
    private static final Logger logger = LoggerFactory.getLogger(AccountingCommandTop.class);
    private AccountingQueryTop accountingQueryTop;
    private AccountingType accountingType;

    public AccountingCommandTop(AccountingQueryTop accountingQueryTop, AccountingType accountingType) {
        this.accountingQueryTop = accountingQueryTop;
        this.accountingType = accountingType;
    }

    public SeriesResponse execute() throws ServiceException {
        try {
            AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
            logger.debug("Query TopValues: " + this.accountingQueryTop.getFilterKey().getKey());
            logger.debug("Execute Top()");
            apq.setRequestedRecords(this.accountingQueryTop.getType());
            HashSet ctx = null;
            if (this.accountingQueryTop.getContext() != null && this.accountingQueryTop.getContext().getContexts() != null && !this.accountingQueryTop.getContext().getContexts().isEmpty()) {
                ctx = new HashSet(this.accountingQueryTop.getContext().getContexts());
            }
            apq.setContexts(ctx);
            apq.setTemporalConstraint(this.accountingQueryTop.getTemporalConstraint());
            apq.setFilters((Collection)this.accountingQueryTop.getFilters());
            SortedMap topSM = this.accountingQueryTop.getShowOthers() != false ? apq.getTopValues(this.accountingQueryTop.getFilterKey().getKey(), null, true, 0) : apq.getTopValues(this.accountingQueryTop.getFilterKey().getKey(), null, true, this.accountingQueryTop.getTopNumber().intValue());
            if (topSM == null) {
                throw new ServiceException("Error retrieving info for top: sorted map is null!");
            }
            logger.debug("TopSM: " + topSM);
            SeriesResponseBuilder seriesResponseBuilder = this.getSeriesResponseBuilder(this.accountingType, topSM);
            SeriesResponseDirector seriesResponseDirector = new SeriesResponseDirector();
            seriesResponseDirector.setSeriesResponseBuilder(seriesResponseBuilder);
            seriesResponseDirector.constructSeriesResponse();
            SeriesResponse seriesResponse = seriesResponseDirector.getSeriesResponse();
            if (seriesResponse == null) {
                throw new ServiceException("Error creating series response!");
            }
            logger.debug("SeriesResponse Created: " + seriesResponse);
            return seriesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in AccountingCommandTop(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("No data available!");
        }
    }

    private SeriesResponseBuilder getSeriesResponseBuilder(AccountingType accountingType, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) throws ServiceException {
        if (accountingType == null) {
            throw new ServiceException("Error accounting type is null");
        }
        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
            case 1: {
                return new SeriesResponse4JobTop(this.accountingQueryTop.getShowOthers(), this.accountingQueryTop.getTopNumber(), topSM);
            }
            case 2: {
                return new SeriesResponse4PortletTop(this.accountingQueryTop.getShowOthers(), this.accountingQueryTop.getTopNumber(), topSM);
            }
            case 3: {
                return new SeriesResponse4ServiceTop(this.accountingQueryTop.getShowOthers(), this.accountingQueryTop.getTopNumber(), topSM);
            }
            case 4: {
                return new SeriesResponse4StorageTop(this.accountingQueryTop.getShowOthers(), this.accountingQueryTop.getTopNumber(), topSM);
            }
            case 5: {
                return new SeriesResponse4TaskTop(this.accountingQueryTop.getShowOthers(), this.accountingQueryTop.getTopNumber(), topSM);
            }
        }
        throw new ServiceException("Error request type is unknow!");
    }
}

