/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.jsr107.Eh107Configuration;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCache
implements Serializable {
    private static final long serialVersionUID = -4352823042594405108L;
    private static Logger logger = LoggerFactory.getLogger(AccountingCache.class);
    private static final long SERIES_HEAP_DIMENSION_MB = 60L;
    private static final long SERIES_OFFHEAP_DIMENSION_MB = 240L;
    private static final long SERIES_MAXOBJECT_SIZE_MB = 50L;
    private static final long SIERES_TIMETOLIVE_EXPIRATION_MINUTES = 30L;
    private static final long FILTERVALUE_HEAP_DIMENSION_MB = 20L;
    private static final long FILTERVALUE_OFFHEAP_DIMENSION_MB = 60L;
    private static final long FILTERVALUE_MAXOBJECT_SIZE_MB = 6L;
    private static final long FILTERVALUE_TIMETOLIVE_EXPIRATION_MINUTES = 30L;
    private static final String ACCOUNTING_SERIES_CACHE = "AccountingSeriesCache";
    private static final String ACCOUNTING_FILTER_VALUES_CACHE = "AccountingFilterValuesCache";
    private CacheManager cacheManager;
    private CacheConfiguration<String, SeriesResponse> cacheSeriesConfiguration;
    private CacheConfiguration<String, FilterValuesResponse> cacheFilterValuesConfiguration;

    public AccountingCache() throws ServiceException {
        try {
            CachingProvider cachingProvider = Caching.getCachingProvider();
            this.cacheManager = cachingProvider.getCacheManager();
            logger.debug("AccountingCache URI: " + this.cacheManager.getURI());
            ResourcePoolsBuilder builderSeries = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(60L, (ResourceUnit)MemoryUnit.MB).offheap(240L, MemoryUnit.MB);
            this.cacheSeriesConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, SeriesResponse.class, (Builder)builderSeries).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)30L, (TimeUnit)TimeUnit.MINUTES))).withSizeOfMaxObjectSize(50L, MemoryUnit.MB).build();
            ResourcePoolsBuilder builderFilterValues = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(20L, (ResourceUnit)MemoryUnit.MB).offheap(60L, MemoryUnit.MB);
            this.cacheFilterValuesConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, FilterValuesResponse.class, (Builder)builderFilterValues).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)30L, (TimeUnit)TimeUnit.MINUTES))).withSizeOfMaxObjectSize(6L, MemoryUnit.MB).build();
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    private Cache<String, SeriesResponse> initCacheSeries() throws ServiceException {
        try {
            String cacheSeriesName = ACCOUNTING_SERIES_CACHE;
            Cache cacheSeries = this.cacheManager.getCache(cacheSeriesName, String.class, SeriesResponse.class);
            if (cacheSeries == null) {
                cacheSeries = this.cacheManager.createCache(cacheSeriesName, Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)this.cacheSeriesConfiguration));
                this.cacheManager.enableManagement(cacheSeriesName, true);
                this.cacheManager.enableStatistics(cacheSeriesName, true);
            }
            return cacheSeries;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Cache<String, FilterValuesResponse> initCacheFilterValues() throws ServiceException {
        try {
            String cacheFilterValuesName = ACCOUNTING_FILTER_VALUES_CACHE;
            Cache cacheFilterValues = this.cacheManager.getCache(cacheFilterValuesName, String.class, FilterValuesResponse.class);
            if (cacheFilterValues == null) {
                cacheFilterValues = this.cacheManager.createCache(cacheFilterValuesName, Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)this.cacheFilterValuesConfiguration));
                this.cacheManager.enableManagement(cacheFilterValuesName, true);
                this.cacheManager.enableStatistics(cacheFilterValuesName, true);
            }
            return cacheFilterValues;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ServiceException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void putSeries(String key, SeriesResponse value) throws ServiceException {
        logger.debug("Cache put: [" + key + ", " + value + "]");
        Cache cacheSeries = this.initCacheSeries();
        cacheSeries.put((Object)key, (Object)value);
        logger.debug("Cached: [" + key + ", " + value + "]");
    }

    public SeriesResponse getSeries(String key) throws ServiceException {
        logger.debug("Cache get: [" + key + "]");
        Cache cacheSeries = this.initCacheSeries();
        SeriesResponse value = (SeriesResponse)cacheSeries.get((Object)key);
        logger.debug("Cached value: [" + key + ", " + value + "]");
        return value;
    }

    public void putFilterValues(String key, FilterValuesResponse value) throws ServiceException {
        logger.debug("Cache put: [" + key + ", " + value + "]");
        Cache cacheFilterValues = this.initCacheFilterValues();
        cacheFilterValues.put((Object)key, (Object)value);
        logger.debug("Cached: [" + key + ", " + value + "]");
    }

    public FilterValuesResponse getFilterValues(String key) throws ServiceException {
        logger.debug("Cache get: [" + key + "]");
        Cache cacheFilterValues = this.initCacheFilterValues();
        FilterValuesResponse value = (FilterValuesResponse)cacheFilterValues.get((Object)key);
        logger.debug("Cached value: [" + key + ", " + value + "]");
        return value;
    }

    public void finalize() throws Throwable {
        logger.debug("Release the cache resources");
        if (this.cacheManager != null) {
            try {
                for (String cacheName : this.cacheManager.getCacheNames()) {
                    this.cacheManager.destroyCache(cacheName);
                }
            }
            catch (Throwable e) {
                logger.error("Error destroying the AccountingCache: " + e.getLocalizedMessage(), e);
            }
            try {
                this.cacheManager.close();
            }
            catch (Throwable e) {
                logger.error("Error closing AccountingCache manager: " + e.getLocalizedMessage(), e);
            }
        }
        super.finalize();
    }
}

