/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.export.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.gcube.portlets.admin.accountingmanager.server.export.model.AccountingDataModel;
import org.gcube.portlets.admin.accountingmanager.server.export.model.AccountingDataRow;
import org.gcube.portlets.admin.accountingmanager.server.export.model.AccountingModelBuilder;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingModel4Job
extends AccountingModelBuilder {
    protected static Logger logger = LoggerFactory.getLogger(AccountingModel4Job.class);
    private AccountingStateData accountingStateData;

    public AccountingModel4Job(AccountingStateData accountingStateData) {
        this.accountingStateData = accountingStateData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildOpEx() throws ServiceException {
        ArrayList<String> header;
        SeriesRequest seriesRequest = this.accountingStateData.getSeriesRequest();
        if (seriesRequest == null) {
            logger.error("Error series request is null");
            throw new ServiceException("Error series request is null");
        }
        String startDate = "";
        try {
            startDate = this.sdfFile.format(this.sdf.parse(seriesRequest.getAccountingPeriod().getStartDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String endDate = "";
        try {
            endDate = this.sdfFile.format(this.sdf.parse(seriesRequest.getAccountingPeriod().getEndDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String periodType = seriesRequest.getAccountingPeriod().getPeriod().getLabel();
        SeriesResponse seriesResponse = this.accountingStateData.getSeriesResponse();
        if (seriesResponse == null) {
            logger.error("Error series response is null");
            throw new ServiceException("Error series response is null");
        }
        String fileName = "Untitled";
        ArrayList<AccountingDataRow> rows = new ArrayList<AccountingDataRow>();
        if (!(seriesResponse instanceof SeriesJob)) {
            logger.error("Job not support this serie response: " + seriesResponse);
            throw new ServiceException("Job not support this serie response: " + seriesResponse);
        }
        SeriesJob seriesService = (SeriesJob)seriesResponse;
        SeriesJobDefinition definition = seriesService.getSeriesJobDefinition();
        if (definition instanceof SeriesJobBasic) {
            SeriesJobBasic seriesJobBasic = (SeriesJobBasic)definition;
            fileName = "Job_" + periodType + "_" + startDate + "_" + endDate;
            header = new ArrayList<String>(Arrays.asList("Date", "Operation Count", "Duration", "Max Invocation", "Min Invocation"));
            ArrayList listData = seriesJobBasic.getSeries();
            for (SeriesJobData seriesData : listData) {
                ArrayList<String> data = new ArrayList<String>();
                data.add(this.sdfCSVDate.format(seriesData.getDate()));
                data.add(String.valueOf(seriesData.getOperationCount()));
                data.add(String.valueOf(seriesData.getDuration()));
                data.add(String.valueOf(seriesData.getMaxInvocationTime()));
                data.add(String.valueOf(seriesData.getMinInvocationTime()));
                AccountingDataRow csvDataRow = new AccountingDataRow(data);
                rows.add(csvDataRow);
            }
        } else if (definition instanceof SeriesJobTop) {
            SeriesJobTop seriesJobTop = (SeriesJobTop)definition;
            fileName = "JobTop_" + periodType + "_" + startDate + "_" + endDate;
            header = new ArrayList<String>(Arrays.asList("Value", "Date", "Operation Count", "Duration", "Max Invocation", "Min Invocation"));
            ArrayList listDataTop = seriesJobTop.getSeriesJobDataTopList();
            for (SeriesJobDataTop seriesDataTop : listDataTop) {
                FilterValue filterValue = seriesDataTop.getFilterValue();
                ArrayList listData = seriesDataTop.getSeries();
                for (SeriesJobData seriesData : listData) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(filterValue.getValue());
                    data.add(this.sdfCSVDate.format(seriesData.getDate()));
                    data.add(String.valueOf(seriesData.getOperationCount()));
                    data.add(String.valueOf(seriesData.getDuration()));
                    data.add(String.valueOf(seriesData.getMaxInvocationTime()));
                    data.add(String.valueOf(seriesData.getMinInvocationTime()));
                    AccountingDataRow csvDataRow = new AccountingDataRow(data);
                    rows.add(csvDataRow);
                }
            }
        } else {
            if (!(definition instanceof SeriesJobContext)) {
                logger.error("Unsupported Serie Definition for Job: " + definition);
                throw new ServiceException("Unsupported Serie Definition for Job: " + definition);
            }
            SeriesJobContext seriesJobContext = (SeriesJobContext)definition;
            fileName = "JobContext_" + periodType + "_" + startDate + "_" + endDate;
            header = new ArrayList<String>(Arrays.asList("Value", "Date", "Operation Count", "Duration", "Max Invocation", "Min Invocation"));
            ArrayList listDataContext = seriesJobContext.getSeriesJobDataContextList();
            for (SeriesJobDataContext seriesDataContext : listDataContext) {
                ArrayList listData = seriesDataContext.getSeries();
                for (SeriesJobData seriesData : listData) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(seriesDataContext.getContext());
                    data.add(this.sdfCSVDate.format(seriesData.getDate()));
                    data.add(String.valueOf(seriesData.getOperationCount()));
                    data.add(String.valueOf(seriesData.getDuration()));
                    data.add(String.valueOf(seriesData.getMaxInvocationTime()));
                    data.add(String.valueOf(seriesData.getMinInvocationTime()));
                    AccountingDataRow csvDataRow = new AccountingDataRow(data);
                    rows.add(csvDataRow);
                }
            }
        }
        AccountingDataModel invocation = new AccountingDataModel(fileName, header, rows);
        this.accountingModelSpec.setOp(invocation);
    }
}

