/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesJob;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.job.SeriesJobDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4JobTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4JobTop.class);
    private List<Info> infos;

    public SeriesResponse4JobTop(List<Info> infos) {
        this.infos = infos;
    }

    public void buildSeriesResponse() throws AccountingManagerServiceException {
        try {
            if (this.infos.size() <= 0) {
                logger.error("Error creating series for job accounting: No data available!");
                throw new AccountingManagerServiceException("No data available!");
            }
            ArrayList<SeriesJobData> series = new ArrayList<SeriesJobData>();
            for (Info info : this.infos) {
                JSONObject jso = info.getValue();
                Long operationCount = jso.getLong("operationCount");
                series.add(new SeriesJobData(info.getCalendar().getTime(), operationCount, operationCount, operationCount, operationCount));
            }
            SeriesJobBasic seriesJobBasic = new SeriesJobBasic(series);
            SeriesJob seriesJob = new SeriesJob((SeriesJobDefinition)seriesJobBasic);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesJob);
        }
        catch (Throwable e) {
            logger.error("Error creating series for job accounting basic chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("Error creating series for job accounting basic chart: " + e.getLocalizedMessage());
        }
    }
}

