/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.datamodel.aggregation.AggregatedPortletUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBasic;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingQuery4Portlet
extends AccountingQueryBuilder {
    protected static Logger logger = LoggerFactory.getLogger(AccountingQuery4Portlet.class);
    private SeriesRequest seriesRequest;

    public AccountingQuery4Portlet(SeriesRequest seriesRequest) {
        this.seriesRequest = seriesRequest;
    }

    public void buildOpEx() throws AccountingManagerServiceException {
        Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        try {
            startCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getStartDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new AccountingManagerServiceException("Start Date not valid!");
        }
        Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        try {
            endCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getEndDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new AccountingManagerServiceException("End Date not valid!");
        }
        endCalendar.set(11, 23);
        endCalendar.set(12, 59);
        endCalendar.set(13, 59);
        endCalendar.set(14, 999);
        TemporalConstraint temporalConstraint = new TemporalConstraint(startCalendar.getTimeInMillis(), endCalendar.getTimeInMillis(), PeriodModeMap.getMode((AccountingPeriodMode)this.seriesRequest.getAccountingPeriod().getPeriod()));
        ArrayList<Filter> filters = null;
        ArrayList accountingFilters = null;
        if (this.seriesRequest != null && this.seriesRequest.getAccountingFilterDefinition() != null) {
            if (this.seriesRequest.getAccountingFilterDefinition() instanceof AccountingFilterBasic) {
                AccountingFilterBasic accountingFilterBasic = (AccountingFilterBasic)this.seriesRequest.getAccountingFilterDefinition();
                accountingFilters = accountingFilterBasic.getFilters();
            } else if (this.seriesRequest.getAccountingFilterDefinition() instanceof AccountingFilterTop) {
                AccountingFilterTop accountingFilterTop = (AccountingFilterTop)this.seriesRequest.getAccountingFilterDefinition();
                accountingFilters = accountingFilterTop.getFilters();
            }
        }
        if (accountingFilters != null) {
            filters = new ArrayList<Filter>();
            for (AccountingFilter accountigFilters : accountingFilters) {
                Filter filter = new Filter(accountigFilters.getFilterKey().getKey(), accountigFilters.getFilterValue());
                filters.add(filter);
            }
        }
        AccountingQueryBasic invocation = new AccountingQueryBasic(AggregatedPortletUsageRecord.class, temporalConstraint, filters);
        this.accountingQuerySpec.setOp((AccountingQuery)invocation);
    }
}

