/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerSessionExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);

    public static ASLSession getAslSession(HttpSession httpSession) throws AccountingManagerSessionExpiredException {
        ASLSession session;
        String username = (String)httpSession.getAttribute("username");
        if (username == null) {
            logger.warn("no user found in session, use test user");
            username = "giancarlo.panichi";
            String scope = "/gcube";
            httpSession.setAttribute("username", (Object)username);
            session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
            session.setScope(scope);
        } else {
            session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        }
        logger.info("SessionUtil: aslSession " + session.getUsername() + " " + session.getScope());
        return session;
    }
}

