package org.gcube.portlets.admin.accountingmanager.server.amservice.command;

import java.util.ArrayList;
import java.util.List;

import org.gcube.accounting.analytics.ResourceRecordQuery;
import org.gcube.accounting.datamodel.aggregation.AggregatedJobUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 * email: <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class AccountingCommandGetFilterValues implements AccountingCommand<ArrayList<FilterValue>> {
	private static final Logger logger = LoggerFactory.getLogger(AccountingCommandGetFilterValues.class);
	
	private FilterValuesRequest filterValuesRequest;
	
	public AccountingCommandGetFilterValues(FilterValuesRequest filterValuesRequest){
		this.filterValuesRequest=filterValuesRequest;
	
	}
	
	
	@Override
	public ArrayList<FilterValue> execute() throws AccountingManagerServiceException {
		try {
			logger.debug("getFilterValue(): [FilterValueRequest="
					+ filterValuesRequest + "]");
			if (filterValuesRequest == null
					|| filterValuesRequest.getAccountingType() == null
					|| filterValuesRequest.getFilterKey() == null) {
				return new ArrayList<FilterValue>();
			}

			ArrayList<FilterValue> filteValues = new ArrayList<FilterValue>();
			List<String> values;

			ResourceRecordQuery rrq = new ResourceRecordQuery();

			switch (filterValuesRequest.getAccountingType()) {
			case JOB:
				values = rrq.getPossibleValuesForKey(
						AggregatedJobUsageRecord.class, filterValuesRequest
								.getFilterKey().getKey());
				return filteValues;
			case PORTLET:
				// values = rrq.getPossibleValuesForKey(
				// AggregatedPortletUsageRecord.class, filterValuesRequest
				// .getFilterKey().getKey());
				return filteValues;
			case SERVICE:
				values = rrq.getPossibleValuesForKey(
						AggregatedServiceUsageRecord.class, filterValuesRequest
								.getFilterKey().getKey());
				break;
			case STORAGE:
				values = rrq.getPossibleValuesForKey(
						AggregatedStorageUsageRecord.class, filterValuesRequest
								.getFilterKey().getKey());
				break;
			case TASK:
				// values = rrq.getPossibleValuesForKey(
				// AggregatedTaskUsageRecord.class, filterValuesRequest
				// .getFilterKey().getKey());
				return filteValues;
			default:
				return filteValues;
			}
			for (String value : values) {
				if (value != null && !value.isEmpty()) {
					filteValues.add(new FilterValue(value));
				}
			}

			return filteValues;
		} catch (Throwable e) {
			logger.error("Error in AccountingCommandGetFilterValues(): "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new AccountingManagerServiceException("No values available!");

		}
	}

}
