/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.storage;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesArea;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ByteUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorageData;

public class StorageChart
extends SimpleContainer {
    private static final String DATA_VOLUME_UNIT = "Data Volume Unit";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private AccountingStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem kBItem;
    private MenuItem MBItem;
    private MenuItem GBItem;
    private MenuItem TBItem;
    ChartOptions options;
    private VerticalLayoutContainer vert;
    private long unitMeasure = ByteUnitMeasure.getMegaByteDimForStorage();
    private String unitMeasureLabel = "MB";

    public StorageChart(AccountingStateData accountingStateData) {
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        TextButton unitButton = new TextButton(DATA_VOLUME_UNIT, AccountingManagerResources.INSTANCE.accountingDownload24());
        unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        unitButton.setMenu(this.createUnitMenu());
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        this.vert.remove((Widget)this.highchartsLayoutPanel);
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.forceLayout();
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.kBItem = new MenuItem("KiloByte (kB)");
        this.kBItem.setHeight(30);
        this.MBItem = new MenuItem("MegaByte (MB)");
        this.MBItem.setHeight(30);
        this.GBItem = new MenuItem("GigaByte (GB)");
        this.GBItem.setHeight(30);
        this.TBItem = new MenuItem("TeraByte (TB)");
        this.TBItem.setHeight(30);
        this.kBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.MBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.GBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.TBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.kBItem);
        menuUnit.add((Widget)this.MBItem);
        menuUnit.add((Widget)this.GBItem);
        menuUnit.add((Widget)this.TBItem);
        return menuUnit;
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createChart() {
        SeriesStorage seriesStorage = (SeriesStorage)this.accountingStateData.getSeriesResponse();
        double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
        dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
        Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.exporting().buttons().contextButton().enabled(false);
        this.options.exporting().filename("AccountingStorage");
        this.options.title().text("Accounting Storage");
        ArrayString colors = this.options.colors();
        this.options.xAxis().type("datetime").minRange(minRange);
        String multiAxis = "[{ \"id\": \"OperationCount\", \"labels\": {     \"format\": \"{value}\",    \"style\": {       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"title\": { " + "    \"text\": \"Operation Count\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "} , {" + " \"id\": \"DataVolume\", " + " \"title\": {" + "    \"text\": \"Data Volume\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(0) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} " + this.unitMeasureLabel + "\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(0) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + "}]";
        this.options.setFieldAsJsonObject("yAxis", multiAxis);
        String fillcolor = "{\"linearGradient\": {\"x1\": 0,\"y1\": 0,\"x2\": 0,\"y2\": 1},\"stops\": [[0, \"#058DC7\"],[1, \"#FFFFFF\"]]}";
        this.options.plotOptions().area().setFieldAsJsonObject("fillColor", fillcolor).marker().radius(2.0).lineWidth(1.0).states().hover().lineWidth(1.0);
        SeriesColumn seriesOperationCount = highchartsFactory.createSeriesColumn();
        seriesOperationCount.name("Operation Count");
        seriesOperationCount.color(colors.get(1));
        seriesOperationCount.type("column");
        ArrayNumber dataOperationCount = seriesOperationCount.dataAsArrayNumber();
        seriesOperationCount.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesDataVolume = highchartsFactory.createSeriesArea();
        seriesDataVolume.name("Data Volume");
        seriesDataVolume.color(colors.get(0));
        seriesDataVolume.yAxisAsString("DataVolume");
        ArrayNumber dataDataVolume = seriesDataVolume.dataAsArrayNumber();
        seriesDataVolume.pointInterval(interval).pointStart((double)dateStart.getTime());
        for (SeriesStorageData seriesStorageData : seriesStorage.getSeries()) {
            dataOperationCount.push((double)seriesStorageData.getOperationCount().longValue());
            dataDataVolume.push((double)(seriesStorageData.getDataVolume() / this.unitMeasure));
        }
        this.options.series().addToEnd((Object)seriesOperationCount);
        this.options.series().addToEnd((Object)seriesDataVolume);
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    static /* synthetic */ HighchartsLayoutPanel access$000(StorageChart x0) {
        return x0.highchartsLayoutPanel;
    }

    static /* synthetic */ long access$102(StorageChart x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$202(StorageChart x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }

    static /* synthetic */ void access$300(StorageChart x0) {
        x0.updateChart();
    }
}

