/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.service;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesArea;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.button.ToggleButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesService;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesServiceData;

public class ServiceChart
extends SimpleContainer {
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private static final String SINGLE_AXIS = "Single Axis";
    private AccountingStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    ChartOptions options;

    public ServiceChart(AccountingStateData accountingStateData) {
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        ToggleButton toggleButton = new ToggleButton(SINGLE_AXIS);
        toggleButton.setIcon(AccountingManagerResources.INSTANCE.accountingChartVariableAxis24());
        toggleButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        toggleButton.setValue((Object)false);
        toggleButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        toolBar.add((IsWidget)toggleButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createMultiAxisChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        VerticalLayoutContainer vert = new VerticalLayoutContainer();
        vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)vert, new MarginData(0));
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createMultiAxisChart() {
        SeriesService seriesService = (SeriesService)this.accountingStateData.getSeriesResponse();
        double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
        dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
        Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.navigation().buttonOptions().enabled(false);
        this.options.exporting().filename("AccountingService");
        this.options.chart().zoomType("xy");
        this.options.title().text("Accounting Service");
        ArrayString colors = this.options.colors();
        this.options.xAxis().type("datetime").minRange(minRange);
        String multiAxis = "[{ \"id\": \"OperationCount\", \"labels\": {     \"format\": \"{value}\",    \"style\": {       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"title\": { " + "    \"text\": \"Operation Count\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "} , {" + " \"id\": \"Duration\", " + " \"title\": {" + "    \"text\": \"Duration\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(0) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} ms\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(0) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + ", \"showFirstLabel\": \"false\"" + "} , {" + " \"id\": \"MaxInvocationTime\", " + " \"title\": {" + "    \"text\": \"Max Invocation Time\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(2) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} ms\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(2) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + ", \"showFirstLabel\": \"false\"" + "} , {" + " \"id\": \"MinInvocationTime\", " + " \"title\": {" + "    \"text\": \"Min Invocation Time\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(3) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} ms\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(3) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + ", \"showFirstLabel\": \"false\"" + "}]";
        this.options.setFieldAsJsonObject("yAxis", multiAxis);
        String fillcolor = "{\"linearGradient\": {\"x1\": 0,\"y1\": 0,\"x2\": 0,\"y2\": 1},\"stops\": [[0, \"#058DC7\"],[1, \"#FFFFFF\"]]}";
        this.options.plotOptions().area().setFieldAsJsonObject("fillColor", fillcolor).marker().radius(2.0).lineWidth(1.0).states().hover().lineWidth(1.0);
        SeriesColumn seriesOperationCount = highchartsFactory.createSeriesColumn();
        seriesOperationCount.name("Operation Count");
        seriesOperationCount.color(colors.get(1));
        seriesOperationCount.type("column");
        ArrayNumber dataOperationCount = seriesOperationCount.dataAsArrayNumber();
        seriesOperationCount.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesDuration = highchartsFactory.createSeriesArea();
        seriesDuration.name("Duration");
        seriesDuration.color(colors.get(0));
        seriesDuration.yAxisAsString("Duration");
        ArrayNumber dataDuration = seriesDuration.dataAsArrayNumber();
        seriesDuration.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesMaxInvocationTime = highchartsFactory.createSeriesArea();
        seriesMaxInvocationTime.name("Max Invocation Time");
        seriesMaxInvocationTime.color(colors.get(2));
        seriesMaxInvocationTime.yAxisAsString("MaxInvocationTime");
        ArrayNumber dataMaxInvocationTime = seriesMaxInvocationTime.dataAsArrayNumber();
        seriesMaxInvocationTime.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesMinInvocationTime = highchartsFactory.createSeriesArea();
        seriesMinInvocationTime.name("Min Invocation Time");
        seriesMinInvocationTime.color(colors.get(3));
        seriesMinInvocationTime.yAxisAsString("MinInvocationTime");
        ArrayNumber dataMinInvocationTime = seriesMinInvocationTime.dataAsArrayNumber();
        seriesMinInvocationTime.pointInterval(interval).pointStart((double)dateStart.getTime());
        for (SeriesServiceData seriesServiceData : seriesService.getSeries()) {
            dataOperationCount.push((double)seriesServiceData.getOperationCount().longValue());
            dataDuration.push((double)seriesServiceData.getDuration().longValue());
            dataMaxInvocationTime.push((double)seriesServiceData.getMaxInvocationTime().longValue());
            dataMinInvocationTime.push((double)seriesServiceData.getMinInvocationTime().longValue());
        }
        this.options.series().addToEnd((Object)seriesOperationCount);
        this.options.series().addToEnd((Object)seriesDuration);
        this.options.series().addToEnd((Object)seriesMaxInvocationTime);
        this.options.series().addToEnd((Object)seriesMinInvocationTime);
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    private void createSingleAxisChart() {
        SeriesService seriesService = (SeriesService)this.accountingStateData.getSeriesResponse();
        double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
        Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
        dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
        Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.navigation().buttonOptions().enabled(false);
        this.options.exporting().filename("AccountingService");
        this.options.chart().zoomType("xy");
        this.options.title().text("Accounting Service");
        ArrayString colors = this.options.colors();
        this.options.xAxis().type("datetime").minRange(minRange);
        String multiAxis = "[{ \"id\": \"OperationCount\", \"labels\": {     \"format\": \"{value}\",    \"style\": {       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"title\": { " + "    \"text\": \"Operation Count\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }" + "} , {" + " \"id\": \"ServiceData\", " + " \"linkedTo\": \"0\"," + "  \"gridLineWidth\": \"0\"," + " \"title\": {" + "    \"text\": \"\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "    }" + " }," + " \"labels\": {" + "    \"format\": \"{value} ms\"," + "    \"style\": {" + "       \"color\": \"" + colors.get(1) + "\"" + "     }" + " }," + " \"opposite\": \"true\"" + "}]";
        this.options.setFieldAsJsonObject("yAxis", multiAxis);
        String fillcolor = "{\"linearGradient\": {\"x1\": 0,\"y1\": 0,\"x2\": 0,\"y2\": 1},\"stops\": [[0, \"#058DC7\"],[1, \"#FFFFFF\"]]}";
        this.options.plotOptions().area().setFieldAsJsonObject("fillColor", fillcolor).marker().radius(2.0).lineWidth(1.0).states().hover().lineWidth(1.0);
        SeriesColumn seriesOperationCount = highchartsFactory.createSeriesColumn();
        seriesOperationCount.name("Operation Count");
        seriesOperationCount.color(colors.get(1));
        seriesOperationCount.type("column");
        ArrayNumber dataOperationCount = seriesOperationCount.dataAsArrayNumber();
        seriesOperationCount.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesDuration = highchartsFactory.createSeriesArea();
        seriesDuration.name("Duration");
        seriesDuration.color(colors.get(0));
        ArrayNumber dataDuration = seriesDuration.dataAsArrayNumber();
        seriesDuration.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesMaxInvocationTime = highchartsFactory.createSeriesArea();
        seriesMaxInvocationTime.name("Max Invocation Time");
        seriesMaxInvocationTime.color(colors.get(2));
        ArrayNumber dataMaxInvocationTime = seriesMaxInvocationTime.dataAsArrayNumber();
        seriesMaxInvocationTime.pointInterval(interval).pointStart((double)dateStart.getTime());
        SeriesArea seriesMinInvocationTime = highchartsFactory.createSeriesArea();
        seriesMinInvocationTime.name("Min Invocation Time");
        seriesMinInvocationTime.color(colors.get(3));
        ArrayNumber dataMinInvocationTime = seriesMinInvocationTime.dataAsArrayNumber();
        seriesMinInvocationTime.pointInterval(interval).pointStart((double)dateStart.getTime());
        for (SeriesServiceData seriesServiceData : seriesService.getSeries()) {
            dataOperationCount.push((double)seriesServiceData.getOperationCount().longValue());
            dataDuration.push((double)seriesServiceData.getDuration().longValue());
            dataMaxInvocationTime.push((double)seriesServiceData.getMaxInvocationTime().longValue());
            dataMinInvocationTime.push((double)seriesServiceData.getMinInvocationTime().longValue());
        }
        this.options.series().addToEnd((Object)seriesOperationCount);
        this.options.series().addToEnd((Object)seriesDuration);
        this.options.series().addToEnd((Object)seriesMaxInvocationTime);
        this.options.series().addToEnd((Object)seriesMinInvocationTime);
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    static /* synthetic */ void access$000(ServiceChart x0) {
        x0.createSingleAxisChart();
    }

    static /* synthetic */ HighchartsLayoutPanel access$100(ServiceChart x0) {
        return x0.highchartsLayoutPanel;
    }

    static /* synthetic */ void access$200(ServiceChart x0) {
        x0.createMultiAxisChart();
    }
}

