package org.gcube.portlets.admin.action;

import org.gcube.portlets.admin.constants.RPTTokenPortletKeys;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

/**
 * Configuration Action for RPT Token Portlet
 * Handles the configuration interface in Liferay 7.4
 * 
 * @author netfarm-m2
 */
@Component(
    configurationPolicy = ConfigurationPolicy.OPTIONAL,
    immediate = true,
    property = {
        "javax.portlet.name=" + RPTTokenPortletKeys.RPTTOKEN
    },
    service = ConfigurationAction.class
)
public class RPTTokenConfigurationAction extends DefaultConfigurationAction {

    private static final Log _log = LogFactoryUtil.getLog(RPTTokenConfigurationAction.class);

    @Override
    public void processAction(
            PortletConfig portletConfig, ActionRequest actionRequest,
            ActionResponse actionResponse)
        throws Exception {

        String cmd = ParamUtil.getString(actionRequest, "cmd");

        if (!"update".equals(cmd)) {
            return;
        }

        // Get configuration parameters from the form
        String exchangeClientId = ParamUtil.getString(actionRequest, "exchangeClientId");
        String exchangeClientSecret = ParamUtil.getString(actionRequest, "exchangeClientSecret");
        String defaultTokenUrl = ParamUtil.getString(actionRequest, "defaultTokenUrl");
        boolean debugMode = ParamUtil.getBoolean(actionRequest, "debugMode");

        // Validate required fields
        if (Validator.isNull(exchangeClientId)) {
            SessionErrors.add(actionRequest, "exchangeClientIdRequired");
            return;
        }

        if (Validator.isNull(exchangeClientSecret)) {
            SessionErrors.add(actionRequest, "exchangeClientSecretRequired");
            return;
        }

        if (Validator.isNull(defaultTokenUrl)) {
            SessionErrors.add(actionRequest, "defaultTokenUrlRequired");
            return;
        }

        try {
            // Store preferences
            PortletPreferences preferences = actionRequest.getPreferences();
            
            preferences.setValue("exchangeClientId", exchangeClientId);
            preferences.setValue("exchangeClientSecret", exchangeClientSecret);
            preferences.setValue("defaultTokenUrl", defaultTokenUrl);
            preferences.setValue("debugMode", String.valueOf(debugMode));
            
            preferences.store();

            if (_log.isInfoEnabled()) {
                _log.info("RPT Token configuration updated successfully");
                _log.info("Exchange Client ID: " + exchangeClientId);
                _log.info("Default Token URL: " + defaultTokenUrl);
                _log.info("Debug Mode: " + debugMode);
            }

            SessionMessages.add(actionRequest, "configurationSaved");

        } catch (Exception e) {
            _log.error("Error saving RPT Token configuration", e);
            SessionErrors.add(actionRequest, "configurationError");
        }
    }
}