/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.userprofileeditingportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.GenericResource;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.userprofiles.library.impl.UserProfile;
import org.gcube.portlets.user.userprofileeditingportlet.client.UserProfileEditingService;
import org.gcube.portlets.user.userprofileeditingportlet.shared.CollectionInfoBean;
import org.gcube.portlets.user.userprofileeditingportlet.shared.PresentableFieldInfoBean;
import org.gcube.portlets.user.userprofileeditingportlet.shared.SearchPreferencesInformation;
import org.gcube.portlets.user.userprofileeditingportlet.shared.UserPersonalInformation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserProfileEditingServlet
extends RemoteServiceServlet
implements UserProfileEditingService {
    private static Logger logger = Logger.getLogger(UserProfileEditingServlet.class);
    private static final long serialVersionUID = 1L;

    protected static String createStringFromDomTree(Node tree) throws TransformerException {
        String nodeString = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(tree);
        transformer.transform(source, result);
        nodeString = sw.getBuffer().toString();
        return nodeString;
    }

    private static Document parseXMLFileToDOM(String XMLdoc) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(XMLdoc)));
        return doc;
    }

    public UserProfileEditingServlet() {
        try {
        }
        catch (ServletException e) {
            logger.error((Object)"Servlet failed to initialize");
        }
    }

    public void createUserProfile() {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile userProfile = new UserProfile(session);
        try {
            userProfile.createUserProfile(username);
        }
        catch (Exception e) {
            logger.info((Object)"User's profile creation failed");
            logger.debug((Object)e.getMessage());
        }
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    public HashMap<CollectionInfoBean, ArrayList<CollectionInfoBean>> getAvailableCollections() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        HashMap retColInfo = null;
        try {
            HashMap colInfo = shelper.getAvailableCollections();
            if (colInfo != null) {
                retColInfo = new HashMap();
                for (Map.Entry group : colInfo.entrySet()) {
                    CollectionInfo collectionGroup = (CollectionInfo)group.getKey();
                    ArrayList collectionsList = (ArrayList)colInfo.get(collectionGroup);
                    ArrayList<CollectionInfoBean> collectionsBeanList = new ArrayList<CollectionInfoBean>();
                    for (CollectionInfo col : collectionsList) {
                        collectionsBeanList.add(new CollectionInfoBean(col.getId(), col.getName(), col.getDescription()));
                    }
                    retColInfo.put(new CollectionInfoBean(collectionGroup.getId(), collectionGroup.getName(), collectionGroup.getDescription()), collectionsBeanList);
                }
            }
            return retColInfo;
        }
        catch (InitialBridgingNotCompleteException e) {
            logger.error((Object)"Failed to retrieve the available collections. Bridging is not completed yet");
        }
        catch (InternalErrorException e) {
            logger.error((Object)"Failed to retrieve the available collections.");
        }
        return null;
    }

    public HashMap<String, Vector<String[]>> getAvailableXSLTsFromIS(String xsltType) {
        ASLSession session = this.getASLsession();
        GenericResource gResource = new GenericResource(session);
        HashMap xslts = gResource.getAllXslts(xsltType);
        logger.info((Object)("Available " + xsltType + " xslts retrieved from IS. Number of xslts is: " + xslts.size()));
        if (xsltType.equals("PresentationConfig")) {
            session.setAttribute("ispresentationxslts", (Object)xslts);
        } else if (xsltType.equals("MetadataXSLT")) {
            session.setAttribute("ismetadataxslts", (Object)xslts);
        }
        return xslts;
    }

    public UserPersonalInformation getPersonalInformation() {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile userProfile = new UserProfile(session);
        String fullname = "";
        String email = "";
        try {
            fullname = userProfile.getElementValue(username, "/userprofile/userinfo/fullname");
            email = userProfile.getElementValue(username, "/userprofile/userinfo/email");
        }
        catch (Exception e) {
            logger.debug((Object)"An exception was thrown while trying to retrieve the email and fullname");
        }
        UserPersonalInformation persInfo = new UserPersonalInformation(username, fullname, email);
        return persInfo;
    }

    public HashMap<String, ArrayList<String>> getPresentableFieldsFromProfile() {
        HashMap<String, ArrayList<String>> collectionsAndFields = new HashMap<String, ArrayList<String>>();
        String userProfile = this.getUserProfile();
        try {
            Document doc = UserProfileEditingServlet.parseXMLFileToDOM((String)userProfile);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nList = (NodeList)xpath.evaluate("/userprofile/preferences/collections/collection", doc, XPathConstants.NODESET);
            if (nList != null && nList.getLength() > 0) {
                for (int i = 0; i < nList.getLength(); ++i) {
                    Node collectionNode = nList.item(i);
                    String collectionId = ((Element)collectionNode).getAttribute("id");
                    logger.debug((Object)("colID " + collectionId));
                    NodeList childList = collectionNode.getChildNodes();
                    ArrayList<String> pFields = new ArrayList<String>();
                    if (childList != null && childList.getLength() > 0) {
                        for (int j = 0; j < childList.getLength(); ++j) {
                            String presentableFieldID = childList.item(j).getTextContent();
                            logger.debug((Object)("fieldID " + presentableFieldID));
                            pFields.add(presentableFieldID);
                        }
                    }
                    collectionsAndFields.put(collectionId, pFields);
                }
            }
            logger.debug((Object)("Profile variable --> " + collectionsAndFields));
            return collectionsAndFields;
        }
        catch (Exception e) {
            logger.error((Object)"An exception was thrown while trying to parse the user's profile to get the presentable fields", e.getCause());
            return null;
        }
    }

    public HashMap<String, ArrayList<PresentableFieldInfoBean>> getAvailablePresentableFieldsPerCollection() {
        HashMap<String, ArrayList<PresentableFieldInfoBean>> collectionsAndFields = new HashMap<String, ArrayList<PresentableFieldInfoBean>>();
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        try {
            HashMap colInfo = shelper.getAvailableCollections();
            if (colInfo != null) {
                for (Map.Entry group : colInfo.entrySet()) {
                    CollectionInfo collectionGroup = (CollectionInfo)group.getKey();
                    ArrayList collectionsList = (ArrayList)colInfo.get(collectionGroup);
                    for (CollectionInfo col : collectionsList) {
                        ArrayList<PresentableFieldInfoBean> presentableFieldsBeanList = new ArrayList<PresentableFieldInfoBean>();
                        ArrayList pFields = col.getPresentationFields();
                        logger.debug((Object)("Collection ID ->> " + col.getId() + " has " + pFields.size() + " presentable fields"));
                        for (Field f : pFields) {
                            logger.debug((Object)("Adding --> " + f.getLabel() + " (" + f.getId() + ") field to the list"));
                            presentableFieldsBeanList.add(new PresentableFieldInfoBean(f.getId(), f.getLabel()));
                        }
                        collectionsAndFields.put(col.getId(), presentableFieldsBeanList);
                    }
                }
            }
        }
        catch (InitialBridgingNotCompleteException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        return collectionsAndFields;
    }

    public String[][] getProfileMetadataXSLTs() {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile profile = new UserProfile(session);
        String[][] xs = this.getXsltNamesAndIds(profile.getElement(username, "/userprofile/preferences/xslts/metadataxslt/xslt"));
        logger.info((Object)("(Username = " + username + ") Available metadata xslts retrieved from user's profile. Number of xslts is: " + xs.length));
        for (int i = 0; i < xs.length; ++i) {
            logger.info((Object)("SCHEMA name is: '" + xs[i][0] + "'. Selected XSLT is: '" + xs[i][1] + "'."));
        }
        session.setAttribute("profilemetadataxslts", (Object)xs);
        return xs;
    }

    public SearchPreferencesInformation getSearchPreferences() {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile userProfile = new UserProfile(session);
        String language = userProfile.getElementValue(username, "/userprofile/preferences/defLanguage");
        String searchEngineType = userProfile.getElementValue(username, "/userprofile/preferences/searchpreferences/EngineType");
        String searchPersistence = userProfile.getElementValue(username, "/userprofile/preferences/searchpreferences/Persistence");
        String searchFaultTolerance = userProfile.getElementValue(username, "/userprofile/preferences/searchpreferences/FaultTolerance");
        Boolean searchPers = new Boolean(searchPersistence);
        Boolean searchTol = new Boolean(searchFaultTolerance);
        SearchPreferencesInformation searchInfo = new SearchPreferencesInformation(language, searchEngineType, searchTol, searchPers);
        return searchInfo;
    }

    private String getUserProfile() {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile userProfile = new UserProfile(session);
        return userProfile.getUserProfile(username);
    }

    public String[] getUsersFavoriteCollections() {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile profile = new UserProfile(session);
        String[] collIDs = profile.getElement(username, "/userprofile/preferences/searchpreferences/favoritecollections/id");
        logger.info((Object)"Favorite collections retrieved from the user's profile.");
        logger.info((Object)"The IDs of the current user's favorite collections are...");
        if (collIDs != null && collIDs.length > 0) {
            for (int i = 0; i < collIDs.length; ++i) {
                logger.info((Object)("ID >> " + collIDs[i]));
            }
        }
        return collIDs;
    }

    private String[][] getXsltNamesAndIds(String[] xslts) {
        String[][] namesAndIds = new String[xslts.length][2];
        for (int i = 0; i < xslts.length; ++i) {
            int start = xslts[i].indexOf("<name>");
            namesAndIds[i][0] = xslts[i].substring(start += "<name>".length());
            int end = namesAndIds[i][0].indexOf("</name>");
            namesAndIds[i][0] = namesAndIds[i][0].substring(0, end);
            start = xslts[i].indexOf("<id>");
            namesAndIds[i][1] = xslts[i].substring(start += "<id>".length());
            end = namesAndIds[i][1].indexOf("</id>");
            namesAndIds[i][1] = namesAndIds[i][1].substring(0, end);
        }
        return namesAndIds;
    }

    public void setEmailToSession(String email) {
        ASLSession session = this.getASLsession();
        session.setAttribute("profilemail", (Object)email);
    }

    public void setFullnameToSession(String fullname) {
        ASLSession session = this.getASLsession();
        session.setAttribute("profilefullname", (Object)fullname);
    }

    public void setLanguageToSession(String newLanguage) {
        ASLSession session = this.getASLsession();
        session.setAttribute("profilelanguage", (Object)newLanguage);
    }

    public void setPersistenceToSession(String persistence) {
        ASLSession session = this.getASLsession();
        session.setAttribute("profilepersistece", (Object)persistence.toLowerCase());
    }

    public void setSearchEngineToSession(String newEngine) {
        ASLSession session = this.getASLsession();
        session.setAttribute("profileenginetype", (Object)newEngine);
    }

    public void setToleranceToSession(String tolerance) {
        ASLSession session = this.getASLsession();
        session.setAttribute("profilefaulttolerance", (Object)tolerance.toLowerCase());
    }

    public Boolean updatePresentableFieldsToProfile(HashMap<String, ArrayList<PresentableFieldInfoBean>> collectionsAndFields) {
        Boolean isCollectionsUpdated = new Boolean(true);
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile profile = new UserProfile(session);
        if (collectionsAndFields != null && !collectionsAndFields.isEmpty()) {
            String[] collections = profile.getElement(username, "/userprofile/preferences/collections");
            if (collections == null || collections.length == 0) {
                try {
                    logger.debug((Object)"The 'collections' element does not exist in profile. It will be created now.");
                    profile.setElement(username, "/userprofile/preferences", "collections", "");
                }
                catch (Exception e) {
                    isCollectionsUpdated = false;
                    logger.error((Object)("An error occurred trying to update the presentable fields for each collection to the user profile: '" + username + "'. " + "The collections element failed to be created."));
                    return isCollectionsUpdated;
                }
            } else if (profile.getElement(username, "/userprofile/preferences/collections/collection") != null) {
                logger.debug((Object)"All the 'collection' elements that are children of the <collections> element will be deleted.");
                Boolean deleted = profile.deleteElement(username, "/userprofile/preferences/collections/collection");
                if (!deleted.booleanValue()) {
                    isCollectionsUpdated = false;
                    return isCollectionsUpdated;
                }
            }
            logger.debug((Object)"The presentable fields for each collection will be inserted in the user's profile");
            String userProfile = profile.getUserProfile(username);
            try {
                Document doc = UserProfileEditingServlet.parseXMLFileToDOM((String)userProfile);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node collectionsNode = (Node)xpath.evaluate("/userprofile/preferences/collections", doc, XPathConstants.NODE);
                for (String key : collectionsAndFields.keySet()) {
                    ArrayList<PresentableFieldInfoBean> fields = collectionsAndFields.get(key);
                    if (fields == null || fields.isEmpty()) continue;
                    Element colEl = doc.createElement("collection");
                    colEl.setAttribute("id", key);
                    collectionsNode.appendChild(colEl);
                    for (PresentableFieldInfoBean field : fields) {
                        Element fieldEl = doc.createElement("field");
                        fieldEl.setTextContent(field.getId());
                        colEl.appendChild(fieldEl);
                    }
                }
                String updatedProfile = UserProfileEditingServlet.createStringFromDomTree((Node)doc);
                logger.debug((Object)("The updated profile is --> " + updatedProfile));
                profile.setUserProfile(username, updatedProfile);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to add the new elements to the profile. Presentable fields are not set.", e.getCause());
                isCollectionsUpdated = false;
                return isCollectionsUpdated;
            }
        }
        return isCollectionsUpdated;
    }

    public Boolean updateUserProfile(HashMap<String, ArrayList<PresentableFieldInfoBean>> selectedFieldsPerCollection) {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile profile = new UserProfile(session);
        boolean isProfileUpdated = true;
        try {
            if ((String)session.getAttribute("profileenginetype") != null) {
                profile.setElementValue(username, "/userprofile/preferences/searchpreferences/EngineType", (String)session.getAttribute("profileenginetype"));
            }
            if ((String)session.getAttribute("profilefaulttolerance") != null) {
                profile.setElementValue(username, "/userprofile/preferences/searchpreferences/FaultTolerance", (String)session.getAttribute("profilefaulttolerance"));
            }
            if ((String)session.getAttribute("profilepersistece") != null) {
                profile.setElementValue(username, "/userprofile/preferences/searchpreferences/Persistence", (String)session.getAttribute("profilepersistece"));
            }
            if ((String)session.getAttribute("profilelanguage") != null) {
                profile.setElementValue(username, "/userprofile/preferences/defLanguage", (String)session.getAttribute("profilelanguage"));
            }
            if ((String)session.getAttribute("profilefullname") != null) {
                profile.setElementValue(username, "/userprofile/userinfo/fullname", (String)session.getAttribute("profilefullname"));
            }
            if ((String)session.getAttribute("profilemail") != null) {
                profile.setElementValue(username, "/userprofile/userinfo/email", (String)session.getAttribute("profilemail"));
            }
            logger.info((Object)"The user's search preferences and personal information are saved...");
            isProfileUpdated = this.updatePresentableFieldsToProfile(selectedFieldsPerCollection);
        }
        catch (Exception e) {
            isProfileUpdated = false;
            logger.error((Object)("Exception -> " + e.getMessage()));
            logger.error((Object)("An exception was thrown while trying to update the profile of the user: '" + username + "'"));
        }
        return new Boolean(isProfileUpdated);
    }

    public void updateXSLT(String xsltType, String schemaName, String schemaValue, String schemaID) {
        ASLSession session = this.getASLsession();
        String username = session.getUsername();
        UserProfile profile = new UserProfile(session);
        String pathToProfile = null;
        String[][] profileXSLTS = null;
        if (xsltType.equals("PresentationConfig")) {
            pathToProfile = "/userprofile/preferences/xslts/presentationxslt";
            profileXSLTS = (String[][])session.getAttribute("profilepresentationxslts");
        } else if (xsltType.equals("MetadataXSLT")) {
            pathToProfile = "/userprofile/preferences/xslts/metadataxslt";
            profileXSLTS = (String[][])session.getAttribute("profilemetadataxslts");
        } else {
            logger.error((Object)"Wrong type of XSLT as a parameter");
            return;
        }
        try {
            logger.debug((Object)("The schema to be updated is: " + schemaName));
            logger.debug((Object)("The new xslt to be set is: " + schemaValue + "  with ID: '" + schemaID + "'"));
            if (profileXSLTS != null) {
                boolean existInProfile = false;
                for (int i = 0; i < profileXSLTS.length; ++i) {
                    if (!profileXSLTS[i][0].substring(0, profileXSLTS[i][0].lastIndexOf("-|-")).equals(schemaName)) continue;
                    logger.debug((Object)"The schema exists in profile and so the name and the ID of the xslt will be updated in profile");
                    existInProfile = true;
                    profile.setElementValue(username, pathToProfile + "/xslt/name[starts-with(.,'" + schemaName + "')]", schemaName + "-|-" + schemaValue);
                    profile.setElementValue(username, pathToProfile + "/xslt[name[starts-with(.,'" + schemaName + "')]]/id", schemaID);
                    break;
                }
                if (!existInProfile) {
                    logger.debug((Object)"The schema does not exist in profile. A new entry should be created for this schema");
                    profile.setElement(username, pathToProfile, "xslt", "");
                    profile.setElement(username, pathToProfile + "/xslt[not(name)]", "name", schemaName + "-|-" + schemaValue);
                    profile.setElement(username, pathToProfile + "/xslt[not(id)]", "id", schemaID);
                }
                logger.info((Object)"The XSLT has been succesfully updated.");
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An exception was thrown while trying to update the selected xslt at the user's profile");
            logger.debug((Object)("Message of the exception is: >>> " + e.getMessage()));
        }
    }
}

