/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.searchportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.Criterion;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.QueryGroup;
import org.gcube.application.framework.search.library.util.Operator;
import org.gcube.application.framework.search.library.util.Order;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.searchportlet.client.SearchConstantsStrings;
import org.gcube.portlets.user.searchportlet.client.exceptions.SearchSubmissionException;
import org.gcube.portlets.user.searchportlet.client.interfaces.SearchService;
import org.gcube.portlets.user.searchportlet.server.EmailNotification;
import org.gcube.portlets.user.searchportlet.server.ErrorNotificationEmailMessageTemplate;
import org.gcube.portlets.user.searchportlet.server.FileUtils;
import org.gcube.portlets.user.searchportlet.shared.BrowsableFieldBean;
import org.gcube.portlets.user.searchportlet.shared.PreviousResultsInfo;
import org.gcube.portlets.user.searchportlet.shared.SavedBasketQueriesInfo;
import org.gcube.portlets.user.searchportlet.shared.SearchAvailabilityType;
import org.gcube.portlets.user.searchportlet.shared.SearchableFieldBean;

public class SearchServlet
extends RemoteServiceServlet
implements SearchService {
    private static Logger logger = Logger.getLogger(SearchServlet.class);
    private static final int DefaultQuery = 0;
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
    }

    public void addSearchField(SearchableFieldBean sField) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.addCriterion(new Criterion(sField.getId(), sField.getName(), ""));
        logger.debug((Object)"Added new search field in advanced search with empty value.");
        logger.debug((Object)("Name -> " + sField.getName() + " ID -> " + sField.getId()));
    }

    public void addSearchFieldOnPreviousQuery(SearchableFieldBean sField) {
        logger.debug((Object)"Add new search field in previous search with empty value.");
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        logger.debug((Object)("Index of previous query is: " + (Integer)session.getAttribute("previousQueryIndex")));
        Query queryObj = queryGroup.getQuery(0);
        queryObj.addCriterion(new Criterion(sField.getId(), sField.getName(), ""));
        logger.debug((Object)("Added new criterion.......... with name: " + sField.getName()));
        logger.debug((Object)"Now the criteria are... ");
        List tmp = queryObj.getCriteria();
        if (tmp != null && tmp.size() > 0) {
            for (int t = 0; t < tmp.size(); ++t) {
                logger.debug((Object)(t + 1 + ") CRITERION: " + ((Criterion)tmp.get(t)).getSearchFieldName() + " VALUE: " + ((Criterion)tmp.get(t)).getSearchFieldValue()));
            }
        } else if (tmp == null) {
            logger.debug((Object)"CRITERIA ARE NULL");
        } else {
            logger.debug((Object)"CRITERIA SIZE IS <=0");
        }
    }

    public SearchableFieldBean[] createPreviousQuery(int indexOfQueryGroupToClone) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        logger.info((Object)("Create a new previous query for the query with index: " + indexOfQueryGroupToClone));
        int id = shelper.createQuery(indexOfQueryGroupToClone, new boolean[]{true});
        logger.debug((Object)"The previous query was just created..... Printing some information");
        session.setAttribute("previousQueryIndex", (Object)new Integer(id));
        logger.debug((Object)("Previous query index just set to the session. The index is: " + id));
        logger.debug((Object)("The search type is: " + ((Query)shelper.getQuery(id).getQueries().get(0)).getSearchType()));
        List sf = null;
        logger.debug((Object)"Available search fields are....");
        sf = ((Query)shelper.getQuery(id).getQueries().get(0)).getAvailableSearchFields();
        if (sf == null || sf.isEmpty()) {
            logger.error((Object)"This previous query does not have searchable fields and won't be used");
            return null;
        }
        SearchableFieldBean[] searchableFields = new SearchableFieldBean[sf.size()];
        for (int k = 0; k < sf.size(); ++k) {
            logger.debug((Object)("Search field name: " + ((Field)sf.get(k)).getName()));
            searchableFields[k] = new SearchableFieldBean(((Field)sf.get(k)).getId(), ((Field)sf.get(k)).getName(), ((Field)sf.get(k)).getValue());
        }
        logger.debug((Object)("The description of the query to be refined is: " + ((Query)shelper.getQuery(indexOfQueryGroupToClone).getQueries().get(0)).getQueryDescription()));
        return searchableFields;
    }

    private String createTheDisplayQuery(Query q) {
        String displayQuery = q.getQueryDescription();
        logger.debug((Object)("The display query is: <<<<" + displayQuery + ">>>>"));
        return displayQuery;
    }

    public ArrayList<String> getAvailableLanguages() {
        ASLSession session = this.getASLsession();
        SearchHelper sHelper = new SearchHelper(session);
        QueryGroup queryGroup = sHelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        return (ArrayList)queryObj.getAvailableLanguages();
    }

    public ArrayList<BrowsableFieldBean> getBrowsableFields() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        List browsableFields = queryObj.getAvailableBrowseFields();
        if (browsableFields != null) {
            ArrayList<BrowsableFieldBean> brFieldsBean = new ArrayList<BrowsableFieldBean>();
            for (Field bf : browsableFields) {
                String bfID = bf.getId();
                String bfName = bf.getName();
                logger.debug((Object)("Browsable field -> " + bfID + " - " + bfName));
                brFieldsBean.add(new BrowsableFieldBean(bfID, bfName));
            }
            return brFieldsBean;
        }
        return null;
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    public Integer getNumberOfSelectedCollections() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        try {
            int numOfRealSelectedCollections = queryObj.getSelectedRealCollections(session).size();
            logger.debug((Object)("Number of real selected collections is: " + numOfRealSelectedCollections));
            return new Integer(numOfRealSelectedCollections);
        }
        catch (InitialBridgingNotCompleteException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedList<PreviousResultsInfo> getPreviousQueries() {
        ASLSession session = this.getASLsession();
        LinkedList<PreviousResultsInfo> previousQueries = new LinkedList<PreviousResultsInfo>();
        SearchHelper shelper = new SearchHelper(session);
        if (shelper.getNumberOfQueryGroups() >= 1) {
            logger.info((Object)"Retrieving the previous queries. Only 'Advaned' and 'Simple' search queries will be used");
            List queryGroup = shelper.getAllQueries();
            for (int i = 0; i < queryGroup.size(); ++i) {
                Query currentQuery = ((QueryGroup)queryGroup.get(i)).getQuery(0);
                if (!currentQuery.getSearchType().equals("advancedSearch") && !currentQuery.getSearchType().equals("simpleSearch") || currentQuery.getAvailableSearchFields().size() <= 0) continue;
                logger.info((Object)("Previous query found. The index of the advanced or simple query is: " + i));
                logger.info((Object)("The search type of the " + i + "  query is: " + currentQuery.getSearchType()));
                PreviousResultsInfo prevInfo = new PreviousResultsInfo(currentQuery.getQueryDescription(), this.createTheDisplayQuery(currentQuery), i);
                previousQueries.add(prevInfo);
                logger.info((Object)("Description is: " + prevInfo.getQuery()));
                logger.info((Object)("The index is: " + prevInfo.getIndexOfQueryGroup()));
            }
        }
        session.setAttribute("previousResultsInfo", previousQueries);
        return previousQueries;
    }

    public SavedBasketQueriesInfo getQueryFromBasket(String id) {
        SavedBasketQueriesInfo queryInfo;
        block9: {
            String descriptionQuery = null;
            String queryType = null;
            queryInfo = null;
            QueryType qType = null;
            Workspace root = null;
            ASLSession session = this.getASLsession();
            try {
                root = HomeLibrary.getUserWorkspace((ASLSession)session);
                WorkspaceItem item = null;
                try {
                    item = root.getItem(id);
                    if (!item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) break block9;
                    FolderItem bItem = (FolderItem)item;
                    if (bItem.getFolderItemType() == FolderItemType.QUERY) {
                        org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query query = (org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query)bItem;
                        descriptionQuery = query.getQuery();
                        qType = query.getQueryType();
                        if (qType != null) {
                            queryType = qType.equals((Object)QueryType.GOOGLE_SEARCH) ? "Google Search" : (qType.equals((Object)QueryType.SIMPLE_SEARCH) ? "Simple Search" : (qType.equals((Object)QueryType.QUICK_SEARCH) ? "Quick Search" : (qType.equals((Object)QueryType.GEO_SEARCH) ? "Geospatial Search" : "Combined Search")));
                            logger.debug((Object)("The query type that i set is : " + queryType));
                        } else {
                            queryType = "Combined Search";
                        }
                        logger.debug((Object)("The selected item's type was a query. The description of the selected item is: << " + descriptionQuery + " >>"));
                        queryInfo = new SavedBasketQueriesInfo(descriptionQuery, queryType);
                        break block9;
                    }
                    logger.debug((Object)"The selected item's type was not query...");
                }
                catch (ItemNotFoundException e) {
                    logger.error((Object)"An exception was thrown while trying to get the query's description", (Throwable)e);
                    e.printStackTrace();
                }
            }
            catch (org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException e) {
                logger.error((Object)"An internal error occured.");
            }
            catch (HomeNotFoundException e) {
                logger.error((Object)"Home not found");
            }
            catch (WorkspaceException e) {
                logger.error((Object)"Workspace not found");
            }
        }
        return queryInfo;
    }

    public Integer getResultsNumberPerPage() {
        ASLSession session = this.getASLsession();
        return (Integer)session.getAttribute("RESULTS_NUMBER_PER_PAGE");
    }

    public ArrayList<SearchableFieldBean> getSearchFields() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        List sFields = queryObj.getAvailableSearchFields();
        if (sFields != null && sFields.size() > 0) {
            ArrayList<SearchableFieldBean> sFieldsBean = new ArrayList<SearchableFieldBean>();
            logger.debug((Object)"Retrieving the available search fields for the current selected collections...");
            for (Field sf : sFields) {
                sFieldsBean.add(new SearchableFieldBean(sf.getId(), sf.getName(), sf.getValue()));
                logger.debug((Object)("Searchfield -> " + sf.getId() + " - " + sf.getName()));
            }
            return sFieldsBean;
        }
        return null;
    }

    public String getSelectedConditionType() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        Operator op = queryObj.getOperator();
        if (op.equals((Object)Operator.AND)) {
            return "AND";
        }
        return "OR";
    }

    public String getSelectedConditionTypeOnPreviousSearch() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        Query queryObj = queryGroup.getQuery(0);
        Operator op = queryObj.getOperator();
        if (op.equals((Object)Operator.AND)) {
            return "AND";
        }
        return "OR";
    }

    public ArrayList<SearchableFieldBean> getSelectedFields() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        List criteria = queryObj.getCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            ArrayList<SearchableFieldBean> selectedCriteriaBean = new ArrayList<SearchableFieldBean>();
            for (Criterion c : criteria) {
                selectedCriteriaBean.add(new SearchableFieldBean(c.getSearchFieldId(), c.getSearchFieldName(), c.getSearchFieldValue()));
                logger.debug((Object)("Selected Searchfield -> " + c.getSearchFieldId() + " - " + c.getSearchFieldName()));
            }
            return selectedCriteriaBean;
        }
        return null;
    }

    public ArrayList<SearchableFieldBean> getSelectedFieldsOnPreviousSearch() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        logger.debug((Object)("Get the searchable fields of the previous query with index --> " + (Integer)session.getAttribute("previousQueryIndex")));
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        Query queryObj = queryGroup.getQuery(0);
        List criteria = queryObj.getCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            ArrayList<SearchableFieldBean> selectedCriteriaBean = new ArrayList<SearchableFieldBean>();
            for (Criterion c : criteria) {
                selectedCriteriaBean.add(new SearchableFieldBean(c.getSearchFieldId(), c.getSearchFieldName(), c.getSearchFieldValue()));
                logger.debug((Object)("Previous search criteria are: \n Name: " + c.getSearchFieldName() + " - Value: " + c.getSearchFieldValue()));
            }
            return selectedCriteriaBean;
        }
        return null;
    }

    public String getSelectedLanguage() {
        ASLSession session = this.getASLsession();
        SearchHelper sHelper = new SearchHelper(session);
        QueryGroup queryGroup = sHelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        return queryObj.getSelectedLanguage();
    }

    public Integer getSelectedTab() {
        ASLSession session = this.getASLsession();
        logger.debug((Object)("The selected tab in servlet is: " + (Integer)session.getAttribute("tabName")));
        return (Integer)session.getAttribute("tabName");
    }

    public Boolean getSelectedRadioBtn() {
        ASLSession session = this.getASLsession();
        return (Boolean)session.getAttribute(SearchConstantsStrings.SESSION_SELECTED_RADIO_BASKET);
    }

    public boolean isAdvancedOpen() {
        ASLSession session = this.getASLsession();
        if (session.getAttribute(SearchConstantsStrings.SESSION_ADVANCED_OPENED) != null) {
            return (Boolean)session.getAttribute(SearchConstantsStrings.SESSION_ADVANCED_OPENED);
        }
        return false;
    }

    public String getSimpleSearchTerm() {
        ASLSession session = this.getASLsession();
        return (String)session.getAttribute(SearchConstantsStrings.SESSION_SIMPLE_TERM);
    }

    public void setSimpleSearchTerm(String term) {
        ASLSession session = this.getASLsession();
        session.setAttribute(SearchConstantsStrings.SESSION_SIMPLE_TERM, (Object)term);
    }

    public ArrayList<SearchableFieldBean> getSortableFields() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        List sortFields = queryObj.getAvailableSortFields();
        if (sortFields != null) {
            ArrayList<SearchableFieldBean> sortableFieldsBean = new ArrayList<SearchableFieldBean>();
            for (Field sf : sortFields) {
                sortableFieldsBean.add(new SearchableFieldBean(sf.getId(), sf.getName(), sf.getValue()));
            }
            return sortableFieldsBean;
        }
        return null;
    }

    private void handleSearchExceptions(Exception e) throws SearchSubmissionException {
        logger.error((Object)"An exception was thrown while submiting the query.", (Throwable)e);
        throw new SearchSubmissionException(e.getMessage());
    }

    public SearchAvailabilityType getSearchStatus() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        try {
            int numOfSelCols = queryObj.getSelectedRealCollections(session).size();
            if (numOfSelCols <= 0) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.NO_COLLECTION_SELECTED.toString()));
                return SearchAvailabilityType.NO_COLLECTION_SELECTED;
            }
            boolean hasFTS = queryObj.isFtsAvailable();
            boolean hasGeo = queryObj.isGeoAvailable();
            logger.debug((Object)("SEARCH STATUS: server response for FTS & GEO --> " + hasFTS + " & " + hasGeo));
            if (hasFTS && hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.FTS_GEO_AVAILABLE.toString()));
                return SearchAvailabilityType.FTS_GEO_AVAILABLE;
            }
            if (hasFTS && !hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.FTS_NOGEO_AVAILABLE.toString()));
                return SearchAvailabilityType.FTS_NOGEO_AVAILABLE;
            }
            if (!hasFTS && hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.GEO_NOFTS_AVAILABLE.toString()));
                return SearchAvailabilityType.GEO_NOFTS_AVAILABLE;
            }
            if (!hasFTS && !hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.NOFTS_NOGEO_AVAILABLE.toString()));
                return SearchAvailabilityType.NOFTS_NOGEO_AVAILABLE;
            }
            logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.SEARCH_UNAVAILABLE.toString()));
            return SearchAvailabilityType.SEARCH_UNAVAILABLE;
        }
        catch (InitialBridgingNotCompleteException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        return SearchAvailabilityType.SEARCH_UNAVAILABLE;
    }

    public void removeSearchField(int searchFieldNo) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.removeCriterion(searchFieldNo);
        logger.debug((Object)("Criterion with index: '" + searchFieldNo + "' has just been removed from advanced search."));
    }

    public void removeSearchFieldOnPreviousQuery(int searchFieldNo) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        int prevIndex = (Integer)session.getAttribute("previousQueryIndex");
        logger.debug((Object)("The previous query index is --> " + prevIndex));
        QueryGroup queryGroup = shelper.getQuery(prevIndex);
        Query queryObj = queryGroup.getQuery(0);
        queryObj.removeCriterion(searchFieldNo);
        logger.debug((Object)("Criterion with index: '" + searchFieldNo + "' has just been removed from previous search."));
    }

    public void resetFields(boolean isPrevious) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = isPrevious ? shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue()) : shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.reset();
        logger.debug((Object)"Search criteria have been reset.");
    }

    public void sendEmailWithErrorToSupport(Throwable caught) {
        String subject = "[PORTAL-iMarine] Search Portlet - Error Notification";
        String[] rec = new String[]{"support_team@d4science.org"};
        try {
            String senderEmail = "no-reply@imarine.research-infrastructures.eu";
            ErrorNotificationEmailMessageTemplate msgTemp = new ErrorNotificationEmailMessageTemplate(caught, this.getASLsession().getUsername(), this.getASLsession().getGroupName());
            EmailNotification emailNot = new EmailNotification(senderEmail, rec, subject, msgTemp.createBodyMessage(), "to", false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send the email to the support team.", (Throwable)e);
        }
    }

    public Boolean setSelectedLanguage(String language) {
        ASLSession session = this.getASLsession();
        SearchHelper sHelper = new SearchHelper(session);
        QueryGroup queryGroup = sHelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        try {
            queryObj.setSelectedLanguage(language, session);
        }
        catch (InitialBridgingNotCompleteException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        boolean ret = false;
        ret = queryObj.isGeoAvailable();
        return new Boolean(ret);
    }

    public void setSelectedTab(Integer x) {
        ASLSession session = this.getASLsession();
        session.setAttribute("tabName", (Object)x);
    }

    public void setAdvancedPanelStatus(boolean isOpened) {
        ASLSession session = this.getASLsession();
        session.setAttribute(SearchConstantsStrings.SESSION_ADVANCED_OPENED, (Object)new Boolean(isOpened));
    }

    public void setSelectedRadioBtn(boolean isBasketSelected) {
        ASLSession session = this.getASLsession();
        session.setAttribute(SearchConstantsStrings.SESSION_SELECTED_RADIO_BASKET, (Object)new Boolean(isBasketSelected));
    }

    public String stackTraceAsString(Throwable caught) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        caught.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public void storeConditionType(String newValue) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.setOperator(newValue.toLowerCase().equals("and") ? Operator.AND : Operator.OR);
        logger.debug((Object)("Operator changed in the advanced query. The operator now is: '" + newValue + "'."));
    }

    public void storeConditionTypeOnPreviousSearch(String newValue) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        Query queryObj = queryGroup.getQuery(0);
        queryObj.setOperator(newValue.toLowerCase().equals("and") ? Operator.AND : Operator.OR);
        logger.debug((Object)("Operator changed in the previous query. The operator now is: '" + newValue + "'."));
    }

    public void storeSelectedFieldsOnPreviousSearch(int fieldNo, int internalNo, String newValue) {
        ASLSession session = this.getASLsession();
        List selectedFields = (List)session.getAttribute("prevRSselectedFields");
        if (selectedFields != null) {
            String[] seacrhField = (String[])selectedFields.get(fieldNo);
            seacrhField[internalNo] = newValue;
            selectedFields.set(fieldNo, seacrhField);
            session.setAttribute("prevRSselectedFields", (Object)selectedFields);
        }
    }

    public void submitAdvancedQuery(ArrayList<SearchableFieldBean> criteria, String sortby, String order, boolean searchPerCollection, boolean isSemanticEnriched) throws SearchSubmissionException {
        long startTimeofSubmission = System.currentTimeMillis();
        logger.debug((Object)("Current time in seconds is: <<" + startTimeofSubmission / 1000L + ">>"));
        logger.debug((Object)"Query (queries) will be submitted now.........");
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        if (sortby != null) {
            queryObj.setSortBy(sortby);
        }
        if (order != null) {
            queryObj.setOrder(order.equals("ASC") ? Order.ASC : Order.DESC);
        }
        queryObj.setSemanticEnrichment(isSemanticEnriched);
        if (criteria != null) {
            int numOfActiveCriteriaAtTheQuery = queryObj.getCriteria().size();
            for (int i = 0; i < criteria.size(); ++i) {
                if (criteria.size() == numOfActiveCriteriaAtTheQuery) {
                    logger.debug((Object)("There is an existing criterion. Setting the latest value -> " + criteria.get(i).getValue()));
                    queryObj.updateCriterionValue(i, criteria.get(i).getValue());
                    continue;
                }
                if (criteria.size() <= numOfActiveCriteriaAtTheQuery) continue;
                for (int j = numOfActiveCriteriaAtTheQuery; j < criteria.size(); ++j) {
                    logger.debug((Object)"Adding new criterion to query....");
                    logger.debug((Object)(criteria.get(j).getId() + " - " + criteria.get(j).getName() + " - " + criteria.get(j).getValue()));
                    queryObj.addCriterion(new Criterion(criteria.get(j).getId(), criteria.get(j).getName(), criteria.get(j).getValue()));
                }
            }
        }
        logger.info((Object)"Starting constructing the query for advanced search.");
        session.setAttribute("activePresentationQueryNo", (Object)new Integer(shelper.getActiveQueryGroupNo()));
        session.removeAttribute("RESULTS_NUMBER_PER_PAGE");
        logger.info((Object)("The value of searchPerCollection is: " + searchPerCollection));
        try {
            if (searchPerCollection) {
                int numOfQueries = queryObj.getSelectedRealCollections(session).size();
                Query newQuery = null;
                for (int i = 0; i < numOfQueries - 1; ++i) {
                    newQuery = queryObj.clone(false);
                    List colToRemove = newQuery.getSelectedRealCollections(session);
                    colToRemove.remove(i);
                    newQuery.selectCollections(colToRemove, false, session);
                    queryGroup.setQuery(newQuery);
                }
                List collectionsToRemove = queryObj.getSelectedRealCollections(session);
                collectionsToRemove.remove(queryObj.getSelectedRealCollections(session).get(numOfQueries - 1));
                queryObj.selectCollections(collectionsToRemove, false, session);
                logger.info((Object)"STARTING PERFORMING SEARCH IN ALL QUERIES!!!!!");
                logger.info((Object)("NUMBER OF QUERIES TO PERFORM IS: " + numOfQueries));
                for (int j = 0; j < numOfQueries; ++j) {
                    logger.debug((Object)("for the " + (j + 1) + "query, selected collections are:  " + queryGroup.getQuery(j).getSelectedRealCollections(session).size()));
                    try {
                        queryGroup.getQuery(j).search(session, false);
                    }
                    catch (Exception e) {
                        this.handleSearchExceptions(e);
                    }
                    logger.debug((Object)("for the " + (j + 1) + "query, the description is: " + queryGroup.getQuery(j).getQueryDescription()));
                }
            } else {
                logger.debug((Object)"IN SEARCH SERVLET PRINTING INFORMATION ABOUT THE ADVANCED SEARCH AND THE QUERY");
                logger.debug((Object)"********************************************************************************");
                logger.debug((Object)("NUMBER OF REAL SELECTED COLLECTIONS IS: " + queryObj.getSelectedRealCollections(session).size()));
                logger.debug((Object)("NUMBER OF SELECTED COLLECTIONS IS: " + queryObj.getSelectedCollections().size()));
                logger.debug((Object)("SORT VALUE IS: " + queryObj.getSortBy()));
                logger.debug((Object)("SORT ORDER IS: " + queryObj.getOrder()));
                logger.debug((Object)("NUMBER OF CRITERIA IS: " + queryObj.getCriteria().size()));
                logger.debug((Object)"The criteria are: ");
                for (int l = 0; l < queryObj.getCriteria().size(); ++l) {
                    logger.debug((Object)("CRITERION: (" + (l + 1) + ") with name: '" + ((Criterion)queryObj.getCriteria().get(l)).getSearchFieldName() + "' with value: '" + ((Criterion)queryObj.getCriteria().get(l)).getSearchFieldValue() + "' ."));
                }
                logger.debug((Object)"********************************************************************************");
                try {
                    queryObj.search(session, false);
                }
                catch (Exception e) {
                    this.handleSearchExceptions(e);
                }
                long endTimeOfSubmission = System.currentTimeMillis();
                logger.debug((Object)("QUERY description is: <<<<<<<<<" + queryObj.getQueryString() + ">>>>>>>>"));
                logger.debug((Object)("Query (queries) submission ended. Current time in seconds is: <<" + endTimeOfSubmission / 1000L + ">>"));
                logger.debug((Object)("Total time needed for the submission of the query (queries) is: <<" + (endTimeOfSubmission - startTimeofSubmission) / 1000L + ">> seconds"));
            }
            logger.info((Object)("Active presentation query is: " + (Integer)session.getAttribute("activePresentationQueryNo")));
            int id = shelper.createQuery(shelper.getActiveQueryGroupNo(), new boolean[0]);
            shelper.setActiveQueryGroup(id);
        }
        catch (InitialBridgingNotCompleteException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
    }

    public Boolean submitBrowseQuery(BrowsableFieldBean browseBy, String sortOrder, String typeOfBrowse, int resultNumPerPage) throws SearchSubmissionException {
        long startTimeofSubmission = System.currentTimeMillis();
        logger.debug((Object)("Current time in seconds is: <<" + startTimeofSubmission / 1000L + ">>"));
        logger.debug((Object)"Browse query will be submitted now.........");
        Boolean ret = new Boolean(true);
        ASLSession session = this.getASLsession();
        logger.debug((Object)("Results number per page is: '" + resultNumPerPage + "'"));
        session.setAttribute("RESULTS_NUMBER_PER_PAGE", (Object)new Integer(resultNumPerPage));
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.setBrowseBy(browseBy.getId());
        logger.info((Object)("Browsing collection by: " + browseBy.getName()));
        queryObj.setOrder(sortOrder.toLowerCase().equals("asc") ? Order.ASC : Order.DESC);
        if (typeOfBrowse.equals("collectionType")) {
            queryObj.setDistinct(false);
        } else if (typeOfBrowse.equals("fieldType")) {
            queryObj.setDistinct(true);
        }
        session.setAttribute("activePresentationQueryNo", (Object)new Integer(shelper.getActiveQueryGroupNo()));
        try {
            if (queryObj.browse(session) == null) {
                logger.debug((Object)"Browse the collection returned null!!!!! Throw an alert to the user!");
                ret = false;
                return ret;
            }
        }
        catch (Exception e) {
            this.handleSearchExceptions(e);
        }
        long endTimeOfSubmission = System.currentTimeMillis();
        logger.debug((Object)("Browse query submission ended. Current time in seconds is: <<" + endTimeOfSubmission / 1000L + ">>"));
        logger.debug((Object)("Total time needed for the submission of the browse query is: <<" + (endTimeOfSubmission - startTimeofSubmission) / 1000L + ">> seconds"));
        int id = shelper.createQuery(shelper.getActiveQueryGroupNo(), new boolean[]{false});
        shelper.setActiveQueryGroup(id);
        return ret;
    }

    public void submitBrowseQueryOnPreviousResult(int index) throws SearchSubmissionException {
        ASLSession session = this.getASLsession();
        session.setAttribute("activePresentationQueryNo", (Object)new Integer(index));
        session.removeAttribute("RESULTS_NUMBER_PER_PAGE");
        logger.info((Object)("Browse a previous query... The index of the query to render is: " + index));
        logger.info((Object)("Active presentation query is: " + (Integer)session.getAttribute("activePresentationQueryNo")));
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getQuery(index);
        Query queryObj = queryGroup.getQuery(0);
        logger.debug((Object)("The query description to show results is --> " + queryObj.getQueryDescription()));
        try {
            if (queryObj.getSearchType().equals("simpleSearch")) {
                logger.debug((Object)"simple search query passing true");
                queryObj.search(session, true);
            } else {
                queryObj.search(session, false);
            }
        }
        catch (Exception e) {
            this.handleSearchExceptions(e);
        }
    }

    public void submitGenericQuery(String query, String type) throws SearchSubmissionException {
        long startTimeofSubmission = System.currentTimeMillis();
        logger.debug((Object)("Current time in seconds is: <<" + startTimeofSubmission / 1000L + ">>"));
        logger.debug((Object)"Generic Query will be submitted now.........");
        ASLSession session = this.getASLsession();
        String searchType = "advancedSearch";
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        logger.debug((Object)("The ID of the query group is: " + shelper.getActiveQueryGroupNo()));
        logger.debug((Object)"Submitting a generic search...");
        logger.debug((Object)("The query that will be submitted is: << " + query + " >>"));
        session.setAttribute("Term", (Object)query);
        session.setAttribute("activePresentationQueryNo", (Object)new Integer(shelper.getActiveQueryGroupNo()));
        session.removeAttribute("RESULTS_NUMBER_PER_PAGE");
        if (type.equals("Simple Search")) {
            searchType = "simpleSearch";
        } else if (type.equals("Geospatial Search")) {
            searchType = "geoSearch";
        } else if (type.equals("Google Search")) {
            searchType = "googleSearch";
        } else if (type.equals("Quick Search")) {
            searchType = "quickSearch";
        }
        logger.debug((Object)("The search type of the generic query is: << " + searchType + " >>"));
        queryObj.setGenericSearchType(searchType);
        try {
            queryObj.genericSearch(session, query);
        }
        catch (Exception e) {
            this.handleSearchExceptions(e);
        }
        long endTimeOfSubmission = System.currentTimeMillis();
        logger.debug((Object)(searchType + "Query submission ended. Current time in seconds is: <<" + endTimeOfSubmission / 1000L + ">>"));
        logger.debug((Object)("Total time needed for the submission of the query is: <<" + (endTimeOfSubmission - startTimeofSubmission) / 1000L + ">> seconds"));
        int id = shelper.createQuery(shelper.getActiveQueryGroupNo(), new boolean[0]);
        shelper.setActiveQueryGroup(id);
    }

    public void submitQueryOnPreviousResult(ArrayList<SearchableFieldBean> criteria, String sortby, String sortOrder, String showRank) throws SearchSubmissionException {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        Query queryObj = queryGroup.getQuery(0);
        logger.info((Object)"IN SUBMIT SEARCH FOR PREVIOUS QUERY");
        logger.info((Object)("The index of the previous query is: " + (Integer)session.getAttribute("previousQueryIndex")));
        logger.debug((Object)"PRINTING INFORMATION FOR THE CURRENT PREVIOUS SEARCH......");
        logger.debug((Object)("Search type is: " + queryObj.getSearchType()));
        logger.debug((Object)"Criteria and values...");
        List tmp = queryObj.getCriteria();
        if (tmp != null) {
            for (int t = 0; t < tmp.size(); ++t) {
                logger.debug((Object)(t + 1 + ") CRITERION: " + ((Criterion)tmp.get(t)).getSearchFieldName() + " VALUE: " + ((Criterion)tmp.get(t)).getSearchFieldValue()));
            }
        }
        logger.debug((Object)("The operator is: " + queryObj.getOperator()));
        if (sortby != null) {
            queryObj.setSortBy(sortby);
        }
        if (sortOrder != null) {
            queryObj.setOrder(sortOrder.toLowerCase().equals("asc") ? Order.ASC : Order.DESC);
        }
        int numOfActiveCriteriaAtTheQuery = queryObj.getCriteria().size();
        if (criteria != null) {
            for (int i = 0; i < criteria.size(); ++i) {
                if (criteria.size() == numOfActiveCriteriaAtTheQuery) {
                    queryObj.updateCriterionValue(i, criteria.get(i).getValue());
                    continue;
                }
                if (criteria.size() <= numOfActiveCriteriaAtTheQuery) continue;
                for (int j = numOfActiveCriteriaAtTheQuery; j < criteria.size(); ++j) {
                    queryObj.addCriterion(new Criterion(criteria.get(j).getId(), criteria.get(j).getName(), criteria.get(j).getValue()));
                }
            }
        }
        session.setAttribute("activePresentationQueryNo", (Object)((Integer)session.getAttribute("previousQueryIndex")));
        session.removeAttribute("RESULTS_NUMBER_PER_PAGE");
        try {
            queryObj.search(session, false);
        }
        catch (Exception e) {
            this.handleSearchExceptions(e);
        }
        logger.info((Object)("Active presentation query is: " + (Integer)session.getAttribute("activePresentationQueryNo")));
    }

    public void submitSimpleQuery(String fts, boolean setRanking, boolean isSemanticSearch) throws SearchSubmissionException {
        long startTimeofSubmission = System.currentTimeMillis();
        logger.debug((Object)("Current time in seconds is: <<" + startTimeofSubmission / 1000L + ">>"));
        logger.debug((Object)"Simple Query will be submitted now.........");
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.setSearchTerm(fts);
        queryObj.setRanking(setRanking);
        queryObj.setSemanticEnrichment(isSemanticSearch);
        session.setAttribute(SearchConstantsStrings.SESSION_SIMPLE_TERM, (Object)fts);
        session.setAttribute("activePresentationQueryNo", (Object)new Integer(shelper.getActiveQueryGroupNo()));
        logger.info((Object)("Active presentation query is: " + (Integer)session.getAttribute("activePresentationQueryNo")));
        session.removeAttribute("RESULTS_NUMBER_PER_PAGE");
        try {
            queryObj.search(session, true);
        }
        catch (Exception e) {
            this.handleSearchExceptions(e);
        }
        long endTimeOfSubmission = System.currentTimeMillis();
        logger.debug((Object)("QUERY description is: <<<<<<<<<" + queryObj.getQueryString() + ">>>>>>>>"));
        logger.debug((Object)("Simple Query submission ended. Current time in seconds is: <<" + endTimeOfSubmission / 1000L + ">>"));
        logger.debug((Object)("Total time needed for the submission of the simple query is: <<" + (endTimeOfSubmission - startTimeofSubmission) / 1000L + ">> seconds"));
        int id = shelper.createQuery(shelper.getActiveQueryGroupNo(), new boolean[0]);
        shelper.setActiveQueryGroup(id);
    }

    public void updateCriterionName(int internalNo, String newID, String newName) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.updateCriterionId(internalNo, newID);
        queryObj.updateCriterionName(internalNo, newName);
        logger.debug((Object)("Criterion with index: " + internalNo + "is updated with new name: " + newName + " and new ID: " + newID + " in advanced search."));
    }

    public void updateCriterionNameOnPreviousQuery(int internalNo, String newID, String newName) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        Query queryObj = queryGroup.getQuery(0);
        queryObj.updateCriterionId(internalNo, newID);
        queryObj.updateCriterionName(internalNo, newName);
        logger.debug((Object)("Criterion with index: " + internalNo + "is updated with  new name: " + newName + " in previous search."));
    }

    public void updateCriterionValue(int internalNo, String newValue) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.updateCriterionValue(internalNo, newValue);
        logger.debug((Object)("Criterion with index: " + internalNo + "is updated with new value: " + newValue + " in advanced search."));
    }

    public void updateCriterionValueOnPreviousQuery(int internalNo, String newValue) {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        logger.debug((Object)("The index of the previous query is: " + (Integer)session.getAttribute("previousQueryIndex")));
        logger.debug((Object)("The internal No of the criterion that will be updated is: " + internalNo));
        QueryGroup queryGroup = shelper.getQuery(((Integer)session.getAttribute("previousQueryIndex")).intValue());
        Query queryObj = queryGroup.getQuery(0);
        queryObj.updateCriterionValue(internalNo, newValue);
    }

    public Boolean isSemanticAvailableForCurrentScope() {
        String fpath = this.getServletContext().getRealPath("/") + "config/config.properties";
        String value = FileUtils.getPropertyValue((String)fpath, (String)this.getASLsession().getScopeName());
        logger.debug((Object)("Value of property " + this.getASLsession().getScopeName() + " is -> " + value));
        if (value != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    public String readPropertyFromFile(String propertyName) {
        String fpath = this.getServletContext().getRealPath("/") + "config/config.properties";
        logger.debug((Object)("PATTHH --> " + fpath));
        String value = FileUtils.getPropertyValue((String)fpath, (String)propertyName);
        logger.debug((Object)("Value of property " + propertyName + " is -> " + value));
        return value;
    }
}

