/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.searchportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Organization;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.QueryGroup;
import org.gcube.portlets.user.searchportlet.client.exceptions.CollectionRetrievalException;
import org.gcube.portlets.user.searchportlet.client.exceptions.SearchSubmissionException;
import org.gcube.portlets.user.searchportlet.client.interfaces.SearchService;
import org.gcube.portlets.user.searchportlet.server.EmailNotification;
import org.gcube.portlets.user.searchportlet.server.ErrorNotificationEmailMessageTemplate;
import org.gcube.portlets.user.searchportlet.shared.CollectionBean;
import org.gcube.portlets.user.searchportlet.shared.SearchAvailabilityType;
import org.gcube.portlets.user.searchportlet.shared.SearchTypeBean;

public class SearchServlet
extends RemoteServiceServlet
implements SearchService {
    private static Logger logger = Logger.getLogger(SearchServlet.class);
    private static final int DefaultQuery = 0;
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
    }

    public String getLogoURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        Organization currOrg = (Organization)this.getThreadLocalRequest().getSession().getAttribute("CURR_RE_NAME");
        if (currOrg != null) {
            long logoId = currOrg.getLogoId();
            String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
            return logoURL;
        }
        return null;
    }

    public HashMap<CollectionBean, ArrayList<CollectionBean>> getAvailableCollections() throws CollectionRetrievalException {
        logger.debug((Object)"Retrieving available collections tree..");
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        HashMap<CollectionBean, ArrayList<CollectionBean>> collectionHierarchyBean = new HashMap<CollectionBean, ArrayList<CollectionBean>>();
        HashMap colInfo = null;
        try {
            colInfo = shelper.getAvailableFTSCollections();
        }
        catch (Exception e) {
            throw new CollectionRetrievalException();
        }
        if (colInfo != null) {
            for (Map.Entry group : colInfo.entrySet()) {
                CollectionInfo collectionGroup = (CollectionInfo)group.getKey();
                CollectionBean colGroup = new CollectionBean(collectionGroup.getId(), collectionGroup.getName(), collectionGroup.getDescription(), collectionGroup.getRecno(), collectionGroup.getCreationDate(), false, true, false);
                ArrayList collectionsList = (ArrayList)colInfo.get(collectionGroup);
                ArrayList<CollectionBean> collectionsBean = new ArrayList<CollectionBean>();
                for (CollectionInfo col : collectionsList) {
                    CollectionBean collection = new CollectionBean(col.getId(), col.getName(), col.getDescription(), col.getRecno(), col.getCreationDate(), false, true, true);
                    collectionsBean.add(collection);
                }
                collectionHierarchyBean.put(colGroup, collectionsBean);
            }
        } else {
            throw new CollectionRetrievalException();
        }
        return collectionHierarchyBean;
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    public Integer getNumberOfSelectedCollections() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        try {
            int numOfRealSelectedCollections = queryObj.getSelectedRealCollections(session).size();
            logger.debug((Object)("Number of real selected collections is: " + numOfRealSelectedCollections));
            return new Integer(numOfRealSelectedCollections);
        }
        catch (InitialBridgingNotCompleteException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getSimpleSearchTerm() {
        ASLSession session = this.getASLsession();
        return (String)session.getAttribute("SearchPortletSimpleTerm");
    }

    public void setSimpleSearchTerm(String term) {
        ASLSession session = this.getASLsession();
        session.setAttribute("SearchPortletSimpleTerm", (Object)term);
    }

    public void setSelectedCollectionsToSession(HashSet<String> selectedCollections) {
        ASLSession session = this.getASLsession();
        session.setAttribute("SearchPortletSelectedCollections", selectedCollections);
    }

    public HashSet<String> getSelectedCollectionsFromSession() {
        ASLSession session = this.getASLsession();
        return (HashSet)session.getAttribute("SearchPortletSelectedCollections");
    }

    private void handleSearchExceptions(Exception e) throws SearchSubmissionException {
        logger.error((Object)"An exception was thrown while submiting the query.", (Throwable)e);
        throw new SearchSubmissionException(e.getMessage());
    }

    public SearchTypeBean getSelectedSearchType() {
        return (SearchTypeBean)this.getASLsession().getAttribute("SearchPortletSearchType");
    }

    public SearchAvailabilityType getSearchStatus() {
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        try {
            int numOfSelCols = queryObj.getSelectedRealCollections(session).size();
            if (numOfSelCols <= 0) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.NO_COLLECTION_SELECTED.toString()));
                return SearchAvailabilityType.NO_COLLECTION_SELECTED;
            }
            boolean hasFTS = queryObj.isFtsAvailable();
            boolean hasGeo = queryObj.isGeoAvailable();
            logger.debug((Object)("SEARCH STATUS: server response for FTS & GEO --> " + hasFTS + " & " + hasGeo));
            if (hasFTS && hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.FTS_GEO_AVAILABLE.toString()));
                return SearchAvailabilityType.FTS_GEO_AVAILABLE;
            }
            if (hasFTS && !hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.FTS_NOGEO_AVAILABLE.toString()));
                return SearchAvailabilityType.FTS_NOGEO_AVAILABLE;
            }
            if (!hasFTS && hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.GEO_NOFTS_AVAILABLE.toString()));
                return SearchAvailabilityType.GEO_NOFTS_AVAILABLE;
            }
            if (!hasFTS && !hasGeo) {
                logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.NOFTS_NOGEO_AVAILABLE.toString()));
                return SearchAvailabilityType.NOFTS_NOGEO_AVAILABLE;
            }
            logger.debug((Object)("SEARCH STATUS --> " + SearchAvailabilityType.SEARCH_UNAVAILABLE.toString()));
            return SearchAvailabilityType.SEARCH_UNAVAILABLE;
        }
        catch (InitialBridgingNotCompleteException e) {
        }
        catch (InternalErrorException e) {
            // empty catch block
        }
        return SearchAvailabilityType.SEARCH_UNAVAILABLE;
    }

    public void sendEmailWithErrorToSupport(Throwable caught) {
        String subject = "Search Portlet - Error Notification";
        String[] rec = new String[]{"support_team@d4science.org"};
        try {
            String senderEmail = "no-reply@imarine.research-infrastructures.eu";
            ErrorNotificationEmailMessageTemplate msgTemp = new ErrorNotificationEmailMessageTemplate(caught, this.getASLsession().getUsername(), this.getASLsession().getGroupName());
            EmailNotification emailNot = new EmailNotification(senderEmail, rec, subject, msgTemp.createBodyMessage(), "to", false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send the email to the support team.", (Throwable)e);
        }
    }

    public String stackTraceAsString(Throwable caught) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        caught.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public void submitGenericQuery(String term, SearchTypeBean type, HashSet<String> selectedCollections) throws SearchSubmissionException {
        long startTimeofSubmission = System.currentTimeMillis();
        logger.debug((Object)("Current time in seconds is: <<" + startTimeofSubmission / 1000L + ">>"));
        logger.debug((Object)"Query will be submitted now.........");
        ASLSession session = this.getASLsession();
        SearchHelper shelper = new SearchHelper(session);
        QueryGroup queryGroup = shelper.getActiveQueryGroup();
        Query queryObj = queryGroup.getQuery(0);
        queryObj.setSearchTerm(term);
        session.setAttribute("SearchPortletSearchType", (Object)type);
        session.setAttribute("SearchPortletSimpleTerm", (Object)term);
        session.setAttribute("activePresentationQueryNo", (Object)new Integer(shelper.getActiveQueryGroupNo()));
        logger.debug((Object)("Active presentation query is: " + (Integer)session.getAttribute("activePresentationQueryNo")));
        if (type == SearchTypeBean.NATIVE) {
            logger.debug((Object)"Going to search native collections only...");
        } else if (type == SearchTypeBean.EXTERNAL) {
            logger.debug((Object)"Going to search external collections only...");
        } else if (type == SearchTypeBean.GCUBESIMPLE) {
            logger.debug((Object)"Going to perform a simple search based on user's selected collections...");
            logger.debug((Object)"Going to change the selected selections. Replacing all existing ones...");
            for (String id : selectedCollections) {
                logger.debug((Object)("Adding to selected -> " + id));
            }
            queryObj.selectCollections(new ArrayList<String>(selectedCollections), true, session, true);
            try {
                queryObj.search(session, true);
            }
            catch (Exception e) {
                this.handleSearchExceptions(e);
            }
        } else {
            logger.debug((Object)"Going to perform a generic search on all the available collections...");
            try {
                ArrayList<String> terms = new ArrayList<String>();
                terms.add(term);
                queryObj.genericSearch(session, terms, true);
            }
            catch (Exception e) {
                this.handleSearchExceptions(e);
            }
        }
        long endTimeOfSubmission = System.currentTimeMillis();
        logger.debug((Object)("Query submission ended. Current time in seconds is: <<" + endTimeOfSubmission / 1000L + ">>"));
        logger.debug((Object)("Total time needed for the submission of the simple query is: <<" + (endTimeOfSubmission - startTimeofSubmission) / 1000L + ">> seconds"));
        int id = shelper.createQuery(shelper.getActiveQueryGroupNo(), new boolean[0]);
        shelper.setActiveQueryGroup(id);
    }
}

