/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.searchmanagerportlet.gwt.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.config.StaticConfiguration;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FTIndex;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.exceptions.CommunicationFailureException;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.exceptions.DeleteFieldFailureException;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.exceptions.FieldsRetrievalFailureException;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.exceptions.SearchableFieldInfoMissingException;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.exceptions.StoreFieldFailureException;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.interfaces.SearchManagerService;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.server.EmailNotification;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.server.ErrorNotificationEmailMessageTemplate;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.CollectionFieldsBean;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.CollectionInfoBean;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.FieldInfoBean;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.PresentableFieldInfoBean;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.SearchableFieldInfoBean;

public class SearchManagerServlet
extends RemoteServiceServlet
implements SearchManagerService {
    private static final long serialVersionUID = -5809760334596481925L;
    private static Logger logger = Logger.getLogger(SearchManagerServlet.class);

    public SearchManagerServlet() {
        try {
            logger.debug((Object)"initializing servlet and starting RR bridging");
            ResourceRegistry.startBridging();
        }
        catch (Exception e) {
            logger.error((Object)"Servlet failed to initialize", (Throwable)e);
        }
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    public List<FieldInfoBean> getFieldsInfo(boolean loadDetails) throws FieldsRetrievalFailureException {
        ArrayList<FieldInfoBean> fieldsBean = new ArrayList<FieldInfoBean>();
        try {
            logger.debug((Object)"Trying to retrieve the available fields info..");
            List dbFields = Field.getAll((boolean)loadDetails, (String)this.getASLsession().getScopeName());
            if (dbFields != null && dbFields.size() > 0) {
                logger.debug((Object)"Fields are available");
                for (Field dbf : dbFields) {
                    FieldInfoBean fBean;
                    if (loadDetails) {
                        ArrayList<SearchableFieldInfoBean> searchableFieldsBean = new ArrayList<SearchableFieldInfoBean>();
                        Set dbSearchable = dbf.getSearchables();
                        if (dbSearchable != null && dbSearchable.size() > 0) {
                            for (Searchable dbs : dbSearchable) {
                                Set dbCabs = dbs.getCapabilities();
                                ArrayList<String> capabilitiesBean = new ArrayList<String>();
                                if (dbCabs != null && dbCabs.size() > 0) {
                                    for (String dbc : dbCabs) {
                                        logger.debug((Object)("Cap --> " + dbc));
                                        capabilitiesBean.add(dbc);
                                    }
                                }
                                SearchableFieldInfoBean sBean = new SearchableFieldInfoBean(dbs.getID(), dbs.getCollection(), this.getCollectionNameByID(dbs.getCollection()), dbs.getLocator(), capabilitiesBean, dbs.getExpression(), dbs.isOrder());
                                searchableFieldsBean.add(sBean);
                            }
                        }
                        ArrayList<PresentableFieldInfoBean> presentableFieldsBean = new ArrayList<PresentableFieldInfoBean>();
                        Set dbPresentable = dbf.getPresentables();
                        if (dbPresentable != null && dbPresentable.size() > 0) {
                            for (Presentable dbp : dbPresentable) {
                                PresentableFieldInfoBean pBean = new PresentableFieldInfoBean(dbp.getID(), dbp.getCollection(), this.getCollectionNameByID(dbp.getCollection()), dbp.getLocator(), dbp.isOrder().booleanValue(), dbp.getExpression(), dbp.getPresentationInfo());
                                presentableFieldsBean.add(pBean);
                            }
                        }
                        fBean = new FieldInfoBean(dbf.getID(), dbf.getName(), dbf.getDescription(), searchableFieldsBean, presentableFieldsBean);
                    } else {
                        fBean = new FieldInfoBean(dbf.getID(), dbf.getName(), dbf.getDescription(), null, null);
                    }
                    if (loadDetails) {
                        List searchableContainer = FieldIndexContainer.queryByFieldIDAndTypeAndScope((String)dbf.getID(), (FieldIndexContainer.FieldType)FieldIndexContainer.FieldType.Searchable, (String)this.getASLsession().getScopeName());
                        logger.debug((Object)("Quering for searchables  for the field ID -> " + dbf.getID()));
                        HashSet<CollectionInfoBean> searchableColIDs = new HashSet<CollectionInfoBean>();
                        if (searchableContainer != null) {
                            for (FieldIndexContainer f : searchableContainer) {
                                logger.debug((Object)("Adding Searchable Collection ID --> " + f.getCollection()));
                                String colID = f.getCollection();
                                String colName = this.getCollectionNameByID(colID);
                                logger.debug((Object)("Collection name --> " + colName));
                                CollectionInfoBean colBean = new CollectionInfoBean(colID, colName);
                                searchableColIDs.add(colBean);
                            }
                        }
                        fBean.setAvailableSearchableCollectionsIDs(searchableColIDs);
                        List presentableContainer = FieldIndexContainer.queryByFieldIDAndTypeAndScope((String)dbf.getID(), (FieldIndexContainer.FieldType)FieldIndexContainer.FieldType.Presentable, (String)this.getASLsession().getScopeName());
                        HashSet<CollectionInfoBean> presentableColIDs = new HashSet<CollectionInfoBean>();
                        if (presentableContainer != null) {
                            for (FieldIndexContainer f : presentableContainer) {
                                logger.debug((Object)("Adding -> " + f.getCollection()));
                                String colID = f.getCollection();
                                DataCollection colData = new DataCollection();
                                colData.setID(colID);
                                colData.load(true);
                                String colName = colData.getName();
                                CollectionInfoBean colBean = new CollectionInfoBean(colID, colName);
                                presentableColIDs.add(colBean);
                            }
                        }
                        fBean.setAvailablePresentableCollectionsIDs(presentableColIDs);
                    }
                    logger.debug((Object)("Adding a new field bean with name : " + fBean.getLabel()));
                    fieldsBean.add(fBean);
                }
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"An exception was thrown while trying to retrieve the available fiels", (Throwable)e);
            throw new FieldsRetrievalFailureException(e.getMessage(), e.getCause());
        }
        try {
            boolean bridgingStatus = ResourceRegistry.isInitialBridgingComplete();
            logger.debug((Object)("Current Bridging Status......... " + bridgingStatus));
            this.getASLsession().setAttribute("SMP_isBridgingComplete", (Object)new Boolean(bridgingStatus));
        }
        catch (ResourceRegistryException e) {
            logger.warn((Object)"Could not get the status of the registry's bridging");
        }
        Collections.sort(fieldsBean);
        return fieldsBean;
    }

    public void saveAnnotations(String fieldID, ArrayList<String> annotationsToBeAdded, ArrayList<String> annotationsToBeRemoved) {
        try {
            Field f = Field.getById((boolean)true, (String)fieldID);
            Set presentables = f.getPresentables();
            for (Presentable p : presentables) {
                for (String annToAdd : annotationsToBeAdded) {
                    logger.debug((Object)("Adding -> " + annToAdd));
                    p.getPresentationInfo().add(annToAdd);
                }
                for (String annToRemove : annotationsToBeRemoved) {
                    logger.debug((Object)("Removing -> " + annToRemove));
                    p.getPresentationInfo().remove(annToRemove);
                }
            }
            f.store(true);
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to get the Field Info. Could not save the annotations to the Presentables of this field");
        }
    }

    public ArrayList<String> getFieldAnnotations(String fieldID) {
        ArrayList<String> annotations = new ArrayList<String>();
        try {
            Field f = Field.getById((boolean)true, (String)fieldID);
            Set keywords = QueryHelper.getPresentationInfoOfField((Field)f);
            ArrayList semanticAnnotations = this.getSemanticAnnotations();
            for (String keyword : keywords) {
                if (!semanticAnnotations.contains(keyword)) continue;
                annotations.add(keyword);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to get field's semantic annnotations", (Throwable)e);
        }
        return annotations;
    }

    public ArrayList<String> getSemanticAnnotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        try {
            Set semanticKeywords = StaticConfiguration.getInstance().getPresentationInfoKeywords("semantic");
            annotations.addAll(semanticKeywords);
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to retrieve the available semantic annotations", (Throwable)e);
        }
        return annotations;
    }

    public HashMap<String, ArrayList<String>> getGroupsAndKeywords() {
        HashMap<String, ArrayList<String>> groupsAndKeywords = new HashMap<String, ArrayList<String>>();
        try {
            StaticConfiguration sc = StaticConfiguration.getInstance();
            Set groups = sc.getPresentationInfoGroups();
            for (String group : groups) {
                Set keywords = StaticConfiguration.getInstance().getPresentationInfoKeywords(group);
                ArrayList anns = new ArrayList();
                anns.addAll(keywords);
                groupsAndKeywords.put(group, anns);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to retrieve the available presentation groups");
        }
        return groupsAndKeywords;
    }

    public ArrayList<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            StaticConfiguration sc = StaticConfiguration.getInstance();
            Set g = sc.getPresentationInfoGroups();
            groups.addAll(g);
            logger.debug((Object)"groups:");
            logger.debug((Object)g.toString());
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to retrieve the available presentation groups");
        }
        return groups;
    }

    public void addKeywordToPresentationGroup(String group, String keyword) {
        try {
            StaticConfiguration sc = StaticConfiguration.getInstance();
            sc.addPresentationInfoKeyword(group, keyword);
            sc.store(false);
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)("Failed to add a new keyword to the --> " + group + " presentation group"));
        }
    }

    public void removeKeywordsFromPresentationGroup(String group, ArrayList<String> keywords) {
        try {
            StaticConfiguration sc = StaticConfiguration.getInstance();
            logger.debug((Object)("Removing keywords from the --> " + group + " group"));
            for (String keyword : keywords) {
                sc.deletePresentationInfoKeyword(group, keyword);
                logger.debug((Object)("Deleted keyword --> " + keyword));
            }
            sc.store(false);
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to remove the keyword", (Throwable)e);
        }
    }

    public Boolean getBridgingStatusFromSession() {
        return (Boolean)this.getASLsession().getAttribute("SMP_isBridgingComplete");
    }

    public ArrayList<String> getIndexLocatorList(String fieldID, String collectionID, String type) throws CommunicationFailureException {
        ArrayList<String> locators = new ArrayList<String>();
        FieldIndexContainer.FieldType fType = FieldIndexContainer.FieldType.Presentable;
        if (type.equals("Searchable")) {
            fType = FieldIndexContainer.FieldType.Searchable;
        }
        try {
            logger.debug((Object)("Quering for field ID -> " + fieldID + " and collection ID -> " + collectionID));
            List fc = FTIndex.queryByFieldIDAndTypeAndCollectionAndScope((boolean)true, (String)fieldID, (String)collectionID, (FieldIndexContainer.FieldType)fType, (String)this.getASLsession().getScopeName());
            if (fc != null) {
                for (DataSource f : fc) {
                    logger.debug((Object)("Adding source locator ->" + f.getID()));
                    locators.add(f.getID());
                }
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)("Error while trying to get the available index locators for the collection with ID: " + collectionID));
            throw new CommunicationFailureException(e.getMessage(), e.getCause());
        }
        return locators;
    }

    public Set<String> getIndexCapabilities(String indexLocator) throws CommunicationFailureException {
        Set caps = null;
        try {
            DataSource ds = DataSource.getById((boolean)true, (String)indexLocator);
            if (ds != null) {
                caps = ds.getCapabilities();
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)("Failed to get The index capabilities (Index ID: " + indexLocator + ")"));
            throw new CommunicationFailureException(e.getMessage(), e.getCause());
        }
        return caps;
    }

    public FieldInfoBean createField(FieldInfoBean field, boolean isUpdated) throws SearchableFieldInfoMissingException, StoreFieldFailureException, CommunicationFailureException {
        try {
            ArrayList presentableInfoBean;
            Field dbField = new Field();
            if (field.getDescription() != null) {
                dbField.setDescription(field.getDescription());
            }
            if (field.getLabel() != null) {
                dbField.setName(field.getLabel());
            }
            if (isUpdated && field.getID().length() > 0) {
                dbField.setID(field.getID());
            }
            field.setID(dbField.getID());
            ArrayList searchableInfoBean = field.getSearchableFields();
            if (searchableInfoBean != null && searchableInfoBean.size() > 0) {
                for (SearchableFieldInfoBean sBean : searchableInfoBean) {
                    if (sBean.getCollectionID() == null) continue;
                    logger.debug((Object)("Searchable --> " + sBean.getCollectionName()));
                    Searchable dbs = new Searchable();
                    ArrayList capabilitiesBean = sBean.getIndexCapabilities();
                    if (capabilitiesBean != null && capabilitiesBean.size() > 0) {
                        for (String cap : capabilitiesBean) {
                            logger.debug((Object)("Adding capability --> " + cap));
                            dbs.getCapabilities().add(cap);
                        }
                    }
                    dbs.setCollection(sBean.getCollectionID());
                    dbs.setLocator(sBean.getSourceLocator());
                    if (isUpdated && sBean.getID() != null && sBean.getID().length() > 0) {
                        dbs.setID(sBean.getID());
                    }
                    dbs.setField(dbField.getID());
                    dbs.setOrder(sBean.isSortable());
                    dbs.setExpression(sBean.getIndexQueryLanguage());
                    dbField.getSearchables().add(dbs);
                    sBean.setID(dbs.getID());
                }
            }
            if ((presentableInfoBean = field.getPresentableFields()) != null && presentableInfoBean.size() > 0) {
                for (PresentableFieldInfoBean pBean : presentableInfoBean) {
                    if (pBean.getCollectionID() == null) continue;
                    Presentable dbp = new Presentable();
                    dbp.setCollection(pBean.getCollectionID());
                    dbp.setLocator(pBean.getSourceLocator());
                    dbp.setOrder(pBean.isSortable());
                    dbp.setExpression(pBean.getQueryExpression());
                    dbp.setPresentationInfo(pBean.getPresentationInfo());
                    if (isUpdated && pBean.getID() != null && pBean.getID().length() > 0) {
                        dbp.setID(pBean.getID());
                    }
                    dbp.setField(dbField.getID());
                    dbField.getPresentables().add(dbp);
                    pBean.setID(dbp.getID());
                }
            }
            dbField.store(true, this.getASLsession().getScopeName());
            if (!isUpdated) {
                ResourceRegistry.setDirty();
            }
            return field;
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to create a new FieldInfo. An exception was thrown", (Throwable)e);
            throw new CommunicationFailureException(e.getMessage(), e.getCause());
        }
    }

    public void deleteFieldInfo(String fieldID) throws DeleteFieldFailureException {
        try {
            logger.debug((Object)("Going to delete field with ID --> " + fieldID));
            Field field = new Field();
            field.setID(fieldID);
            field.delete(true, this.getASLsession().getScopeName());
        }
        catch (ResourceRegistryException e) {
            logger.debug((Object)"An exception is thrown while trying to delete the field", (Throwable)e);
            throw new DeleteFieldFailureException(e.getMessage(), e.getCause());
        }
    }

    public void sendEmailWithErrorToSupport(Throwable caught) {
        String subject = "[PORTAL-iMarine] Fields Management Portlet - Error Notification";
        String[] rec = new String[]{"support_team@d4science.org"};
        try {
            String senderEmail = "no-reply@imarine.research-infrastructures.eu";
            ErrorNotificationEmailMessageTemplate msgTemp = new ErrorNotificationEmailMessageTemplate(caught, this.getASLsession().getUsername());
            EmailNotification emailNot = new EmailNotification(senderEmail, rec, subject, msgTemp.createBodyMessage(), "to", false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send the email to the support team.", (Throwable)e);
        }
    }

    public ArrayList<CollectionFieldsBean> getCollectionAndFieldsInfo() {
        ArrayList<CollectionFieldsBean> collectionsAndFieldsBean = new ArrayList<CollectionFieldsBean>();
        try {
            List collections = DataCollection.getCollectionsOfScope((boolean)true, (String)this.getASLsession().getScopeName());
            if (collections != null) {
                for (DataCollection col : collections) {
                    List searchableFields = Field.getSearchableFieldsOfCollection((boolean)true, (String)col.getID());
                    List presentableFields = Field.getPresentableFieldsOfCollection((boolean)true, (String)col.getID());
                    CollectionFieldsBean colFieldBean = new CollectionFieldsBean(col.getID(), col.getName());
                    ArrayList<String> searchableFieldBean = new ArrayList<String>();
                    for (Field f : searchableFields) {
                        String fieldDesc = f.getName() + " (" + f.getID() + ")";
                        searchableFieldBean.add(fieldDesc);
                    }
                    colFieldBean.setSearchableFields(searchableFieldBean);
                    ArrayList<String> presentableFieldBean = new ArrayList<String>();
                    for (Field f : presentableFields) {
                        String fieldDesc = f.getName() + " (" + f.getID() + ")";
                        presentableFieldBean.add(fieldDesc);
                    }
                    colFieldBean.setPresentableFields(presentableFieldBean);
                    collectionsAndFieldsBean.add(colFieldBean);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"An exception was thrown. Failed to get the available colllections and their fields");
        }
        return collectionsAndFieldsBean;
    }

    private String getCollectionNameByID(String id) throws ResourceRegistryException {
        DataCollection colData = new DataCollection();
        colData.setID(id);
        colData.load(true);
        String colName = colData.getName();
        return colName;
    }
}

