/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.searchmanagerportlet.gwt.client.widgets;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.FieldsListPanel;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.widgets.PresentableInfoPanel;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.client.widgets.SearchableInfoPanel;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.FieldInfoBean;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.PresentableFieldInfoBean;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.SearchableFieldInfoBean;

public class FieldFormPanel
extends Composite {
    protected VerticalPanel mainPanel = new VerticalPanel();
    private CaptionPanel captionPanel = new CaptionPanel();
    private HorizontalPanel hostSPPanel = new HorizontalPanel();
    private HorizontalPanel fPanel = new HorizontalPanel();
    private TextBox fieldLabel = new TextBox();
    private TextArea fieldDesc = new TextArea();
    protected ListBox searchableFields = new ListBox();
    protected ListBox presentableFields = new ListBox();
    private HorizontalPanel labelP = new HorizontalPanel();
    private HorizontalPanel descP = new HorizontalPanel();
    private DockPanel searchableIP = new DockPanel();
    private DockPanel presentableIP = new DockPanel();
    private Button addSearchableBtn = new Button();
    private Button addPresentableBtn = new Button();
    private VerticalPanel sPropertiesP = new VerticalPanel();
    private VerticalPanel pPropertiesP = new VerticalPanel();
    private Button saveBtn = new Button("Save");
    protected static HTML warningMsg = new HTML("<span style=\"color: darkred\">WARNING: Your changes are temporary saved. Please click on the <b>Save</b> button to save your changes</span>");
    protected static HTML noSearchableMsg = new HTML("<span style=\"color: darkblue\">No Searchable fields available", true);
    protected static HTML noPresentableMsg = new HTML("<span style=\"color: darkblue\">No presentable fields available.", true);
    protected static HTML requiredFieldsMsg = new HTML("<span  style=\"color: #bbbbbb;font-size: small;\">Fields with * are mandatory", true);

    public FieldFormPanel(FieldInfoBean fBean, FieldsListPanel fieldsPanel) {
        Log.trace((String)"Creating a new form panel");
        this.mainPanel.setWidth("100%");
        this.mainPanel.setSpacing(8);
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.fPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.fPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.captionPanel.setWidth("97%");
        this.sPropertiesP.setWidth("100%");
        this.pPropertiesP.setWidth("100%");
        this.searchableIP.setWidth("100%");
        this.presentableIP.setWidth("100%");
        this.addSearchableBtn.setStyleName("addSPButton");
        this.addSearchableBtn.setTitle("Create a new searchable field info");
        this.addPresentableBtn.setStyleName("addPPButton");
        this.addPresentableBtn.setTitle("Create a new presentable field info");
        this.hostSPPanel.setSpacing(12);
        this.labelP.setSpacing(8);
        this.labelP.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.descP.setSpacing(8);
        this.descP.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.searchableIP.setSpacing(8);
        this.searchableIP.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.presentableIP.setSpacing(8);
        this.presentableIP.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.labelP.add((Widget)new Label("* Name"));
        this.labelP.add((Widget)this.fieldLabel);
        this.descP.add((Widget)new Label("Description"));
        this.descP.add((Widget)this.fieldDesc);
        this.searchableFields.setVisible(false);
        this.presentableFields.setVisible(false);
        this.searchableIP.add((Widget)this.addSearchableBtn, DockPanel.EAST);
        this.searchableIP.add((Widget)this.searchableFields, DockPanel.NORTH);
        this.searchableIP.add((Widget)this.sPropertiesP, DockPanel.CENTER);
        this.presentableIP.add((Widget)this.addPresentableBtn, DockPanel.EAST);
        this.presentableIP.add((Widget)this.presentableFields, DockPanel.NORTH);
        this.presentableIP.add((Widget)this.pPropertiesP, DockPanel.CENTER);
        this.hostSPPanel.add((Widget)this.searchableIP);
        this.hostSPPanel.add((Widget)this.presentableIP);
        if (fBean != null && fBean.getID() != null) {
            this.captionPanel.setCaptionHTML("<span style=\"color: darkblue\">FIELD: " + fBean.getLabel() + " (" + fBean.getID() + ")");
            this.fieldDesc.setText(fBean.getDescription() != null ? fBean.getDescription() : "");
            this.fieldLabel.setText(fBean.getLabel());
            if (fBean.getSearchableFields() != null && fBean.getSearchableFields().size() > 0) {
                Log.trace((String)"searchables exist...");
                for (SearchableFieldInfoBean sBean : fBean.getSearchableFields()) {
                    if (sBean.getID() == null) continue;
                    this.searchableFields.addItem(sBean.getCollectionName(), sBean.getID());
                    Log.trace((String)"searchable added to the list");
                }
                if (this.searchableFields.getItemCount() > 0) {
                    this.searchableFields.setVisible(true);
                    this.searchableFields.setSelectedIndex(0);
                    SearchableFieldInfoBean currentSBean = this.findSearchableBeanByID(this.searchableFields.getValue(0), fBean, true);
                    SearchableInfoPanel sp = new SearchableInfoPanel(currentSBean, fBean, this);
                    this.sPropertiesP.clear();
                    this.sPropertiesP.add((Widget)sp);
                    sp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                this.sPropertiesP.clear();
                this.sPropertiesP.add((Widget)noSearchableMsg);
            }
            if (fBean.getPresentableFields() != null && fBean.getPresentableFields().size() > 0) {
                Log.trace((String)"Presentables exist");
                for (PresentableFieldInfoBean pBean : fBean.getPresentableFields()) {
                    if (pBean.getID() == null) continue;
                    this.presentableFields.addItem(pBean.getCollectionName(), pBean.getID());
                    Log.trace((String)"presentable added to the list");
                }
                if (this.presentableFields.getItemCount() > 0) {
                    this.presentableFields.setVisible(true);
                    this.presentableFields.setSelectedIndex(0);
                    PresentableFieldInfoBean currentPBean = this.findPresentableBeanByID(this.presentableFields.getValue(0), fBean, true);
                    PresentableInfoPanel pp = new PresentableInfoPanel(currentPBean, fBean, this);
                    this.pPropertiesP.clear();
                    this.pPropertiesP.add((Widget)pp);
                    pp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                this.pPropertiesP.clear();
                this.pPropertiesP.add((Widget)noPresentableMsg);
            }
        } else {
            this.captionPanel.setCaptionHTML("<span style=\"color: darkblue\">New Field");
            this.sPropertiesP.clear();
            this.sPropertiesP.add((Widget)noSearchableMsg);
            this.pPropertiesP.clear();
            this.pPropertiesP.add((Widget)noPresentableMsg);
        }
        this.fPanel.add((Widget)this.labelP);
        this.fPanel.add((Widget)this.descP);
        this.mainPanel.add((Widget)this.fPanel);
        this.mainPanel.add((Widget)this.hostSPPanel);
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainPanel.add((Widget)this.saveBtn);
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        this.mainPanel.add((Widget)requiredFieldsMsg);
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.captionPanel.add((Widget)this.mainPanel);
        this.initWidget((Widget)this.captionPanel);
        this.saveBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.searchableFields.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.presentableFields.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addSearchableBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addPresentableBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addNewSearchable(FieldInfoBean fBean) {
        SearchableFieldInfoBean newSBean = new SearchableFieldInfoBean();
        SearchableInfoPanel sp = new SearchableInfoPanel(newSBean, fBean, this);
        this.sPropertiesP.clear();
        this.sPropertiesP.add((Widget)sp);
        sp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addNewPresentable(FieldInfoBean fBean) {
        PresentableFieldInfoBean newPBean = new PresentableFieldInfoBean();
        this.pPropertiesP.clear();
        PresentableInfoPanel pp = new PresentableInfoPanel(newPBean, fBean, this);
        this.pPropertiesP.add((Widget)pp);
        pp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void removePresentable(String id, int index, FieldInfoBean fBean) {
        this.presentableFields.removeItem(index);
        if (this.presentableFields.getItemCount() > 0) {
            this.presentableFields.setSelectedIndex(0);
            String selID = this.presentableFields.getValue(0);
            PresentableFieldInfoBean currentPBean = selID.startsWith("#SMP_") ? this.findPresentableBeanByID(selID, fBean, false) : this.findPresentableBeanByID(selID, fBean, true);
            this.addExistingPresentable(currentPBean, fBean);
        } else {
            this.presentableFields.setVisible(false);
            this.pPropertiesP.clear();
            this.pPropertiesP.add((Widget)noPresentableMsg);
        }
        ArrayList pFields = fBean.getPresentableFields();
        int i = 0;
        for (PresentableFieldInfoBean pb : pFields) {
            if (id.startsWith("#SMP_")) {
                if (pb.getTempID() != null && pb.getTempID().trim().equals(id.trim())) {
                    pFields.remove(i);
                    break;
                }
            } else if (pb.getID() != null && pb.getID().trim().equals(id.trim())) {
                pFields.remove(i);
                break;
            }
            ++i;
        }
        this.mainPanel.insert((Widget)warningMsg, 0);
    }

    private void removeSearchable(String id, int index, FieldInfoBean fBean) {
        this.searchableFields.removeItem(index);
        if (this.searchableFields.getItemCount() > 0) {
            this.searchableFields.setSelectedIndex(0);
            String selID = this.searchableFields.getValue(0);
            SearchableFieldInfoBean currentSBean = selID.startsWith("#SMP_") ? this.findSearchableBeanByID(selID, fBean, false) : this.findSearchableBeanByID(selID, fBean, true);
            this.addExistingSearchable(currentSBean, fBean);
        } else {
            this.searchableFields.setVisible(false);
            this.sPropertiesP.clear();
            this.sPropertiesP.add((Widget)noSearchableMsg);
        }
        ArrayList sFields = fBean.getSearchableFields();
        int i = 0;
        for (SearchableFieldInfoBean sb : sFields) {
            if (id.startsWith("#SMP_")) {
                if (sb.getTempID() != null && sb.getTempID().trim().equals(id.trim())) {
                    sFields.remove(i);
                    break;
                }
            } else if (sb.getID() != null && sb.getID().trim().equals(id.trim())) {
                sFields.remove(i);
                break;
            }
            ++i;
        }
        this.mainPanel.insert((Widget)warningMsg, 0);
    }

    private void addExistingSearchable(SearchableFieldInfoBean sBean, FieldInfoBean fBean) {
        SearchableInfoPanel sp = new SearchableInfoPanel(sBean, fBean, this);
        this.sPropertiesP.clear();
        this.sPropertiesP.add((Widget)sp);
        sp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addExistingPresentable(PresentableFieldInfoBean pBean, FieldInfoBean fBean) {
        PresentableInfoPanel pp = new PresentableInfoPanel(pBean, fBean, this);
        this.pPropertiesP.clear();
        this.pPropertiesP.add((Widget)pp);
        pp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setSearchablePanelDeleteHandler(SearchableInfoPanel sp, FieldInfoBean fBean) {
        sp.setDeleteBtnHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private SearchableFieldInfoBean findSearchableBeanByID(String ID, FieldInfoBean fBean, boolean useSID) {
        ArrayList tmp;
        if (fBean != null && (tmp = fBean.getSearchableFields()) != null && tmp.size() > 0) {
            for (SearchableFieldInfoBean s : tmp) {
                if (!(useSID ? s.getID() != null && s.getID().trim().equals(ID.trim()) : s.getTempID() != null && s.getTempID().trim().equals(ID.trim()))) continue;
                return s;
            }
        }
        return null;
    }

    private PresentableFieldInfoBean findPresentableBeanByID(String ID, FieldInfoBean fBean, boolean useSID) {
        ArrayList tmp;
        if (fBean != null && (tmp = fBean.getPresentableFields()) != null && tmp.size() > 0) {
            for (PresentableFieldInfoBean s : tmp) {
                if (!(useSID ? s.getID().trim().equals(ID.trim()) : s.getTempID() != null && s.getTempID().trim().equals(ID.trim()))) continue;
                return s;
            }
        }
        return null;
    }

    private boolean validateForm() {
        return !this.fieldLabel.getText().trim().isEmpty();
    }

    static /* synthetic */ void access$000(FieldFormPanel x0, String x1, int x2, FieldInfoBean x3) {
        x0.removeSearchable(x1, x2, x3);
    }

    static /* synthetic */ void access$100(FieldFormPanel x0, String x1, int x2, FieldInfoBean x3) {
        x0.removePresentable(x1, x2, x3);
    }

    static /* synthetic */ boolean access$200(FieldFormPanel x0) {
        return x0.validateForm();
    }

    static /* synthetic */ TextBox access$300(FieldFormPanel x0) {
        return x0.fieldLabel;
    }

    static /* synthetic */ TextArea access$400(FieldFormPanel x0) {
        return x0.fieldDesc;
    }

    static /* synthetic */ CaptionPanel access$500(FieldFormPanel x0) {
        return x0.captionPanel;
    }

    static /* synthetic */ SearchableFieldInfoBean access$600(FieldFormPanel x0, String x1, FieldInfoBean x2, boolean x3) {
        return x0.findSearchableBeanByID(x1, x2, x3);
    }

    static /* synthetic */ VerticalPanel access$700(FieldFormPanel x0) {
        return x0.sPropertiesP;
    }

    static /* synthetic */ PresentableFieldInfoBean access$800(FieldFormPanel x0, String x1, FieldInfoBean x2, boolean x3) {
        return x0.findPresentableBeanByID(x1, x2, x3);
    }

    static /* synthetic */ VerticalPanel access$900(FieldFormPanel x0) {
        return x0.pPropertiesP;
    }

    static /* synthetic */ void access$1000(FieldFormPanel x0, FieldInfoBean x1) {
        x0.addNewSearchable(x1);
    }

    static /* synthetic */ void access$1100(FieldFormPanel x0, FieldInfoBean x1) {
        x0.addNewPresentable(x1);
    }
}

