/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.searchmanagerportlet.gwt.client.widgets;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.admin.searchmanagerportlet.gwt.shared.FieldInfoBean;

public class FieldCell
extends Composite {
    private HorizontalPanel mainPanel = new HorizontalPanel();
    private Label fieldLabel = new Label();
    private Button deleteFieldBtn = new Button();
    private FieldInfoBean field;
    private HTML emptyField = new HTML("<span style=\"color: darkblue\">(empty)</span>", true);
    private HTML searchableOnly = new HTML("<span style=\"color: darkblue\">(s)</span>", true);
    private HTML presentableOnly = new HTML("<span style=\"color: darkblue\">(p)</span>", true);
    private HTML spField = new HTML("<span style=\"color: darkblue\">(s/p)</span>", true);

    public FieldCell(FieldInfoBean field, boolean isReadOnly) {
        this.field = field;
        this.mainPanel.setSpacing(5);
        this.deleteFieldBtn.setStyleName("deleteButton");
        this.deleteFieldBtn.setTitle("Deletes the corresponding field");
        this.fieldLabel.setText(field.getLabel());
        this.createFieldCellLabel(isReadOnly);
        this.initWidget((Widget)this.mainPanel);
    }

    public void setDeleteBtnClickHandler(ClickHandler handler) {
        this.deleteFieldBtn.addClickHandler(handler);
    }

    public FieldInfoBean getField() {
        return this.field;
    }

    public void updateField(FieldInfoBean updatedField, boolean isReadOnly) {
        this.field = updatedField;
        this.mainPanel.clear();
        this.createFieldCellLabel(isReadOnly);
    }

    private void createFieldCellLabel(boolean isReadOnly) {
        this.fieldLabel.setText(this.field.getLabel());
        this.mainPanel.add((Widget)this.fieldLabel);
        if (!isReadOnly) {
            if (this.field.getPresentableFields().isEmpty() && this.field.getSearchableFields().isEmpty()) {
                this.mainPanel.add((Widget)this.emptyField);
            } else if (!this.field.getPresentableFields().isEmpty() && !this.field.getSearchableFields().isEmpty()) {
                this.mainPanel.add((Widget)this.spField);
            } else if (!this.field.getSearchableFields().isEmpty()) {
                this.mainPanel.add((Widget)this.searchableOnly);
            } else {
                this.mainPanel.add((Widget)this.presentableOnly);
            }
            this.mainPanel.add((Widget)this.deleteFieldBtn);
        }
    }
}

