/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.client.control;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.user.results.client.ResultsDisplayer;
import org.gcube.portlets.user.results.client.components.BasketView;
import org.gcube.portlets.user.results.client.components.BasketViewItem;
import org.gcube.portlets.user.results.client.components.ResultItem;
import org.gcube.portlets.user.results.client.control.Controller;
import org.gcube.portlets.user.results.client.dialogBox.NoResultsPopup;
import org.gcube.portlets.user.results.client.draggables.DraggableRow;
import org.gcube.portlets.user.results.client.model.BasketModel;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketModelItemType;
import org.gcube.portlets.user.results.client.model.ResultObj;
import org.gcube.portlets.user.results.client.util.QuerySearchType;

public class Controller {
    private ResultsDisplayer newresultset;
    private BasketModel basketModel;
    private PopupPanel popup;
    private boolean popupIsShown = false;
    private boolean collNameVisible = false;

    public Controller(ResultsDisplayer newresultset) {
        this.newresultset = newresultset;
        this.basketModel = new BasketModel();
    }

    public void addBasketItem(FlexTable table, DraggableRow row) {
        String title = row.getTitle();
        BasketModelItem addedItem = new BasketModelItem(row.getUri(), row.getOid(), title, row.getTitle(), row.getResObject().getCollectionID(), row.getType(), Boolean.valueOf(true));
        this.basketModel.addBasketItemToModel(addedItem);
        BasketViewItem toAdd = new BasketViewItem(this, title, table, addedItem);
        if (!addedItem.isNew().booleanValue()) {
            toAdd.addStyleName("d4sFrame-highlight");
        }
        table.insertRow(0);
        table.setWidget(0, 0, (Widget)toAdd);
        this.enableSaveButton(true);
    }

    public void addBasketItem(ResultObj obj) {
        BasketModelItem addedItem = new BasketModelItem(obj.getObjectURI(), obj.getObjectURI(), obj.getTitle(), obj.getTitle(), obj.getCollectionID(), BasketModelItemType.INFO_OBJECT, Boolean.valueOf(true));
        this.basketModel.addBasketItemToModel(addedItem);
        FlexTable table = BasketView.get().getTable();
        BasketViewItem toAdd = new BasketViewItem(this, obj.getTitle(), table, addedItem);
        if (!addedItem.isNew().booleanValue()) {
            toAdd.addStyleName("d4sFrame-highlight");
        }
        table.insertRow(0);
        table.setWidget(0, 0, (Widget)toAdd);
        this.enableSaveButton(true);
    }

    public boolean basketItemExistYet(String oid) {
        List items = this.basketModel.getChildren();
        for (BasketModelItem item : items) {
            if (!item.isNew().booleanValue() || !item.getOid().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public void addQueryToBasket(String queryGivenName, String queryDesc, QuerySearchType querytype) {
        BasketModelItem addedItem = new BasketModelItem(queryGivenName, "", queryDesc, "---", BasketModelItemType.QUERY, Boolean.valueOf(true), querytype);
        this.basketModel.addBasketItemToModel(addedItem);
        FlexTable table = BasketView.get().getTable();
        BasketViewItem toAdd = new BasketViewItem(this, queryGivenName, table, addedItem);
        table.setWidget(table.getRowCount(), 0, (Widget)toAdd);
        this.enableSaveButton(true);
    }

    public void enableSaveButton(boolean enabled) {
        this.newresultset.getHeader().enableSaveButton(enabled);
    }

    public void enableSavQueryButton(boolean enable) {
        this.newresultset.getHeader().enableSaveQuery(this, enable);
    }

    public void enableMovePageresults(boolean enable) {
        this.newresultset.getHeader().enableMovePageresults(enable);
    }

    public void addPageResultsToBasket() {
        List currentDisplayedItems = this.getNewresultset().getRecordsPanel().currentDisplayedItems;
        for (ResultItem item : currentDisplayedItems) {
            this.addBasketItem(item.getResObject());
        }
        this.enableSaveButton(true);
    }

    public void addCollectionListbox(ListBox listbox) {
        this.newresultset.getRecordsPanel().showCollectionListbox(listbox);
    }

    public void displayResults(Vector<ResultObj> results, int from, int to, String currTotal, boolean normalResults, HashMap<String, String> externalLinks) {
        this.newresultset.getRecordsPanel().clear();
        this.newresultset.getRecordsPanel().displayresults(results, from, to, currTotal, normalResults);
    }

    public void enableNextButton(boolean enable) {
        if (enable) {
            this.newresultset.getHeader().showNextButton();
        } else {
            this.newresultset.getHeader().hideNextButton();
        }
    }

    public void enablePrevButton(boolean enable) {
        if (enable) {
            this.newresultset.getHeader().showPrevButton();
            this.newresultset.getHeader().showFirstPageButton();
        } else {
            this.newresultset.getHeader().hidePrevButton();
            this.newresultset.getHeader().hideFirstPageButton();
        }
    }

    public void addButtonsBottom(CellPanel panel) {
    }

    public ResultsDisplayer getNewresultset() {
        return this.newresultset;
    }

    public void hideLoading() {
        DialogBox loading = this.newresultset.getRecordsPanel().loading;
        loading.hide();
        this.enableSavQueryButton(true);
    }

    public void highlightBasket(boolean highlight) {
        if (highlight) {
            this.newresultset.getLeftPanel().getMainLayout().addStyleName("basket-highlight");
        } else {
            this.newresultset.getLeftPanel().getMainLayout().removeStyleName("basket-highlight");
        }
    }

    public void nextPageButtonClicked() {
        this.newresultset.getModel().getResultsFromSearchService(2);
    }

    public void displayQuery(String toDisplay) {
        this.newresultset.getRecordsPanel().displayQuery(toDisplay);
    }

    public void openFolder(String folderID) {
        this.basketModel.openBasket(this, this.newresultset.getLeftPanel(), folderID);
        this.enableSaveButton(false);
    }

    public void cleanBasket() {
        this.basketModel = new BasketModel();
        VerticalPanel tmp = this.newresultset.getLeftPanel().getMainLayout();
        tmp.remove(tmp.getWidgetCount() - 1);
        this.enableSaveButton(false);
    }

    public void prevPageButtonClicked() {
        this.newresultset.getModel().getResultsFromSearchService(1);
    }

    public void firstPageButtonClicked() {
        this.newresultset.getModel().getResultsFromSearchService(0);
    }

    public boolean removeBasketItemFromModel(BasketModelItem o) {
        if (o.isNew().booleanValue()) {
            this.basketModel.removeBasketItemFromModel(o);
            return true;
        }
        Window.alert((String)"This item was already present in the basket and cannot be removed, please use Workspace portlet to remove it.");
        return false;
    }

    public void saveBasket() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ResultsDisplayer.get().getModel().getResultService().saveBasket((AsyncCallback)callback);
    }

    public void setCurrBasketName(String html) {
        this.newresultset.getHeader().setCurrentBasket(html);
    }

    public void setCurrBasketPath(String path) {
        this.newresultset.getLeftPanel().setCurrPath(path);
    }

    public void setNewresultset(ResultsDisplayer newresultset) {
        this.newresultset = newresultset;
    }

    public void setPageDisplayer(String html) {
        this.newresultset.getHeader().setPageDisplayer(html);
    }

    public void showLoading() {
        DialogBox loading = this.newresultset.getRecordsPanel().loading;
        loading.setStyleName("unknown");
        int left = Window.getClientWidth() / 2 - 70;
        loading.setPopupPosition(left, 400);
        loading.show();
    }

    public void showNoResultsPopup(String msg, boolean showMsg) {
        this.popup = new NoResultsPopup(msg, false, showMsg);
        this.popup.setStyleName("unknown");
        int left = Window.getClientWidth() / 2 - 70;
        this.popup.setPopupPosition(left, 400);
        this.popup.show();
        this.popupIsShown = true;
    }

    public void hideNoResultsPopup() {
        if (this.popupIsShown) {
            this.popup.hide();
        }
    }

    public BasketModel getBasketModel() {
        return this.basketModel;
    }

    public void setCollectionNameVisibility(boolean visible) {
        List res = this.getNewresultset().getRecordsPanel().currentDisplayedItems;
        for (ResultItem resultItem : res) {
            resultItem.setCollectionVisibility(visible);
        }
        this.collNameVisible = visible;
    }

    public boolean isCollNameVisible() {
        return this.collNameVisible;
    }
}

