/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.server.servlet;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.results.client.components.TreeNode;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketSerializable;
import org.gcube.portlets.user.results.client.util.QueryDescriptor;
import org.gcube.portlets.user.results.client.util.QuerySearchType;
import org.gcube.portlets.user.results.server.servlet.NewresultsetServiceImpl;
import org.gcube.portlets.user.results.server.servlet.NewresultsetServiceUtil;
import org.gcube.portlets.user.results.shared.ContentInfo;
import org.gcube.portlets.user.results.shared.SearchableFieldBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewresultsetServiceUtil {
    private static Logger _log = Logger.getLogger(NewresultsetServiceUtil.class);

    protected static WorkspaceFolder getDefaultBasketWorkspaceFolder(NewresultsetServiceImpl caller) {
        Workspace workspaceArea = null;
        WorkspaceFolder basket = null;
        basket = (WorkspaceFolder)caller.getASLSession().getAttribute("SessionResultsPortletBasket");
        try {
            if (basket == null) {
                workspaceArea = caller.getWorkspaceArea();
                WorkspaceFolder root = workspaceArea.getRoot();
                basket = (WorkspaceFolder)root.find("My Default Basket");
                if (basket == null) {
                    _log.debug((Object)"There is no default basket for the user. Going to create it");
                    basket = workspaceArea.createFolder("My Default Basket", "This folder contains the objects saved from search results", root.getId());
                }
                caller.getASLSession().setAttribute("SessionResultsPortletBasket", (Object)basket);
            }
            _log.debug((Object)("Default Basket folder has name -> " + basket.getName() + " ID -> " + basket.getId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return basket;
    }

    protected static List<BasketModelItem> getBasketContent(NewresultsetServiceImpl caller, String basketId) {
        Workspace root = null;
        try {
            root = caller.getWorkspaceArea();
        }
        catch (WorkspaceFolderNotFoundException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        catch (HomeNotFoundException e) {
            e.printStackTrace();
        }
        WorkspaceItem item = null;
        try {
            item = root.getItem(basketId);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Item Type: " + item.getType()));
        if (item.getType() != WorkspaceItemType.FOLDER) {
            _log.debug((Object)("The item id does not belong to a basket id:" + basketId));
            return new LinkedList<BasketModelItem>();
        }
        LinkedList<BasketModelItem> readBasket = new LinkedList<BasketModelItem>();
        try {
            caller.storeBasketInSession(new BasketSerializable(basketId, item.getName(), item.getPath(), readBasket));
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Basket " + basketId + " stored in session"));
        return readBasket;
    }

    private static List<BasketModelItem> fillBasket(WorkspaceFolder basket) {
        LinkedList<BasketModelItem> toReturn = new LinkedList<BasketModelItem>();
        return toReturn;
    }

    protected static boolean saveBasket(NewresultsetServiceImpl caller) {
        BasketSerializable toSave = caller.readBasketFromSession();
        if (toSave != null) {
            List items = toSave.getItems();
            _log.debug((Object)("Number of items in basket to save -> " + items.size()));
            WorkspaceFolder basket = NewresultsetServiceUtil.getDefaultBasketWorkspaceFolder((NewresultsetServiceImpl)caller);
            try {
                FolderBulkCreator bbc = basket.getNewFolderBulkCreator();
                _log.debug((Object)("********************************  BASKET CREATOR CALLED    items size: -> " + items.size()));
                block9: for (BasketModelItem item : items) {
                    if (!item.isNew().booleanValue()) continue;
                    item.setIsNew(Boolean.valueOf(false));
                    _log.debug((Object)("Saving item to basket with URI -> " + item.getUri() + " and name -> " + item.getName()));
                    switch (1.$SwitchMap$org$gcube$portlets$user$results$client$model$BasketModelItemType[item.getItemType().ordinal()]) {
                        case 1: {
                            bbc.createExternalUrl(item.getUri());
                            continue block9;
                        }
                        case 2: {
                            QueryType type = NewresultsetServiceUtil.convertGWTquerytype((QuerySearchType)item.getSearchType());
                            _log.debug((Object)("****************************************************  SAVING QUERY: TYPE->" + type));
                            bbc.createQuery(item.getName(), item.getDescription(), type);
                            continue block9;
                        }
                    }
                    bbc.createDocumentItem(URI.create(item.getUri()));
                    ContentInfo info = caller.getContentToSave(item.getUri());
                    if (info != null) {
                        try {
                            basket.createExternalFileItem(item.getName(), item.getDescription(), info.getMimeType(), info.getIs());
                        }
                        catch (ItemAlreadyExistException e) {
                            _log.debug((Object)"Could not create the external file to basket", (Throwable)e);
                        }
                        continue;
                    }
                    _log.debug((Object)"InputStream was null for the main content of this object. Did not manage to save it. Either its type is unsupported or an error occurred");
                }
                bbc.commit();
            }
            catch (InsufficientPrivilegesException e) {
                _log.debug((Object)e.getMessage());
                return false;
            }
            catch (InternalErrorException e) {
                _log.debug((Object)e.getMessage());
                return false;
            }
            return true;
        }
        _log.debug((Object)"Failed to retrieve basket from session. returning with false flag");
        return false;
    }

    private static QueryType convertGWTquerytype(QuerySearchType type) {
        switch (1.$SwitchMap$org$gcube$portlets$user$results$client$util$QuerySearchType[type.ordinal()]) {
            case 1: {
                return QueryType.ADVANCED_SEARCH;
            }
        }
        return QueryType.SIMPLE_SEARCH;
    }

    public static WorkspaceFolder getBasketInstance(NewresultsetServiceImpl caller, String basketId) {
        Workspace root = null;
        try {
            root = caller.getWorkspaceArea();
        }
        catch (WorkspaceFolderNotFoundException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        catch (HomeNotFoundException e) {
            e.printStackTrace();
        }
        WorkspaceItem item = null;
        try {
            item = root.getItem(basketId);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Item Type: " + item.getType()));
        if (item.getType() != WorkspaceItemType.FOLDER) {
            _log.debug((Object)("The item id does not belong to a basket id -> " + basketId));
            return null;
        }
        return (WorkspaceFolder)item;
    }

    protected static TreeNode fillWorkspaceTree(WorkspaceFolder folder) throws InternalErrorException {
        LinkedList children = new LinkedList();
        TreeNode tmp = null;
        tmp = folder.getType() == WorkspaceItemType.FOLDER ? new TreeNode(folder.getName(), folder.getId(), folder.getPath(), children, 3, folder.getParent() == null) : new TreeNode(folder.getName(), folder.getId(), folder.getPath(), children, 2, folder.getParent() == null);
        return tmp;
    }

    protected static String getDisplayableQuery(QueryDescriptor qd) {
        String toReturn = "";
        switch (1.$SwitchMap$org$gcube$portlets$user$results$client$util$QuerySearchType[qd.getType().ordinal()]) {
            case 2: {
                toReturn = " BROWSE BY " + qd.getBrowseBy() + " IN ";
                for (int i = 0; i < qd.getSelectedCollections().size(); ++i) {
                    toReturn = toReturn + "'" + (String)qd.getSelectedCollections().get(i) + "'";
                    if (i == qd.getSelectedCollections().size() - 1) continue;
                    toReturn = toReturn + ", ";
                }
                return toReturn;
            }
            case 3: {
                toReturn = " '" + qd.getSimpleTerm() + "' IN ";
                for (int i = 0; i < qd.getSelectedCollections().size(); ++i) {
                    toReturn = toReturn + "'" + (String)qd.getSelectedCollections().get(i) + "'";
                    if (i == qd.getSelectedCollections().size() - 1) continue;
                    toReturn = toReturn + ", ";
                }
                return toReturn;
            }
            case 1: {
                for (SearchableFieldBean f : qd.getAdvancedFields()) {
                    toReturn = toReturn + f.getName() + " = " + f.getValue() + ", ";
                }
                toReturn = toReturn.substring(0, toReturn.length() - 1);
                toReturn = toReturn + " IN ";
                for (int i = 0; i < qd.getSelectedCollections().size(); ++i) {
                    toReturn = toReturn + "'" + (String)qd.getSelectedCollections().get(i) + "'";
                    if (i == qd.getSelectedCollections().size() - 1) continue;
                    toReturn = toReturn + ", ";
                }
                return toReturn;
            }
            case 4: {
                toReturn = "Distinct Values of: '" + qd.getBrowseBy() + "' FOR ";
                for (int i = 0; i < qd.getSelectedCollections().size(); ++i) {
                    toReturn = toReturn + "'" + (String)qd.getSelectedCollections().get(i) + "'";
                    if (i == qd.getSelectedCollections().size() - 1) continue;
                    toReturn = toReturn + ", ";
                }
                return toReturn;
            }
            case 5: {
                return qd.getSimpleTerm();
            }
        }
        return "";
    }
}

