/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.client.components;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.results.client.components.TreeNode;
import org.gcube.portlets.user.results.client.components.WPTreeItem;
import org.gcube.portlets.user.results.client.constants.ImageConstants;
import org.gcube.portlets.user.results.client.control.Controller;

public class WorkspaceTree
extends Composite
implements TreeListener {
    private CellPanel mainLayout = new VerticalPanel();
    private CellPanel headerPanel = new HorizontalPanel();
    private HorizontalPanel treePanel = new HorizontalPanel();
    private String defaultBaskedId;
    private PopupPanel myPanel;
    private Controller control;

    public WorkspaceTree(Controller controller, PopupPanel myPanel, TreeNode folder, String defaultBaskedId) {
        this.control = controller;
        this.defaultBaskedId = defaultBaskedId;
        this.myPanel = myPanel;
        int width = 270;
        Image closeButton = new Image(ImageConstants.CLOSE);
        HTML text = new HTML("Workspace Tree:");
        this.headerPanel.add((Widget)text);
        this.headerPanel.add((Widget)closeButton);
        this.headerPanel.setPixelSize(280, 15);
        this.headerPanel.setCellHorizontalAlignment((Widget)closeButton, HasAlignment.ALIGN_RIGHT);
        this.headerPanel.setCellHorizontalAlignment((Widget)text, HasAlignment.ALIGN_LEFT);
        ScrollPanel staticTreeWrapper = new ScrollPanel();
        Tree staticTree = this.createStaticTree(folder);
        staticTree.setAnimationEnabled(true);
        staticTreeWrapper.add((Widget)staticTree);
        staticTreeWrapper.setPixelSize(width, 280);
        this.treePanel.add((Widget)staticTreeWrapper);
        this.mainLayout.add((Widget)this.headerPanel);
        this.mainLayout.add((Widget)this.treePanel);
        this.initWidget((Widget)this.mainLayout);
        closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        closeButton.setStyleName("selectable");
    }

    private Tree createStaticTree(TreeNode folder) {
        Tree staticTree = new Tree();
        staticTree.addTreeListener((TreeListener)this);
        if (folder != null) {
            staticTree.addItem(this.listFolders(folder));
        } else {
            staticTree.addItem((Widget)new WPTreeItem("root", "00", 1));
        }
        return staticTree;
    }

    protected TreeItem listFolders(TreeNode folder) {
        WPTreeItem tmp = null;
        if (folder.isRoot()) {
            tmp = new WPTreeItem(folder.getLabel(), folder.getId(), 1);
        } else if (folder.getType() == 3) {
            tmp = new WPTreeItem(folder.getLabel(), folder.getId(), 3);
            if (folder.getId().equals(this.defaultBaskedId)) {
                this.openDefaultBasket(tmp, folder.getPath());
            }
        } else {
            tmp = new WPTreeItem(folder.getLabel(), folder.getId(), 2);
        }
        TreeItem item = new TreeItem((Widget)tmp);
        return item;
    }

    private void openDefaultBasket(WPTreeItem selectedBasket, String path) {
        this.control.setCurrBasketPath(path);
        String name = selectedBasket.getLabel();
        this.control.setCurrBasketName(name);
        String basketid = selectedBasket.getId();
        this.control.openFolder(basketid);
    }

    public void onTreeItemSelected(TreeItem item) {
        WPTreeItem selectedBasket = (WPTreeItem)item.getWidget();
        WPTreeItem wpclicked = (WPTreeItem)item.getWidget();
        if (item.getChildCount() == 0 && wpclicked.getType() != 1 && wpclicked.getType() != 2) {
            WPTreeItem clicked;
            String path = "";
            while (item.getParentItem() != null) {
                clicked = (WPTreeItem)item.getWidget();
                path = clicked.getItemText().getText() + "/" + path;
                item = item.getParentItem();
            }
            clicked = (WPTreeItem)item.getWidget();
            path = "/" + clicked.getItemText().getText() + "/" + path;
            item = item.getParentItem();
            this.control.setCurrBasketPath(path);
            String name = selectedBasket.getLabel();
            this.control.setCurrBasketName(name);
            String basketid = selectedBasket.getId();
            this.control.openFolder(basketid);
            this.myPanel.hide();
        } else {
            PopupPanel simplePopupPanel = new PopupPanel(true);
            VerticalPanel vpanel = new VerticalPanel();
            vpanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            vpanel.add((Widget)new Label("Only baskets are selectable"));
            Button closeButton = new Button("Close");
            closeButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            vpanel.add((Widget)closeButton);
            simplePopupPanel.setTitle("");
            simplePopupPanel.setWidget((Widget)vpanel);
            simplePopupPanel.setPopupPosition(item.getAbsoluteLeft(), item.getAbsoluteTop());
            simplePopupPanel.show();
        }
    }

    public void onTreeItemStateChanged(TreeItem item) {
    }
}

