package org.gcube.portlets.user.results.client;

import java.util.List;
import java.util.TreeMap;

import org.gcube.portlets.user.results.client.components.TreeNode;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketSerializable;
import org.gcube.portlets.user.results.client.model.Client_DigiObjectInfo;
import org.gcube.portlets.user.results.client.model.ResultNumber;
import org.gcube.portlets.user.results.client.model.ResultsContainer;
import org.gcube.portlets.user.results.client.util.QueryDescriptor;
import org.gcube.portlets.user.results.shared.GenericTreeRecordBean;
import org.gcube.portlets.user.results.shared.ObjectType;

import com.google.gwt.user.client.rpc.RemoteService;

/**
 * <code> ResultsetService </code> interface for server calls
 *
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @version January 2009 (0.1) 
 */
public interface ResultsetService extends RemoteService {

	/**
	 * Check whether the porlet has been loaded after a search or not
	 * 
	 * @return true if the user performed a search, false otherwise
	 */
	boolean isSearchActive();
	
	/**
	 * @return A <code>ResultsContainer</code> (Vector<ResultObj>, Optional paramters)  which contains the current yet shown results (if any)
	 *
	 */
	ResultsContainer getResultsFromSession();
	
	/**
	 * @param mode 0 means "get first results", 1 means "get previous results" and 2 means "get next results".
	 * @return a Vector containing the html representation of each record.
	 */
	ResultsContainer getResultFromSearchService(int mode);
	
	/**
	 * used to get the additional info for the digital objects,
	 * @param currPosition in resultset
	 * @return additional info (name, MimeType.....)
	 */
	Client_DigiObjectInfo getDigitalObjectInitialInfo(int currPosition);
	
	
	/**
	 * used to get the additional info for the digital objects given a oid
	 * @param objectid the oid
	 * @return additional info (name, MimeType.....)
	 */
	//Client_DigiObjectInfo getDigitalObjectOnDemand(String objectid, String belongsTo, BasketModelItemType type);
	
	
	/**
	 * return the url of the thumbnail given the oid
	 * @param oid
	 * @return
	 */
	//String getThumbnail(String oid);
	
	/**
	 * 
	 * @return
	 */
	String[] getCollectionNames();
	
	/**
	 * 
	 * @param qid
	 */
	void loadResults(String qid);
	
	/**
	 * 
	 * @return
	 */
	TreeNode getWorkspaceTree();
	
	/**
	 * return the id of the default basket
	 * @return the default basket
	 */
	String getDefaultBasket(); 
	/**
	 * 
	 * @param basketId
	 * @return
	 * @throws ItemNotFoundException
	 * @throws BasketNotFoundException
	 */
	List<BasketModelItem> getBasketContent(String basketId);
	
	/**
	 * read the basket from the session, if any
	 * @return
	 */
	BasketSerializable readBasketFromSession();
	
	/**
	 * add a single item in session
	 * @param item item to add
	 */
	Boolean storeBasketItemInSession(BasketModelItem toAdd);
	
	/**
	 * 
	 * @param toRemove item to remove
	 * @return remove result
	 */
	Boolean removeBasketItemFromSession(BasketModelItem toRemove);
	
	/**
	 * This method stores on the session some information that is needed from the Annotation portlets in order to operate
	 * @param CollectionId the ID of the collection that the digital object belongs to 
	 * @param OIDForAnn the ID of the digital object
	 * @param TitleOfTheDocument the title of the digital object as it is defined on the metadata of this object
	 */
	//void getAnnotations(String CollectionId, String OIDForAnn, String TitleOfTheDocument);

	/**
	 * @param CollectionId the ID of the metadtaa collection that the digital object belongs to 
	 * @param objectID the ID of the digital object
	 */
	//void getMetadata(String collectionId, String MetadataCollectionId, String objectID);
	/**
	 * This method stores on the session some information that is needed from the Content Viewer portlet in order to operate
	 * @param objectID the OID of the Object
	 */
	//void setContentViewerOID(String objectID);
	/**
	 * Calls the home library to save the current basket in session permanently	 * 
	 */
	boolean saveBasket();
	
	/**
	 * 
	 * @return
	 */
	QueryDescriptor getQueryDescFromSession();
	
	/**
	 * 
	 * @param md_oid
	 * @param MetadataCollectionId
	 * @return
	 */
	//MetadataDescriptor getMetadataFormatAndLang(String oid, String belongsTO);
	
	/**
	 * 
	 * @return a ResultNumber instance containing the num of results found so far plus a boolean that say if is still counting or not
	 */
	ResultNumber getResultsNo();
	
	/**
	 * 
	 * @param queryTerm
	 */
	public void submitSimpleQuery(String queryTerm);
	
	public String getObjectsPayload(String objectURI);
	
	public GenericTreeRecordBean getObjectInfo(String objectURI);
	
	public TreeMap<String, List<String>> getContentURLs(GenericTreeRecordBean recordBean);

	public String transformMetadata(String payload, ObjectType type);
}
