/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.server.servlet;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.results.client.components.TreeNode;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketModelItemType;
import org.gcube.portlets.user.results.client.model.BasketSerializable;
import org.gcube.portlets.user.results.client.util.QueryDescriptor;
import org.gcube.portlets.user.results.client.util.QuerySearchType;
import org.gcube.portlets.user.results.server.servlet.NewresultsetServiceImpl;
import org.gcube.portlets.user.results.server.servlet.NewresultsetServiceUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewresultsetServiceUtil {
    private static GCUBELog _log = new GCUBELog(NewresultsetServiceImpl.class);

    protected static List<BasketModelItem> getBasketContent(NewresultsetServiceImpl caller, String basketId) {
        Workspace root = null;
        try {
            root = caller.getWorkspaceArea();
        }
        catch (WorkspaceFolderNotFoundException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        catch (HomeNotFoundException e) {
            e.printStackTrace();
        }
        WorkspaceItem item = null;
        try {
            item = root.getItem(basketId);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Item Type: " + item.getType()));
        if (item.getType() != WorkspaceItemType.FOLDER) {
            _log.debug((Object)("The item id does not belong to a basket id:" + basketId));
            return new LinkedList<BasketModelItem>();
        }
        List readBasket = NewresultsetServiceUtil.fillBasket((WorkspaceFolder)((WorkspaceFolder)item));
        try {
            caller.storeBasketInSession(new BasketSerializable(basketId, item.getName(), item.getPath(), readBasket));
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Basket " + basketId + " stored in session"));
        return readBasket;
    }

    private static List<BasketModelItem> fillBasket(WorkspaceFolder basket) {
        LinkedList<BasketModelItem> toReturn = new LinkedList<BasketModelItem>();
        try {
            block13: for (WorkspaceItem item : basket.getChildren()) {
                if (item.getType() == WorkspaceItemType.FOLDER) {
                    toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.FOLDER, Boolean.valueOf(false)));
                    continue;
                }
                if (item.getType() == WorkspaceItemType.SHARED_FOLDER || item.getType() == WorkspaceItemType.SMART_FOLDER) {
                    toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.SHARED_FOLDER, Boolean.valueOf(false)));
                    continue;
                }
                FolderItem fi = (FolderItem)item;
                switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$folder$FolderItemType[fi.getFolderItemType().ordinal()]) {
                    case 1: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.EXTERNAL_FILE, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 2: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.EXTERNAL_PDF_FILE, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 3: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.EXTERNAL_IMAGE, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 4: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.INFO_OBJECT, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 5: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.INFO_OBJECT_LINK, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 6: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.QUERY, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 7: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.REPORT, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 8: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.REPORT_TEMPLATE, Boolean.valueOf(false)));
                        continue block13;
                    }
                    case 9: {
                        toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.TIMESERIES, Boolean.valueOf(false)));
                        continue block13;
                    }
                }
                toReturn.add(new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.INFO_OBJECT, Boolean.valueOf(false)));
            }
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    protected static boolean saveBasket(NewresultsetServiceImpl caller) {
        BasketSerializable toSave = caller.readBasketFromSession();
        List items = toSave.getItems();
        WorkspaceFolder basket = NewresultsetServiceUtil.getBasketInstance((NewresultsetServiceImpl)caller, (String)toSave.getId());
        try {
            FolderBulkCreator bbc = basket.getNewFolderBulkCreator();
            _log.debug((Object)("********************************  BASKET CREATOR CALLED    items size: -> " + items.size()));
            block12: for (BasketModelItem item : items) {
                _log.trace((Object)("********************************  BASKET FOUND ITEM: Name    -> " + item.getName()));
                _log.trace((Object)("********************************  \t\t\t\t : isNew()?-> " + item.isNew()));
                _log.trace((Object)("********************************  \t\t\t\t : OID  ()?-> " + item.getOid()));
                _log.trace((Object)("********************************  \t\t\t\t : URI  ()?-> " + item.getUri()));
                if (!item.isNew().booleanValue()) continue;
                item.setIsNew(Boolean.valueOf(false));
                switch (1.$SwitchMap$org$gcube$portlets$user$results$client$model$BasketModelItemType[item.getItemType().ordinal()]) {
                    case 1: {
                        bbc.createDocumentAlternativeItem(URI.create(item.getUri()));
                        continue block12;
                    }
                    case 2: {
                        bbc.createMetadata(URI.create(item.getUri()));
                        continue block12;
                    }
                    case 3: {
                        bbc.createAnnotation(URI.create(item.getUri()));
                        continue block12;
                    }
                    case 4: {
                        bbc.createDocumentPartItem(URI.create(item.getUri()));
                        continue block12;
                    }
                    case 5: {
                        bbc.createExternalUrl(item.getOid());
                        continue block12;
                    }
                    case 6: {
                        bbc.createExternalUrl(item.getOid());
                        continue block12;
                    }
                    case 7: {
                        QueryType type = NewresultsetServiceUtil.convertGWTquerytype((QuerySearchType)item.getSearchType());
                        _log.debug((Object)("****************************************************  SAVING QUERY: TYPE->" + type));
                        bbc.createQuery(item.getName(), item.getDescription(), type);
                        continue block12;
                    }
                }
                bbc.createDocumentItem(URI.create(item.getUri()));
            }
            bbc.commit();
        }
        catch (InsufficientPrivilegesException e) {
            _log.debug((Object)e.getMessage());
            return false;
        }
        catch (InternalErrorException e) {
            _log.debug((Object)e.getMessage());
            return false;
        }
        return true;
    }

    private static QueryType convertGWTquerytype(QuerySearchType type) {
        switch (1.$SwitchMap$org$gcube$portlets$user$results$client$util$QuerySearchType[type.ordinal()]) {
            case 1: {
                return QueryType.ADVANCED_SEARCH;
            }
            case 2: {
                return QueryType.GEO_SEARCH;
            }
            case 3: {
                return QueryType.GEO_SEARCH;
            }
            case 4: {
                return QueryType.SIMPLE_SEARCH;
            }
        }
        return QueryType.QUICK_SEARCH;
    }

    public static WorkspaceFolder getBasketInstance(NewresultsetServiceImpl caller, String basketId) {
        Workspace root = null;
        try {
            root = caller.getWorkspaceArea();
        }
        catch (WorkspaceFolderNotFoundException e) {
            e.printStackTrace();
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
        }
        catch (HomeNotFoundException e) {
            e.printStackTrace();
        }
        WorkspaceItem item = null;
        try {
            item = root.getItem(basketId);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("Item Type: " + item.getType()));
        if (item.getType() != WorkspaceItemType.FOLDER) {
            _log.debug((Object)("The item id does not belong to a basket id:" + basketId));
            return null;
        }
        return (WorkspaceFolder)item;
    }

    protected static TreeNode fillWorkspaceTree(WorkspaceFolder folder) throws InternalErrorException {
        LinkedList<TreeNode> children = new LinkedList<TreeNode>();
        TreeNode tmp = null;
        tmp = folder.getType() == WorkspaceItemType.FOLDER ? new TreeNode(folder.getName(), folder.getId(), folder.getPath(), children, 3, folder.getParent() == null) : new TreeNode(folder.getName(), folder.getId(), folder.getPath(), children, 2, folder.getParent() == null);
        for (WorkspaceItem child : folder.getChildren()) {
            if (child.getType() != WorkspaceItemType.FOLDER) continue;
            children.add(NewresultsetServiceUtil.fillWorkspaceTree((WorkspaceFolder)((WorkspaceFolder)child)));
        }
        return tmp;
    }

    protected static String getDisplayableQuery(QueryDescriptor qd) {
        String toReturn = "";
        switch (1.$SwitchMap$org$gcube$portlets$user$results$client$util$QuerySearchType[qd.getType().ordinal()]) {
            case 5: {
                return " BROWSE BY " + qd.getBrowseBy() + " IN " + (String)qd.getSelectedCollections().get(0);
            }
            case 6: {
                return qd.getTerm();
            }
            case 4: {
                toReturn = " '" + qd.getTerm() + "' IN ";
                for (int i = 0; i < qd.getSelectedCollections().size(); ++i) {
                    toReturn = toReturn + "'" + (String)qd.getSelectedCollections().get(i) + "'";
                    if (i == qd.getSelectedCollections().size() - 1) continue;
                    toReturn = toReturn + ", ";
                }
                return toReturn;
            }
            case 1: {
                toReturn = qd.getTerm() + " IN ";
                for (int i = 0; i < qd.getSelectedCollections().size(); ++i) {
                    toReturn = toReturn + "'" + (String)qd.getSelectedCollections().get(i) + "'";
                    if (i == qd.getSelectedCollections().size() - 1) continue;
                    toReturn = toReturn + ", ";
                }
                return toReturn;
            }
            case 3: {
                return "google search: " + qd.getTerm();
            }
            case 7: {
                return "field Values of: " + (String)qd.getSelectedCollections().get(0) + " by: " + qd.getBrowseBy();
            }
            case 8: {
                return qd.getTerm();
            }
        }
        return "";
    }
}

