/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.client.components;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.results.client.components.BasketViewItem;
import org.gcube.portlets.user.results.client.constants.FileTypeImagesConstants;
import org.gcube.portlets.user.results.client.constants.ImageConstants;
import org.gcube.portlets.user.results.client.control.Controller;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketModelItemType;

public class BasketViewItem
extends Composite {
    public static final int WIDTH = 260;
    public static final int HEIGHT = 25;
    private BasketViewItem myInstance;
    private BasketModelItem myItem;
    private FlexTable myTable;
    private Controller controller;
    private Image thumb = new Image();
    private Label caption;
    private CellPanel mainLayout = new HorizontalPanel();

    public BasketViewItem(Controller controller, String label, FlexTable table, BasketModelItem myItem) {
        this.myInstance = this;
        this.myItem = myItem;
        this.myTable = table;
        this.controller = controller;
        this.applyImage(label, myItem.getItemType());
        String toDisplay = label;
        if (label.length() > 60) {
            toDisplay = label.substring(0, 60);
            toDisplay = toDisplay + " ...";
        }
        this.caption = new Label(" " + toDisplay);
        this.caption.setTitle(label);
        this.thumb.setPixelSize(16, 16);
        this.caption.setPixelSize(210, 25);
        VerticalPanel menuPanel = new VerticalPanel();
        menuPanel.setPixelSize(40, 20);
        menuPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        menuPanel.add((Widget)this.getActionsMenu());
        this.mainLayout.setPixelSize(260, 25);
        this.mainLayout.add((Widget)this.thumb);
        this.mainLayout.add((Widget)new HTML("&nbsp;&nbsp;", true));
        this.mainLayout.add((Widget)this.caption);
        this.mainLayout.add((Widget)this.getCloseButton());
        this.mainLayout.setCellVerticalAlignment((Widget)this.thumb, HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainLayout.setCellVerticalAlignment((Widget)this.caption, HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainLayout.setSpacing(1);
        this.mainLayout.setStyleName("gcube_basket_item_new");
        this.initWidget((Widget)this.mainLayout);
    }

    public String getCaption() {
        return this.caption.getText();
    }

    public void setCaption(String caption) {
        this.caption.setText(caption);
    }

    public Image getThumb() {
        return this.thumb;
    }

    public void setThumb(Image thumb) {
        this.thumb = thumb;
    }

    private Image getCloseButton() {
        Image close = new Image(ImageConstants.CLOSE);
        close.setStyleName("button_help");
        close.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return close;
    }

    private MenuBar getActionsMenu() {
        2 openPreview = new /* Unavailable Anonymous Inner Class!! */;
        3 deleteBasket = new /* Unavailable Anonymous Inner Class!! */;
        MenuBar actionsMenu = new MenuBar(true);
        actionsMenu.setAnimationEnabled(true);
        actionsMenu.addItem("Delete from basket", (Scheduler.ScheduledCommand)deleteBasket);
        actionsMenu.setWidth("120");
        MenuItem menuitem = new MenuItem("<img class=\"button_help\" src=\"" + ImageConstants.ICO + "\"/>&nbsp;", true, actionsMenu);
        boolean menuNextToRecord = true;
        MenuBar newMenu = new MenuBar(menuNextToRecord);
        newMenu.setStyleName("custom-menu");
        newMenu.getElement().getStyle().setProperty("background", "transparent");
        menuitem.getElement().getStyle().setProperty("background", "transparent");
        newMenu.addItem(menuitem);
        return newMenu;
    }

    public void applyImage(String label, BasketModelItemType type) {
        if (type == BasketModelItemType.EXTERNAL_FILE) {
            if (label.lastIndexOf(".") >= 0) {
                String extension = label.substring(label.lastIndexOf("."), label.length());
                if (extension.equals(".mp3")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_MP3);
                } else if (extension.equals(".txt")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_TXT);
                } else if (extension.equals(".jpg")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_JPG);
                } else if (extension.equals(".xml")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_TXT);
                } else if (extension.equals(".doc")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_DOC);
                } else if (extension.equals(".pdf")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_PDF);
                } else if (extension.equals(".zip")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_ZIP);
                } else if (extension.equals(".docx")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_DOC);
                } else if (extension.equals(".doc")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_DOC);
                } else if (extension.equals(".html")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_HTML);
                } else if (extension.equals(".htm")) {
                    this.thumb = new Image(FileTypeImagesConstants.BASKET_HTML);
                }
            } else {
                this.thumb = new Image(ImageConstants.BASKET_EXTERNAL);
            }
        } else {
            switch (4.$SwitchMap$org$gcube$portlets$user$results$client$model$BasketModelItemType[type.ordinal()]) {
                case 1: {
                    this.thumb = new Image(ImageConstants.BASKET_EXTERNAL_IMAGE);
                    break;
                }
                case 2: {
                    this.thumb = new Image(ImageConstants.BASKET_EXTERNAL_PDF);
                    break;
                }
                case 3: {
                    this.thumb = new Image(ImageConstants.BASKET_GENERIC_DSO);
                    break;
                }
                case 4: {
                    this.thumb = new Image();
                    break;
                }
                case 5: {
                    this.thumb = new Image(ImageConstants.BASKET_QUERY);
                    break;
                }
                case 6: {
                    this.thumb = new Image(ImageConstants.BASKET_REPORT);
                    break;
                }
                case 7: {
                    this.thumb = new Image(ImageConstants.BASKET_TEMPLATE);
                    break;
                }
                case 8: {
                    this.thumb = new Image(ImageConstants.BASKET_METADATA);
                    this.thumb.setTitle("Metadata");
                    break;
                }
                case 9: {
                    this.thumb = new Image(ImageConstants.BASKET_ANNOTATION);
                    this.thumb.setTitle("Annotation");
                    break;
                }
                case 10: {
                    this.thumb = new Image(ImageConstants.BASKET_PART);
                    this.thumb.setTitle("Part");
                    break;
                }
                case 11: {
                    this.thumb = new Image(ImageConstants.BASKET_ALTERNATIVE);
                    this.thumb.setTitle("Alternative Representation");
                    break;
                }
                case 12: {
                    this.thumb = new Image(ImageConstants.BASKET_GOOGLE);
                    this.thumb.setTitle("Google Result");
                    break;
                }
                case 13: {
                    this.thumb = new Image(ImageConstants.BASKET_TS);
                    this.thumb.setTitle("Time Series");
                    break;
                }
                case 14: {
                    this.thumb = new Image(ImageConstants.FOLDER);
                    this.thumb.setTitle("Time Series");
                    break;
                }
                case 15: {
                    this.thumb = new Image(ImageConstants.SHARED_FOLDER);
                    this.thumb.setTitle("Shared Folder");
                    break;
                }
                default: {
                    this.thumb = new Image(ImageConstants.BASKET_EXTERNAL);
                }
            }
        }
    }

    static /* synthetic */ BasketModelItem access$000(BasketViewItem x0) {
        return x0.myItem;
    }

    static /* synthetic */ Controller access$100(BasketViewItem x0) {
        return x0.controller;
    }

    static /* synthetic */ BasketViewItem access$200(BasketViewItem x0) {
        return x0.myInstance;
    }
}

