package org.gcube.portlets.user.results.client.util;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * 
 * @author massi
 *
 */
public class QueryDescriptor implements IsSerializable{

	private String term;
	private List<String> selectedCollections;
	private String description;
	private String browseBy;
	private String language;
	private QuerySearchType type;
	
	
	public QueryDescriptor() {}

	public QueryDescriptor(String qdesc) {
		term = qdesc;
		this.description = "";
		this.browseBy = "";
		this.language = "";
		this.selectedCollections = null;

		this.type = QuerySearchType.SIMPLE;
	}


	public QueryDescriptor(String term, List<String> selectedCollections, String description, String language, QuerySearchType type, String browseBy) {
		super();
		this.description = description;
		this.browseBy = browseBy;
		this.language = language;
		this.selectedCollections = selectedCollections;
		this.term = term;
		this.type = type;
	}

	public String getBrowseBy() {
		return browseBy;
	}

	public void setBrowseBy(String browseBy) {
		this.browseBy = browseBy;
	}


	public String getLanguage() {
		return language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}

	public String getDescription() {
		return description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public List<String> getSelectedCollections() {
		return selectedCollections;
	}
	
	public void setSelectedCollections(List<String> selectedCollections) {
		this.selectedCollections = selectedCollections;
	}
	
	public String getTerm() {
		return term;
	}
	
	public void setTerm(String term) {
		this.term = term;
	}

	public QuerySearchType getType() {
		return type;
	}

	public void setType(QuerySearchType type) {
		this.type = type;
	}	
	
}
