/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.server.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.GenericResource;
import org.gcube.application.framework.userprofiles.library.impl.UserProfile;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.results.server.servlet.NewresultsetServiceImpl;

public class MetadataConverter {
    GCUBELog _log = new GCUBELog(MetadataConverter.class);
    protected Map<String, String> schemaNameId = new LinkedHashMap();
    protected Map<String, String> xsltCache = new LinkedHashMap();
    protected boolean setup = false;
    private NewresultsetServiceImpl myServlet;

    public MetadataConverter(NewresultsetServiceImpl myServlet) {
        this.myServlet = myServlet;
    }

    public synchronized void setup(ASLSession d4session) {
        if (!this.setup) {
            this.retrieveXSLTIds(d4session);
        }
    }

    public synchronized void isReady() {
    }

    public String convert(String schemaName, String xml, ASLSession d4session) throws Exception {
        this._log.debug((Object)("convert schemaName: " + schemaName + " xml.length: " + xml.length() + " session: " + d4session));
        String xsltId = null;
        for (String schemaid : this.schemaNameId.keySet()) {
            this._log.debug((Object)("schemakey" + schemaid));
        }
        if (this.schemaNameId.containsKey(schemaName)) {
            xsltId = (String)this.schemaNameId.get(schemaName);
        } else if (this.schemaNameId.containsKey(schemaName.toLowerCase())) {
            xsltId = (String)this.schemaNameId.get(schemaName.toLowerCase());
        } else if (this.schemaNameId.containsKey(schemaName.toUpperCase())) {
            xsltId = (String)this.schemaNameId.get(schemaName.toUpperCase());
        }
        this._log.debug((Object)("XSLT ID: " + xsltId));
        String xslt = null;
        if (xsltId != null) {
            try {
                xslt = this.getXSL(xsltId, d4session);
            }
            catch (RemoteException e) {
                this._log.error((Object)"Error during xslt retrieving");
            }
        }
        if (xslt == null) {
            try {
                xslt = this.getDefaultXSLT();
            }
            catch (IOException e) {
                this._log.error((Object)"Error during default xslt retrieving");
                throw e;
            }
        }
        if (xslt == null) {
            throw new Exception("No xslt found");
        }
        String html = this.transform(xml, xslt);
        return html;
    }

    public String convertUsingDefault(String xml, ASLSession d4session) throws Exception {
        this._log.debug((Object)("convertUsingDefault xml.length: " + xml.length() + " session: " + d4session));
        String xslt = this.getDefaultXSLT();
        if (xslt == null) {
            throw new Exception("No xslt found");
        }
        String html = this.transform(xml, xslt);
        return html;
    }

    protected void retrieveXSLTIds(ASLSession session) {
        this._log.debug((Object)"retrieveXSLTIds CALLING USER PROFILE");
        UserProfile userprofile = new UserProfile(session);
        this._log.debug((Object)("Profile loaded, calling getMetadataXSLTs with user " + session.getUsername()));
        HashMap idSchemaNameMap = userprofile.getMetadataXSLTs(session.getUsername());
        this._log.debug((Object)("FOUND " + idSchemaNameMap.size() + " schema maps"));
        this._log.debug((Object)"ITERATING THE HASMAP ");
        for (Map.Entry idSchemaName : idSchemaNameMap.entrySet()) {
            String id = (String)idSchemaName.getValue();
            String schemaName = (String)idSchemaName.getKey();
            this._log.trace((Object)("id: " + id + " schema: " + schemaName));
            this._log.trace((Object)("PUTTING in schemaNameId " + schemaName + "," + id));
            this.schemaNameId.put(schemaName, id);
        }
    }

    protected String getXSL(String xsltId, ASLSession d4session) throws RemoteException {
        if (this.xsltCache.containsKey(xsltId)) {
            return (String)this.xsltCache.get(xsltId);
        }
        String xslt = this.retrieveXSLT(xsltId, d4session);
        if (xslt == null) {
            return null;
        }
        this.xsltCache.put(xsltId, xslt);
        return xslt;
    }

    protected String retrieveXSLT(String xslId, ASLSession d4session) throws RemoteException {
        GenericResource resource = new GenericResource(d4session);
        List genericResources = resource.getGenericResourceByID(xslId);
        if (genericResources.size() == 0) {
            this._log.error((Object)("xsltId resource not found for id " + xslId));
            return null;
        }
        ISGenericResource xsltResource = (ISGenericResource)genericResources.get(0);
        String xsltBody = xsltResource.getBody();
        String xslt = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xsltBody;
        return xslt;
    }

    protected String transform(String xml, String xslt) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(new ByteArrayInputStream(xslt.getBytes()));
        Templates compiledXSLT = tf.newTemplates(source);
        Transformer t = compiledXSLT.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "true");
        StringWriter w = new StringWriter();
        t.transform(new StreamSource(new StringReader(xml)), new StreamResult(w));
        return w.toString();
    }

    protected String getDefaultXSLT() throws IOException {
        FileInputStream fis = new FileInputStream(this.myServlet.getRealPath() + "/config/xmlverbatim.xsl");
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader filebuf = null;
        String nextStr = null;
        String toReturn = new String();
        try {
            filebuf = new BufferedReader(isr);
            nextStr = filebuf.readLine();
            while (nextStr != null) {
                toReturn = toReturn + nextStr;
                nextStr = filebuf.readLine();
            }
            filebuf.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return toReturn;
    }
}

