/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.results.client.panels;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.user.results.client.components.ResultItem;
import org.gcube.portlets.user.results.client.constants.ImageConstants;
import org.gcube.portlets.user.results.client.control.Controller;
import org.gcube.portlets.user.results.client.control.FlexTableRowDragController;
import org.gcube.portlets.user.results.client.dialogBox.LoadingPopup;
import org.gcube.portlets.user.results.client.model.ResultObj;

public class RecordsPanel
extends Composite {
    public static final int HEADERPART_HEIGHT = 40;
    public static final int HEADERPART_WIDTH = Window.getClientWidth();
    private Controller controller;
    public static RecordsPanel singleton = null;
    public List<ResultItem> currentDisplayedItems;
    public DialogBox loading = new LoadingPopup(true);
    private CellPanel mainLayout = new VerticalPanel();
    private CellPanel headerpart = new HorizontalPanel();
    private VerticalPanel resultsPanel = new VerticalPanel();
    private HorizontalPanel rpanel = new HorizontalPanel();
    private HorizontalPanel lpanel = new HorizontalPanel();
    private FlexTable table;
    private ListBox collectionsList = new ListBox();
    private FlexTableRowDragController dragController;
    private int n = 0;
    private HTML queryHTML = new HTML();
    boolean bottomPanelAdded = false;

    public static RecordsPanel get() {
        return singleton;
    }

    public RecordsPanel(Controller c, FlexTableRowDragController dragController) {
        singleton = this;
        this.dragController = dragController;
        this.controller = c;
        this.table = new FlexTable();
        this.table.setCellPadding(10);
        this.mainLayout.setStyleName("recordsPanel");
        this.mainLayout.setSize("90%", "100%");
        this.headerpart.setWidth("100%");
        this.lpanel.setPixelSize(700, 40);
        this.lpanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.lpanel.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
        this.lpanel.add((Widget)this.queryHTML);
        this.collectionsList.addItem("collection prova");
        Image imgToAdd = new Image(ImageConstants.YOU_CAN_DRAG);
        this.rpanel.add((Widget)imgToAdd);
        this.rpanel.add((Widget)new HTML("&nbsp;&nbsp;", true));
        this.headerpart.add((Widget)this.lpanel);
        this.headerpart.add((Widget)this.rpanel);
        this.headerpart.setCellHorizontalAlignment((Widget)this.lpanel, HasAlignment.ALIGN_LEFT);
        this.headerpart.setCellHorizontalAlignment((Widget)this.rpanel, HasAlignment.ALIGN_RIGHT);
        this.headerpart.setCellVerticalAlignment((Widget)this.lpanel, HasVerticalAlignment.ALIGN_TOP);
        this.headerpart.setCellVerticalAlignment((Widget)this.rpanel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainLayout.add((Widget)this.headerpart);
        this.mainLayout.add((Widget)this.resultsPanel);
        this.mainLayout.setCellHeight((Widget)this.headerpart, "30");
        this.resultsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.resultsPanel.add((Widget)this.table);
        this.initWidget((Widget)this.mainLayout);
    }

    public void displayQuery(String toDisplay) {
        String query = "\"" + toDisplay + "\"";
        this.queryHTML.setHTML("<div style=\"color:gray font-size:12px\"><strong>Your Query: </strong> " + query + "</div>");
    }

    public void addRecord(ResultItem toadd) {
        ++this.n;
        this.table.setWidget(this.n, 1, (Widget)toadd);
    }

    public void displayresults(Vector<ResultObj> results, int from, int to, String currTotal, boolean normalResults) {
        if (!normalResults) {
            this.displayFieldValues(results, from, to, currTotal);
        } else {
            this.controller.setPageDisplayer("displaying " + from + " - " + to + " of " + currTotal);
            this.currentDisplayedItems = new LinkedList();
            for (int i = from; i <= to; ++i) {
                if (i > 0 && i <= results.size()) {
                    ResultObj obj = results.elementAt(i - 1);
                    ResultItem toadd = new ResultItem(this.controller, obj, i, new Image(ImageConstants.INNER_RECORD_LOADER), this.dragController);
                    this.currentDisplayedItems.add(toadd);
                    this.addRecord(toadd);
                    continue;
                }
                if (i < results.size()) continue;
                this.controller.setPageDisplayer("displaying " + from + " - " + results.size());
                break;
            }
            this.controller.enableMovePageresults(true);
            this.controller.enableSavQueryButton(true);
        }
        this.controller.getNewresultset().getLeftPanel().resizeBasket();
        if (from == 1 && !this.bottomPanelAdded) {
            this.addNextPreviousButtons();
            this.bottomPanelAdded = true;
        }
        this.controller.setCollectionNameVisibility(this.controller.isCollNameVisible());
    }

    public void displayFieldValues(Vector<ResultObj> results, int from, int to, String currTotal) {
        this.controller.setPageDisplayer("displaying " + from + " - " + to + " of " + currTotal);
        for (int i = from; i <= to; ++i) {
            if (i > 0 && i <= results.size()) {
                ++this.n;
                HorizontalPanel sp = new HorizontalPanel();
                sp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                String term = results.get(i - 1).getHtmlText();
                HTML result = new HTML("&nbsp;&nbsp;<a>" + term + "</a>");
                result.addStyleName("selectable");
                sp.add((Widget)result);
                sp.setPixelSize(650, 20);
                sp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                sp.setStyleName("newresultset-leftpanel-background");
                this.table.setWidget(this.n, 1, (Widget)sp);
                this.table.setCellPadding(2);
                result.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            if (i < results.size()) continue;
            this.controller.setPageDisplayer("displaying " + from + " - " + results.size());
            break;
        }
        this.controller.enableMovePageresults(false);
        this.controller.enableSavQueryButton(false);
        this.controller.getNewresultset().getLeftPanel().resizeBasket();
        if (from == 1 && !this.bottomPanelAdded) {
            this.addNextPreviousButtons();
            this.bottomPanelAdded = true;
        }
    }

    public void addNextPreviousButtons() {
        this.controller.addButtonsBottom(this.mainLayout);
    }

    public void clear() {
        this.n = 0;
        this.resultsPanel.clear();
        this.table.clear();
        this.resultsPanel.add((Widget)this.table);
    }

    public void showCollectionListbox(ListBox listbox) {
        HorizontalPanel collectionsPanel = new HorizontalPanel();
        collectionsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        HTML myText = new HTML("Results from:&nbsp;&nbsp; ");
        collectionsPanel.add((Widget)myText);
        collectionsPanel.add((Widget)listbox);
        this.lpanel.add((Widget)collectionsPanel);
    }

    static /* synthetic */ Controller access$000(RecordsPanel x0) {
        return x0.controller;
    }
}

