package org.gcube.portlets.user.results.client.dialogBox;

import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;
import org.gcube.portlets.user.results.client.model.MetadataDescriptor;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;


public class MetadataViewerPopup extends GCubeDialog {
	private  ScrollPanel scroller = new ScrollPanel();
	private VerticalPanel main_panel = null;
	public MetadataViewerPopup(MetadataDescriptor mdDesc, int width, int height) {
		setText("Schema: " + mdDesc.getFormat() + ", language: " + mdDesc.getLanguage());

	    main_panel = new VerticalPanel();
		//fetch the metadata
		setAnimationEnabled(true);
		setPixelSize(width, height);
		ScrollPanel scroller = new ScrollPanel();
		scroller.setPixelSize(width, height);
		
		HTML metadataXML = new HTML(mdDesc.getContentFormattedXML(), true);
		HTML metadataHTML = new HTML(mdDesc.getContentFormatted(), true);
		
		TabPanel tabPanel = new TabPanel();
		
		tabPanel.add(metadataHTML, "Formatted");
		tabPanel.add(metadataXML, "Formatted XML");
		tabPanel.selectTab(0);
		tabPanel.setSize("100%", "100%");
		
		scroller.add(tabPanel);
		
		scroller.setStyleName("padding");
		  // PopupPanel is a SimplePanel, so you have to set it's widget property to
	      // whatever you want its contents to be.
	      Button close = new Button("Close");
	      close.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				hide();		
			}    	  
	      });
	      main_panel.add(scroller);
	      main_panel.add(new HTML("<hr align=\"left\" size=\"1\" width=\"100%\" color=\"gray\" noshade>"));
	      HorizontalPanel hozPanel = new HorizontalPanel();
	      hozPanel.setSpacing(5);
	      hozPanel.add(close);
	      hozPanel.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
	      hozPanel.setWidth("100%");	      
	      main_panel.add(hozPanel);
	      scroller.setPixelSize(600, 400);
	      main_panel.setPixelSize(600, 450);
	      setWidget(main_panel);

			
	}

	
}

//public class MetadataViewerPopup  {
//}
