package org.gcube.portlets.user.results.server.servlet;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.results.client.components.TreeNode;
import org.gcube.portlets.user.results.client.constants.StringConstants;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketModelItemType;
import org.gcube.portlets.user.results.client.model.BasketSerializable;
import org.gcube.portlets.user.results.client.util.QueryDescriptor;
import org.gcube.portlets.user.results.client.util.QuerySearchType;


public class NewresultsetServiceUtil {
	private static GCUBELog _log = new GCUBELog(NewresultsetServiceImpl.class);
	/**
	 * Return a  List<BasketModelItem> given a basketid
	 * it uses the hobe library and store the read basket in the session
	 * 
	 */
	protected static List<BasketModelItem> getBasketContent(NewresultsetServiceImpl caller, String basketId) {


		Workspace root = null;
		try {
			root = caller.getWorkspaceArea();
		} catch (WorkspaceFolderNotFoundException e) {e.printStackTrace();
		} catch (InternalErrorException e) { e.printStackTrace();
		} catch (HomeNotFoundException e) {	e.printStackTrace();
		}

		WorkspaceItem item = null;
		try {
			item = root.getItem(basketId);
		} catch (ItemNotFoundException e) {
			e.printStackTrace();
		}
		_log.debug("Item Type: "+item.getType());
		if (item.getType() != WorkspaceItemType.FOLDER) { 
			_log.debug("The item id does not belong to a basket id:" + basketId);
			return new LinkedList<BasketModelItem>();
		}
		else {
			List<BasketModelItem> readBasket = NewresultsetServiceUtil.fillBasket((WorkspaceFolder) item);
			try {
				caller.storeBasketInSession(new BasketSerializable(basketId, item.getName(), item.getPath(), readBasket));
			} catch (InternalErrorException e) {
				e.printStackTrace();
			}
			_log.debug("Basket " + basketId + " stored in session");

			return readBasket;
		}				
	}
	/**
	 * fill the basket 
	 * @param basket
	 * @return
	 */
	
	//TODO: Change first paramter of constructor for BasketModelItem to URI instead if item.getId
	private static List<BasketModelItem> fillBasket(WorkspaceFolder basket) {		
		List<BasketModelItem> toReturn = new LinkedList<BasketModelItem>();
		try {
			for (WorkspaceItem item : basket.getChildren() ) {
				if (item.getType() == WorkspaceItemType.FOLDER) {
					//TODO handle
					toReturn.add( new BasketModelItem(item.getId(), item.getId(),"WORKSPACE",  item.getName(), item.getDescription(), "", BasketModelItemType.FOLDER, false) );
				}
				else if (item.getType() == WorkspaceItemType.SHARED_FOLDER || item.getType() == WorkspaceItemType.SMART_FOLDER) {
					//TODO handle
					toReturn.add( new BasketModelItem(item.getId(), item.getId(),"WORKSPACE",  item.getName(), item.getDescription(), "", BasketModelItemType.SHARED_FOLDER, false) );
				}
				else {
					//in an item
					FolderItem fi = (FolderItem) item;
					switch (fi.getFolderItemType()) {
					case EXTERNAL_FILE:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.EXTERNAL_FILE, false) );				
						break;
					case EXTERNAL_PDF_FILE:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.EXTERNAL_PDF_FILE, false) );
						break;
					case EXTERNAL_IMAGE:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.EXTERNAL_IMAGE, false) );
						break;
					case IMAGE_DOCUMENT:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.INFO_OBJECT, false) );
						break;
					case IMAGE_DOCUMENT_LINK:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.INFO_OBJECT_LINK, false) );
						break;
					case QUERY:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE",  item.getName(), item.getDescription(), "", BasketModelItemType.QUERY, false) );
						break;
					case REPORT:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(),"WORKSPACE",  item.getName(), item.getDescription(), "", BasketModelItemType.REPORT, false) );
						break;
					case REPORT_TEMPLATE:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(),"WORKSPACE",  item.getName(), item.getDescription(), "", BasketModelItemType.REPORT_TEMPLATE, false) );
						break;
					case TIME_SERIES:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(),"WORKSPACE",  item.getName(), item.getDescription(), "", BasketModelItemType.TIMESERIES, false) );
						break;
					default:
						toReturn.add( new BasketModelItem(item.getId(), item.getId(), "WORKSPACE", item.getName(), item.getDescription(), "", BasketModelItemType.INFO_OBJECT, false) );
						break;
					}
				}
			}

		} catch (InternalErrorException e) { e.printStackTrace(); }
		return toReturn;
	}

	/**
	 * Calls the home library to save the current basket in session permanently	 * 
	 *
	 */
	protected static boolean saveBasket(NewresultsetServiceImpl caller) {
		BasketSerializable toSave = caller.readBasketFromSession();
		List<BasketModelItem> items = toSave.getItems();

		//create an instance of the basket to be saved
		WorkspaceFolder basket = getBasketInstance(caller, toSave.getId());

		try {
			FolderBulkCreator bbc = basket.getNewFolderBulkCreator();
			_log.debug("********************************  BASKET CREATOR CALLED    items size: -> " + items.size());

			for (BasketModelItem item : items) {

				_log.trace("********************************  BASKET FOUND ITEM: Name    -> " + item.getName());
				_log.trace("********************************  				 : isNew()?-> " + item.isNew());
				_log.trace("********************************  				 : OID  ()?-> " + item.getOid());
				_log.trace("********************************  				 : URI  ()?-> " + item.getUri());


				if (item.isNew()) {
					item.setIsNew(false);

					switch (item.getItemType()) {
					case ALTERNATIVE:
						bbc.createDocumentAlternativeItem(URI.create(item.getUri()));
						break;
					case METADATA:
						bbc.createMetadata(URI.create(item.getUri()));
						break;
					case ANNOTATION:
						bbc.createAnnotation(URI.create(item.getUri()));
						break;	
					case PART:
						bbc.createDocumentPartItem(URI.create(item.getUri()));
						break;
					case GOOGLE:
						bbc.createExternalUrl(item.getOid());
						break;
					case OPENSEARCH:
						bbc.createExternalUrl(item.getOid());
						break;
					case QUERY:
						QueryType type = convertGWTquerytype(item.getSearchType());
						_log.debug("****************************************************  SAVING QUERY: TYPE->" + type);
						bbc.createQuery(item.getName(), item.getDescription(), type);

						break;
					default:
						bbc.createDocumentItem(URI.create(item.getUri()));	
						break;
					}			
				}
			} //end for
			//we persist changes
			bbc.commit();
		}
		catch (InsufficientPrivilegesException e) {	
			_log.debug(e.getMessage());
			return false;
		}
		catch (InternalErrorException e) { 
			_log.debug(e.getMessage());
			return false;
		}		
		return true;
	}


	private static QueryType convertGWTquerytype(QuerySearchType type) {
		switch (type) {
		case ADVANCED:
			return QueryType.ADVANCED_SEARCH;
		case GEO: 
			return QueryType.GEO_SEARCH;
		case GOOGLE:
			return QueryType.GEO_SEARCH;
		case SIMPLE:
			return QueryType.SIMPLE_SEARCH;	
		case QUICK:
			return QueryType.QUICK_SEARCH;
		default:
			return QueryType.QUICK_SEARCH;
		}
	}

	/**
	 * Return an instance of the Baslet given a basketid
	 * @param basketId
	 * @return
	 */
	public static WorkspaceFolder getBasketInstance(NewresultsetServiceImpl caller, String basketId) {
		Workspace root = null;
		try {
			root = caller.getWorkspaceArea();
		} catch (WorkspaceFolderNotFoundException e) {e.printStackTrace();
		} catch (InternalErrorException e) { e.printStackTrace();
		} catch (HomeNotFoundException e) {	e.printStackTrace();
		}

		WorkspaceItem item = null;
		try {
			item = root.getItem(basketId);
		} catch (ItemNotFoundException e) {
			e.printStackTrace();
		}
		_log.debug("Item Type: "+item.getType());
		if (item.getType() != WorkspaceItemType.FOLDER) { 
			_log.debug("The item id does not belong to a basket id:" + basketId);
			return null;
		}
		return (WorkspaceFolder) item;
	}

	/**
	 * 
	 * @param folder
	 * @return
	 * @throws InternalErrorException
	 */
	protected static TreeNode fillWorkspaceTree(WorkspaceFolder folder) throws InternalErrorException {
		List<TreeNode> children = new LinkedList<TreeNode>();

		TreeNode tmp = null;
		if (folder.getType() == WorkspaceItemType.FOLDER)
			tmp = new TreeNode(folder.getName(), folder.getId(), folder.getPath(), children,	StringConstants.TYPE_BASKET, folder.getParent()== null);
		else {
			tmp = new TreeNode(folder.getName(), folder.getId(), folder.getPath(), children,	StringConstants.TYPE_FOLDER, folder.getParent()== null);
		}


		for (WorkspaceItem child: folder.getChildren()) {
			if (child.getType() == WorkspaceItemType.FOLDER)
				children.add(fillWorkspaceTree((WorkspaceFolder) child));
		}
		return tmp;
	}


//	/**
//	 * 
//	 * @param session
//	 */
//	protected static void storeAnnMetadataCols(final String ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME, ASLSession session) {		
//		String xquery = 
//			"declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; " +
//			"for $mcoll in collection(\"/db/Profiles/MetadataCollection\")//Document/Data/is:Profile/Resource " +
//			" where $mcoll/Profile/RelatedCollection/SecondaryRole/string() eq 'is-annotated-by' " +
//			" return $mcoll/ID";
//		ISInfo is = new ISInfo(session);
//
//		List<XMLResult>result = is.queryIS(xquery);
//		String toEvaluate = "";
//
//		List<String> annColsIDs = new LinkedList<String>();
//		for (XMLResult res: result) {
//			try {
//				toEvaluate = res.evaluate("/ID/text()").get(0);
//				annColsIDs.add(toEvaluate);
//			} catch (ISResultEvaluationException e) {
//				e.printStackTrace();
//			}
//			_log.debug("Ann Metadata Col ID: " + toEvaluate);
//		}
//		session.setAttribute(ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME, annColsIDs);
//	}





	/**
	 * Constructs a String representation of the query given a QueryDescriptor
	 * @param qd the QueryDescriptor
	 * @return a String representation of the query
	 */
	protected static String getDisplayableQuery(QueryDescriptor qd) {
		String toReturn = "";
		switch (qd.getType()) {
		case BROWSE:
			return " BROWSE BY " + qd.getSortBy() + " IN " + qd.getSelectedCollections().get(0);
		case QUICK:
			return qd.getTerm();
		case SIMPLE:
			//[FARM_dc-en]France IN FARM FAO Country Maps (for Simple Search)
			toReturn = "[" + qd.getSchema() + "-" + qd.getLanguage() + "] " + " '" + qd.getTerm() + "' IN ";
			for (int i = 0; i < qd.getSelectedCollections().size(); i++) {
				toReturn += "'" + qd.getSelectedCollections().get(i) + "'";
				if (i != qd.getSelectedCollections().size()-1)
					toReturn += ", ";
			}			
			return toReturn;
		case ADVANCED:
			//[FARM_dc-en]title:France AND [FARM_dc-en]any:pollution IN FAO Country Maps
			toReturn = qd.getTerm() + " IN ";
			for (int i = 0; i < qd.getSelectedCollections().size(); i++) {
				toReturn += "'" + qd.getSelectedCollections().get(i) + "'";
				if (i != qd.getSelectedCollections().size()-1)
					toReturn += ", ";
			}			
			return toReturn;

		case GOOGLE:
			return "google search: " + qd.getTerm();
		case BROWSE_FIELDS:
			return "field Values of: " + qd.getSelectedCollections().get(0);
		case GENERIC:
			return qd.getTerm();
		default:
			return "";
		}
	}

}

