package org.gcube.portlets.user.results.client.util;

import java.util.HashMap;

import org.gcube.portlets.user.results.client.constants.StringConstants;
import org.gcube.portlets.user.results.client.control.Controller;
import org.gcube.portlets.user.results.client.dialogBox.ContentViewerPopup;
import org.gcube.portlets.user.results.client.model.ActionType;
import org.gcube.portlets.user.results.client.model.Client_DigiObjectInfo;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author Massimiliano Assante, ISTI-CNR assante@isti.cnr.it
 */
public class MyCommand implements Command {
	/**
	 * mode
	 */
	ActionType selectedOption;
	/**
	 * objectURI
	 */
	protected String objectURI;
	/**
	 * collectionId
	 */
	protected String collectionId;
	/**
	 * title
	 */
	protected String title;
	/**
	 * payload
	 */
	protected String payload;
	
	/**
	 * counter
	 */
	protected static int counter = 0;

	private Controller controller;

	private String username;

	protected String docURI;

	/**
	 * 
	 * @param selectedOption
	 * @param OID
	 * @param colId
	 * @param metadataCollectionId
	 * @param title
	 * @param username
	 */
	public MyCommand(Controller controller, ActionType selectedOption, String OID, String colId, String docURI, String title, String username)
	{
		this.controller = controller;
		this.selectedOption = selectedOption;
		this.objectURI = OID;
		this.collectionId = colId;
		this.title = title;
		//this.payload = payload;
		this.username = username;
		this.docURI = docURI;
	}

	/**
	 * Redirects the page to Content Viewer porltet page.
	 */
	public static void goToContentViewer(HashMap<String, String> links)
	{
		String extLink = links.get(StringConstants.CONTENT_VIEWER_KEY);
		String url = portalURL();
		url +=  "/../"+ extLink;
		Window.open(url, "_self", "");
	}

	public static native String portalURL()/*-{
	 return $wnd.location.href;
	 }-*/;

	/**
	 * @param txt the text the should exist in the &lt;a&gt;&lt;/a&gt; statement
	 * @param j j 
	 * 
	 * @return the coresponding URL (form href attribute of "a" element
	 */
	public static native String anchor(String txt, int j)/*-{
	 var x = $doc.getElementsByTagName("a");
	 for(i=0;i<x.length;i++)
	 {
	 if(x[i].innerHTML.toLowerCase().indexOf(txt,0) != -1)
	 {
	 	if(j==0)
	 		return x[i].href;
	 	else
	 		j--;
	 }
	 }
	 return "";
	 }-*/;


	/** (non-Javadoc)
	 * @see com.google.gwt.user.client.Command#execute()
	 */
	public void execute() {
		switch(selectedOption)
		{
		case VIEW_CONTENT:
			//View Content
			if(objectURI.startsWith("http") && objectURI.contains("/tree/")) {
				//Add a callback to retrieve the payload from ASL
				// TODO: add here the visualization depending on the result object's type. Type is missing and should be added to the returned result
				// For now display the generic visualizer independent of the type
				AsyncCallback<String> callback = new AsyncCallback<String>() {

					public void onFailure(Throwable caught) {
						Window.alert("Failed to retrieve the payload. Please try again");
					}

					public void onSuccess(String result) {
						if (result != null)
							new ContentViewerPopup(result, "xmlviewer", true);
						else
							Window.alert("Warning: Payload for this result is missing, nothing to show");
					}			
				};		
				controller.getNewresultset().getModel().getResultService().getObjectsPayload(objectURI, callback);
			}
			else if (objectURI.equals(""))
				Window.alert("Warning: Payload for this result is missing, nothing to show");
			
			else if (objectURI.startsWith("http"))
				//TODO Will this work??
				Window.open(objectURI, "name"+counter, "width="+ StringConstants.POPUP_WINDOW_WIDTH + ",height=" + StringConstants.POPUP_WINDOW_HEIGHT + " ,toolbar=no, location=no,status=no,menubar=no,scrollbars=yes,resizable=yes");
			else
				Window.alert("Could not found a suitable viewer for this type of object");
			counter++;
			break;
		case SAVE_CONTENT:
			if (objectURI.startsWith("http"))
				Window.open(objectURI, "name"+counter, "width="+ StringConstants.POPUP_WINDOW_WIDTH + ",height=" + StringConstants.POPUP_WINDOW_HEIGHT + " ,toolbar=true, location=yes,status=no,menubar=yes,scrollbars=yes,resizable=yes");
			else
				Window.open("/aslHttpContentAccess/ContentViewer?documentURI=" + docURI+ "&username=" + username + "&save=true", "_blank", "");
			break;
		default:
			Window.alert("No command was selected...");	
		}				
	}
}