package org.gcube.portlets.user.results.server.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObjectType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.SessionConstants;
import org.gcube.application.framework.search.library.impl.ResultSetConsumer;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.QueryGroup;
import org.gcube.application.framework.search.library.util.DisableButtons;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.gcube.application.framework.search.library.util.SearchType;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.results.client.ResultsetService;
import org.gcube.portlets.user.results.client.components.TreeNode;
import org.gcube.portlets.user.results.client.constants.StringConstants;
import org.gcube.portlets.user.results.client.model.BasketModelItem;
import org.gcube.portlets.user.results.client.model.BasketSerializable;
import org.gcube.portlets.user.results.client.model.Client_DigiObjectInfo;
import org.gcube.portlets.user.results.client.model.ResultNumber;
import org.gcube.portlets.user.results.client.model.ResultObj;
import org.gcube.portlets.user.results.client.model.ResultType;
import org.gcube.portlets.user.results.client.model.ResultsContainer;
import org.gcube.portlets.user.results.client.util.QueryDescriptor;
import org.gcube.portlets.user.results.client.util.QuerySearchType;
import org.gcube.portlets.user.results.server.servlet.NewresultsetServiceUtil;
import org.gcube.portlets.user.results.shared.ObjectType;
import org.gcube.portlets.user.results.shared.ResultRecord;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The <code> NewresultsetServiceImpl </code> Implementation of the services for the portlet 
 *
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @version May 2012 (2.0) 
 */
public class NewresultsetServiceImpl extends RemoteServiceServlet implements ResultsetService {

	/** Logger */
	private static Logger _log = Logger.getLogger(NewresultsetServiceImpl.class);

	public static final String WORKSPACE_AREA_ATTRIBUTE_NAME = "WORKSPACEAREA";
	public static final String CURRENT_OPEN_BASKET_ATTRIBUTE_NAME = "CURRENTBASKET";
	public static final String ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME = "SCOPED_ANNCOLS_IDS";
	public static final String CURRENT_QUERY = "CURRENTQUERY";
	public static final String CURRENT_RESULTS_NO = "CURRENT_RESULTS_NUMBER";

	private static final long serialVersionUID = -1619078127853728843L;

	public final static String RESULTS_PER_PAGE_ATTRIBUTE_NAME = "RESULTS_NUMBER_PER_PAGE";

	private static final int DEFAULTQNO = 0;

	/**
	 * used to avoid multiple IS request for the Storage EPR discovery, 
	 * if multiple request come  within 1 minute it uses the same EPR
	 */
	protected static Date lastCall;	
	/**
	 * used to avoid multiple IS request for the Storage EPR discovery, 
	 * if multiple request come  within 1 minute it uses the same EPR
	 */
	protected String SERVICE_URI = "";

	//protected ISClient client;

	/**
	 * 
	 *
	 */
	public void decreaseStartingPoint() {
		Integer tmp = retrieveStartingPoint();
		int resultsPerPage = readResultsPerPageFromSession();
		tmp = new Integer(tmp.intValue() - resultsPerPage);
		if (tmp.intValue() > 0)
			storeStartingPoint(tmp);
	}


	@SuppressWarnings("unchecked")
	//	protected List<String> getAnnMetadataCols() {
	//		ASLSession session = getASLSession();
	//		if (session.getAttribute(ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME) == null)
	//			return new LinkedList<String>();
	//		return (List) session.getAttribute(ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME);
	//	}	

	/**
	 * This method stores on the session some information that is needed from the Annotation portlets in order to operate
	 * @param CollectionId the ID of the collection that the digital object belongs to 
	 * @param oidForAnn the URI of the digital object
	 * @param TitleOfTheDocument the title of the digital object as it is defined on the metadata of this object
	 */
	//	public void getAnnotations(String collectionId, String oidForAnn, String titleOfTheDocument)
	//	{
	//		//first: invalidate the cache for this id if the user annotates the object
	//		boolean removed = removeFromCache(oidForAnn);
	//		_log.debug("Removing " + oidForAnn + " from cache? " +removed );
	//
	//		ASLSession session = getASLSession();
	//		sessionAnnRequirements sessionForAnn = new sessionAnnRequirements(collectionId, oidForAnn, titleOfTheDocument, null);
	//		/*
	//		List<CollectionInfo>[] collections = new SearchHelper(session).getAvailableCollections();
	//		FindInfo.findCollectionInfoFromMetadata(CollectionId, collections );
	//		 */
	//		session.setAttribute("sessionAnnRequirements",sessionForAnn);
	//	}

	/**
	 * This method stores on the session some information that is needed from the Content Viewer portlet in order to operate
	 * @param objectID the OID of the Object
	 */
	//	public void setContentViewerOID(String objectID) {
	//
	//		ASLSession session = getASLSession();
	//		session.setAttribute("cvp:objectID", objectID);
	//	}

	/**
	 * Return a  List<BasketModelItem> given a basketid
	 * it uses the hobe library and store the read basket in the session
	 * 
	 */
	public List<BasketModelItem> getBasketContent(String basketId) {
		getASLSession().setAttribute("WORKSPACE.LAST_OPEN_BASKET", basketId);
		return NewresultsetServiceUtil.getBasketContent(this, basketId);
	}
	/**
	 *
	 * If you have search for each collection, you request the available collection names 
	 * in order to present them in the drop down menu.
	 */
	public String[] getCollectionNames() {
		if (StringConstants.DEBUG) {
			String[] toReturn = {"FARM TIME SERIES", "FAO MAPS TRAPS"};
			return toReturn;
		}
		else {
			try {
				_log.debug("getCollectionNames()");
				ASLSession session = getASLSession();
				int id = ((Integer) session.getAttribute(SessionConstants.activePresentationQueryNo)).intValue();
				SearchHelper sh = new SearchHelper(session);
				QueryGroup queries = sh.getQuery(id);
				String[] collections = new String[queries.getQueries().size()];
				int qid = DEFAULTQNO;
				if(session.getAttribute("QeuryIndexToPresent") != null)
				{
					qid = Integer.parseInt(  session.getAttribute("QeuryIndexToPresent").toString());
				}
				System.out.println("internal query no:" + qid);
				if(collections.length < 2)
					return null;
				else {
					for(int i = 0; i< collections.length; i++)	{
						Query q = queries.getQuery(i);
						String colId = q.getSelectedRealCollections(session).get(0);
						if(qid == i)
							//This is the selected (colection) results to be presented
							collections[i] = "selected:" + FindFieldsInfo.findCollectionInfo(colId, sh.getAvailableCollections()).getName();
						else
							collections[i] = FindFieldsInfo.findCollectionInfo(colId, sh.getAvailableCollections()).getName();
					}
					for (String col : collections) {
						_log.debug("COL: "  + col);
					}
					//
					return collections;
				}
			} catch (Exception e) {
				return null;
			}
		}

	}

	/**
	 * the current D4SSession
	 * @return .
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);

		if (user == null) {
			_log.error("USER NULL" );
			user = "test.user";
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
			_log.debug("session ID= *" + sessionID + "*  USER= *" + user + "*" );
			//

			return session;
		}

		else {
			_log.debug("Session ID is:" + sessionID + "*  user= *" + user + "*" );
			return SessionManager.getInstance().getASLSession(sessionID, user);
		}
	}

	/**
	 * 
	 * @param querDescription the query description
	 */
	private void storeQueryInSession(QueryDescriptor querDescription) {
		ASLSession session = getASLSession();
		session.setAttribute(CURRENT_QUERY, querDescription);
	}

	/**
	 * 
	 * @param md_oid
	 * @param belongsTo
	 * @return
	 */
	//	public MetadataDescriptor getMetadataFormatAndLang(String md_oid,String belongsTo) {
	//		ASLSession session = getASLSession();
	//
	//		_log.trace("**** CHIAMO NUOVO PROTOCOL MANAGER: SMS://");
	//		System.setProperty("java.protocol.handler.pkgs", "org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol");
	//
	//		_log.debug("calling getMetadataFormatAndLang with oid: " + md_oid);
	//		_log.trace("**** BelongsTO: " + belongsTo);
	//		MetadataElements currMetadatas = cacheForGCubeDocuments.get(belongsTo).metadata();
	//		for (GCubeMetadata cubeMetadata : currMetadatas) {
	//			_log.trace("**** Iterating metadata... ");
	//			if (cubeMetadata.id().compareTo(md_oid) == 0) {
	//				String content = "";
	//				String formattedXML = "";
	//				try {
	//					//content = cubeMetadata.getContentAsString();
	//					content = new String(cubeMetadata.bytestream());
	//					MetadataConverter mdc = new MetadataConverter(this);
	//					mdc.setup(session);	
	//					String xslt = mdc.getDefaultXSLT();
	//					formattedXML = mdc.transform(content, xslt);
	//				} catch (IOException e) { e.printStackTrace();
	//				} catch (TransformerException e) {
	//					// TODO Auto-generated catch block
	//					e.printStackTrace();
	//				}
	//
	//
	//				//Logger.debug("********************* TRANSFORMED METADATA:\n" + formattedXML);
	//
	//				_log.debug("**** RETURN  MetadataDescriptor schema: " + cubeMetadata.schemaName() + " lang: " + cubeMetadata.language() );
	//				return new MetadataDescriptor(md_oid, cubeMetadata.schemaName(), cubeMetadata.language(), content, formattedXML);
	//			}
	//		}
	//		//return new MetadataDescriptor(md_oid, mdformat.getName(), mdformat.getLanguage(), formattedXML, html);
	//		_log.debug("Returning MetadataDescriptor null");
	//		return null;
	//	}


	/**
	 * 
	 * @param querDescription the query description
	 */
	public QueryDescriptor getQueryDescFromSession() {
		ASLSession session = getASLSession();
		if ( session.getAttribute(CURRENT_QUERY) == null)
			return new QueryDescriptor("NOQUERY", null , "", "", "", QuerySearchType.BROWSE, "");
		return (QueryDescriptor) session.getAttribute(CURRENT_QUERY);
	}


	/**
	 * reads from the file system and returns the user workspace as TreeNode object
	 * 
	 * returns the Default basket if if there is no basket in session, else the basket in session id
	 */
	public String getDefaultBasket() {
		_log.debug("getDefaultBasket()");
		if (readBasketFromSession() != null)
			return "-1";//readBasketFromSession().getId();
		else {
			try {
				Workspace workspaceArea = getWorkspaceArea();
				WorkspaceFolder basket = workspaceArea.getRoot();
				return basket.getId();
			} catch (MalformedScopeExpressionException e) {	e.printStackTrace();
			} catch (InternalErrorException e) {e.printStackTrace();
			} catch (HomeNotFoundException e) {	e.printStackTrace();
			} catch (WorkspaceFolderNotFoundException e) {e.printStackTrace();
			}
		}
		return "Could not open default basket";
	}

	/**
	 * used to get the additional info for the digital objects,
	 * @param currPosition in resultset
	 * object's mime type
	 * object's length (in bytes)
	 * amount of available annotations 
	 */
	@SuppressWarnings("unchecked")
	public Client_DigiObjectInfo getDigitalObjectInitialInfo(int currPosition) {

		//DigiObjectInfo toReturn = null;

		ASLSession session = getASLSession();
		//List<DigitalObject> digitalObjectsList = (List<DigitalObject>) session.getAttribute("ResultSet_LastResults");

		Vector<ResultObj> res = (Vector<ResultObj>) session.getAttribute(SessionConstants.theResultObjects);

		if(res == null)
			return null;

		int resultsPerPage = readResultsPerPageFromSession();
		int index = ((currPosition % resultsPerPage) == 0) ? resultsPerPage-1 : (currPosition % resultsPerPage) -1;
		ResultObj tmp = res.get(currPosition-1);
		String oURI = tmp.getObjectURI();
		String collectionID = tmp.getCollectionID();
		//what?
		if (oURI.equals("4a292210-5911-11df-9e97-d45b8b957c93")) {
			System.out.println("**********OID NON Existent replacing wih c1d768f0-bf21-11df-a146-e2fe98f43741" );
			oURI = "c1d768f0-bf21-11df-a146-e2fe98f43741";
		}

		//in case of google search we don't have to ask for the additional info to the storage.
		if (resultsFromGoogleSearch()) {
			_log.debug("in getDigitalObjectInitialInfo: Google search Results");
			return new Client_DigiObjectInfo(oURI, oURI, oURI, oURI, 000, "google/url");
		} 		
		else {
			//toReturn = new DigiObjectInfo(oid, oid, -1, null, collectionID,  null, null, null, null);

			if (tmp.getObjectURI().startsWith("http://") && tmp.getObjectURI().contains("/tree/"))
				return new Client_DigiObjectInfo(oURI, oURI, -1, "text/xml", collectionID);
			else if (tmp.getObjectURI().startsWith("http://"))
				return new Client_DigiObjectInfo(oURI, oURI, -1, "text/url", collectionID);
			else
				return new Client_DigiObjectInfo(oURI, oURI, -1, null, collectionID);
		}
	}


	/**
	 * return fakes digital object id just for testing
	 * @param oid
	 * @return
	 */
	//	private Client_DigiObjectInfo getFakeDigitalObject(String oid) throws RemoteException, IOException, FileNotFoundException {
	//		List<Client_StorageReference> matadatas = new LinkedList<Client_StorageReference>();
	//		List<Client_StorageReference> annotations = new LinkedList<Client_StorageReference>();
	//		List<Client_StorageReference> alternatives = new LinkedList<Client_StorageReference>();
	//		List<Client_StorageReference> parts = new LinkedList<Client_StorageReference>();
	//
	//		matadatas.add(new Client_StorageReference("meta-1", "belongsTo-", "", "", ""));
	//		matadatas.add(new Client_StorageReference("meta-2", "belongsTo-", "", "", ""));
	//		alternatives.add(new Client_StorageReference("alter-1", "belongsTo-", "", "", ""));
	//		alternatives.add(new Client_StorageReference("alter-2", "belongsTo-", "", "", ""));
	//		alternatives.add(new Client_StorageReference("alter-3", "belongsTo-", "", "", ""));
	//		parts.add(new Client_StorageReference("part-1", "belongsTo-", "", "", ""));
	//		parts.add(new Client_StorageReference("part2", "belongsTo-", "", "", ""));
	//
	//		return new Client_DigiObjectInfo(oid, "name", 111, "image/gif", "1234", matadatas, alternatives, parts, annotations);
	//	}


	/** 
	 * @return the first results
	 */
	private List<DigitalObject> getFirst(ResultSetConsumerI resConsumer) {
		DisableButtons dButtons = new DisableButtons();
		ASLSession session = getASLSession();
		storeStartingPoint(new Integer(1));
		int resultsPerPage = readResultsPerPageFromSession();
		/////////////////////////////////////////////////////////////////////

		////////////////////////////////////////////////////////////////////

		List<DigitalObject> rsb;
		try {
			rsb = resConsumer.getFirst(resultsPerPage, dButtons, session);
		} catch (Exception e) {
			_log.error("Failed to retrieve the search results.", e);
			throw new NullPointerException();

		}

		_log.debug("back = "+((retrieveStartingPoint() > resultsPerPage) ? "TRUE" : "FALSE"));
		_log.debug("forward = "+(!dButtons.getForward()?"TRUE":"FALSE"));

		session.setAttribute("back", (retrieveStartingPoint() > resultsPerPage) ? "TRUE" : "FALSE");
		session.setAttribute("forward", (!dButtons.getForward()?"TRUE":"FALSE"));
		return rsb;

	}

	/**
	 * @return the next RESULTS_NO_PER_PAGE results
	 */
	private List<DigitalObject> getNext(ResultSetConsumerI resConsumer) {
		DisableButtons dButtons = new DisableButtons();
		ASLSession session = getASLSession();
		int resultsPerPage = readResultsPerPageFromSession();
		List<DigitalObject> rsb;
		try {
			rsb = resConsumer.getNext(resultsPerPage, dButtons, session);
		} catch (Exception e) {
			rsb = new ArrayList<DigitalObject>();
			e.printStackTrace();
		}
		increaseStartingPoint();
		_log.debug("back = "+((retrieveStartingPoint() > resultsPerPage) ? "TRUE" : "FALSE"));
		_log.debug("forward = "+(!dButtons.getForward()?"TRUE":"FALSE"));
		session.setAttribute("back", (retrieveStartingPoint() > resultsPerPage) ? "TRUE" : "FALSE");
		session.setAttribute("forward", (!dButtons.getForward()?"TRUE":"FALSE"));

		String extraText = (resConsumer.getTotalRead()) ? "" : " and counting";
		session.setAttribute(NewresultsetServiceImpl.CURRENT_RESULTS_NO, new ResultNumber(true, resConsumer.getNumOfResultsRead(), extraText));
		return rsb;
	}
	/**
	 * @param sameResults (if true returns the same RESULTS_NO_PER_PAGE results)
	 * @return results
	 */
	private List<DigitalObject> getPrevious(ResultSetConsumerI resConsumer, boolean sameResults) {

		DisableButtons dButtons = new DisableButtons();
		ASLSession session = getASLSession();
		int resultsPerPage = readResultsPerPageFromSession();
		List<DigitalObject> rsb;
		try {
			rsb = resConsumer.getPrevious(resultsPerPage, dButtons, session);
		} catch (Exception e) {
			rsb = new ArrayList<DigitalObject>();
			e.printStackTrace();
		}
		decreaseStartingPoint();
		_log.debug("back = "+((retrieveStartingPoint() > resultsPerPage) ? "TRUE" : "FALSE"));
		_log.debug("forward = "+(!dButtons.getForward()?"TRUE":"FALSE"));
		session.setAttribute("back", (retrieveStartingPoint() > resultsPerPage) ? "TRUE" : "FALSE");
		session.setAttribute("forward", (!dButtons.getForward()?"TRUE":"FALSE"));

		return rsb;
	}




	/** 
	 * Queries the search service and get the results
	 * 
	 * @param mode if mode == 0 get the first record of the resultset, mode == 1 get the previous, mode = 2 get the next
	 * 
	 */
	@SuppressWarnings("unchecked")
	public ResultsContainer getResultFromSearchService(int mode) {
		_log.info("called getResultFromSearchService()...");
		QueryDescriptor queryToSave = null;
		if (StringConstants.DEBUG)
			return null;
		else {
			//Retrieving the active ResultSetConsumer based on search type, and query-group and query ids :-)
			ASLSession session = getASLSession();
			SearchHelper searchH = new SearchHelper(session);
			//if null noone has performed a search
			int qgid = ((Integer)session.getAttribute(SessionConstants.activePresentationQueryNo)).intValue();
			QueryGroup queries = searchH.getQuery(qgid);
			int qid = DEFAULTQNO;
			if(session.getAttribute("QeuryIndexToPresent") != null) {
				qid = Integer.parseInt(  session.getAttribute("QeuryIndexToPresent").toString());
			}
			Query q = queries.getQuery(qid);

			String term = "";
			term = q.getQueryDescription();

			//store the query in the session
			queryToSave = new QueryDescriptor(term);


			_log.debug("******************   STORING quer desc in the session:\n 	term = q.getTerm();" + term + " TYPE:" + getSearchQueryType(q)) ;
			if (queryToSave.getDescription() == null)
				queryToSave.setDescription("no description");
			storeQueryInSession(queryToSave);

			ResultSetConsumerI resConsumer;

			resConsumer = q.getSearchResults(session);
			_log.debug("user asked for search");


			//Retrieving the results (as Digital Objects).
			_log.debug("get Result was called and mode=" + mode);

			//ASL FAKE RESULTS	ResultSetConsumerI resConsumer = new ResultSetConsumer("", "advancedSearch");

			List<DigitalObject> digitalObjectsList = null;
			try {
				if(mode == 0)
					digitalObjectsList =  this.getFirst(resConsumer);
				else if(mode == 1)
					digitalObjectsList =  this.getPrevious(resConsumer, false);
				else if(mode == 2)
					digitalObjectsList = this.getNext(resConsumer);
				else
					digitalObjectsList = this.getFirst(resConsumer);
			}			
			catch (NullPointerException e ) {
				String[] options = new String[1];
				String exception = getASLSession().getAttribute(SessionConstants.searchException).toString();
				if (exception.contains("SocketTimeoutException"))
					exception = "The system is overloaded, please try again in few minutes";
				options[0] = exception;
				_log.error("RETURNING ERROR: for" + options[0]);
				return new ResultsContainer(null, options, ResultType.ERROR, new HashMap<String, String>());
			}
			//this session variable holds the last records to show
			session.setAttribute("ResultSet_LastResults", digitalObjectsList);

			//get the resultObjects from the session (if any)
			Vector<ResultObj> allResultsContainer = (Vector<ResultObj>) session.getAttribute("theResultObjects");

			//if they dont exist, instances itDigitalObject
			if(allResultsContainer == null)
				allResultsContainer = new Vector<ResultObj>();

			//adds the new results only when they need to be fetched from resultset consumer 
			if (allResultsContainer.size() < retrieveStartingPoint()) {
				for(DigitalObject dilObj: digitalObjectsList)	{
					/*
					 * ResultObj is gwt serializable, I return a Vector<ResultObj> constructed by using a DigitalObject list
					 */			
					ResultObj res = new ResultObj();
					res.setObjectURI(dilObj.getURI());
					//DigitalObjectType type = dilObj.getType();
					//if (type != null && type == DigitalObjectType.SPD)
					//	res.setObjectType(ObjectType.SPD);
					//else if (type!= null && type == DigitalObjectType.OAITMP)
					//res.setObjectType(ObjectType.OAI);
					//else
					//res.setObjectType(ObjectType.GENERIC);

					res.setTitle(dilObj.getTitle());

					//res.setPayload("");
					//					try {
					//						_log.debug("Trying to get the payload of the object with URI --> " + dilObj.getURI());
					//						String content = dilObj.getContent();
					//						_log.debug("Payload -------------------------------------->>>>>>>>>>>>>>>>>>\n" + content);
					//						res.setPayload(content);
					//					} catch (Exception e) {
					//						res.setPayload("");
					//					}
					res.setHtmlText(dilObj.getHTMLrepresentation());
					res.setCurrUserName(getASLSession().getUsername());
					res.setCollectionID(dilObj.getCollectionID());
					res.setCollectionName(dilObj.getCollectionName());

					_log.debug("Title" + res.getTitle() + " User " + res.getCurrUserName());

					//ResultRecord resultRec = new ResultRecord(dilObj.getObjectId(),dilObj.getTitle(), q.getSelectedSchema(), session.getScopeName(),"" , dilObj.getCollectionID(), res.getHtmlText(), "", dilObj.getRank());
					ResultRecord resultRec = new ResultRecord(dilObj.getObjectId(),dilObj.getTitle(), "dc", session.getScopeName(),"" , dilObj.getCollectionID(), res.getHtmlText(), "", dilObj.getRank());
					res.setResultRec(resultRec);

					allResultsContainer.add(res);
				}
			}

			/**
			 * no results were found
			 */
			_log.debug("Counting Results....");
			if (allResultsContainer.size() == 0) {
				String[] options = new String[1];
				options[0] = NewresultsetServiceUtil.getDisplayableQuery(queryToSave);
				_log.debug("***********************************************RETURNING Counting Results.... -> 0 " + options[0]);
				return new ResultsContainer(null, options, ResultType.NO_RESULTS, new HashMap<String, String>());
			}

			//			******			
			String[] options = new String[7];
			options[0] = "1";
			if (session.getAttribute(SessionConstants.startingPoint) != null) {
				options[0] = session.getAttribute(SessionConstants.startingPoint).toString();
			}
			options[1] = session.getAttribute("back").toString();
			options[2] = session.getAttribute("forward").toString();
			options[3] = ""+readResultsPerPageFromSession();
			options[4] = "";		

			//			write the resultObjects in the session
			session.setAttribute("theResultObjects", allResultsContainer);


			_log.debug("end of getResult(), starting point=" + options[0] + 
					" theResultObjects size in session: " + allResultsContainer.size());
			_log.debug("back: " + options[1]);
			_log.debug("next: " + options[2]);


			ResultSetConsumer actualConsumer = (ResultSetConsumer) resConsumer;

			//if is a browse field search i need to communicate the client to
			//treat these results differently, using another class to display then options[5] == 0 means that

			options[5] = "true"; //q.getSearchType().equals(SearchType.BrowseField ) ? "false" : "true";

			if (options[0].equals("1")) { //the is the first time, need to count the results
				startResultsCounter(queryToSave, actualConsumer, session, q);
				options[4] = " .. counting ";		
			}			
			options[6] = NewresultsetServiceUtil.getDisplayableQuery(queryToSave);
			String extraText = (resConsumer.getTotalRead()) ? "" : " and counting";
			session.setAttribute(NewresultsetServiceImpl.CURRENT_RESULTS_NO, new ResultNumber(true, resConsumer.getNumOfResultsRead(), extraText));

			//ResultsContainer toReturn = new ResultsContainer(allResultsContainer, options, ResultType.RESULTS, getExternalLinks());
			ResultsContainer toReturn = new ResultsContainer(allResultsContainer, options, ResultType.RESULTS, new HashMap<String, String>());
			return toReturn;

		}
	}

	public String getObjectsPayload(String objectURI) {
		try {
			_log.debug("Trying to get the payload of the object with URI --> " + objectURI);
			String content = DigitalObject.getContent(objectURI, getASLSession().getScopeName());
			_log.debug("Payload -------------------------------------->>>>>>>>>>>>>>>>>>\n" + content);
			return content;
		} catch (Exception e) {
			return null;
		}
	}


	/**
	 * 
	 * @param q
	 * @return
	 */
	private QuerySearchType getSearchQueryType(Query q) {
		return QuerySearchType.QUICK;
	}

	/**
	 * starts the thread for counting the results
	 * @param consumer
	 * @param session
	 */
	private void startResultsCounter(QueryDescriptor query, ResultSetConsumer consumer, ASLSession session, Query q) {
		boolean startThread = false;
		QueryDescriptor lastQuery = null;
		if (session.getAttribute("CURRQUERY") == null) {
			session.setAttribute("CURRQUERY", query);
			lastQuery = query;
			startThread = true;
			for (int i = 0; i < 10; i++) 
				_log.debug("--------------------------------------Query not in session start thread");
		}
		else { 
			try {
				lastQuery = (QueryDescriptor) session.getAttribute("CURRQUERY"); 
			}
			catch (Exception e) {
				lastQuery = new QueryDescriptor();
			}

			if (! lastQuery.getDescription().equals(query.getDescription())) {
				startThread = true;
				session.setAttribute("CURRQUERY", query);
				for (int i = 0; i < 10; i++) 
					_log.debug("-------------------------------------Query is NOT THE SAME starting thread thread");
			}
			else
				for (int i = 0; i < 10; i++) 
					_log.debug("-------------------------------------Query is THE SAME no thread");

			_log.debug("Query: \n" + lastQuery.getDescription() + "\nvs.\n" + query.getDescription());
		}
		if (startThread) {	


		}
	}

	/**
	 * reads the records from the session
	 * @return A <code>ResultsContainer</code> (Vector<ResultObj>, Optional paramters)  which contains all the information 
	 */
	@SuppressWarnings("unchecked")
	public ResultsContainer getResultsFromSession()
	{
		_log.debug("retrieveResults() ");

		ASLSession session = getASLSession();
		if ( session.getAttribute(SessionConstants.theResultObjects) == null)
			return null;

		Vector<ResultObj> res = (Vector<ResultObj>) session.getAttribute(SessionConstants.theResultObjects);


		String[] startingPoint = { "1" };
		if (session.getAttribute(SessionConstants.startingPoint) != null) {
			startingPoint[0] = (String) session.getAttribute(SessionConstants.startingPoint);
		}

		//ResultsContainer resContainer = new ResultsContainer(res, startingPoint, ResultType.RESULTS, getExternalLinks());
		ResultsContainer resContainer = new ResultsContainer(res, startingPoint, ResultType.RESULTS, null);
		return resContainer;
	}

	/**
	 * read the external links from the session, transform the ones that matches the properties file into the 
	 * actual links to use for redirecting 
	 * @return the HashMap containing the external links for the existent portlets
	 */
	@SuppressWarnings("unchecked")
	//	private HashMap<String, String> getExternalLinks() {
	//
	//		//get the portles to look for from the property file
	//		Properties props = new Properties();
	//		String annotation = "";
	//		String contentviewer = "";
	//		String ontology = "";
	//		try {
	//			URL resource = NewresultsetServiceImpl.class.getResource("/results_links.properties");
	//			//String propertyfile = this.getServletContext().getRealPath("")+"/config/results_links.properties";			
	//			File propsFile = new File(resource.getPath());
	//			FileInputStream fis = new FileInputStream(propsFile);
	//			props.load( fis);
	//			annotation = props.getProperty("annotation");
	//			contentviewer = props.getProperty("contentviewer");
	//			ontology = props.getProperty("ontology");
	//		}
	//		//catch exception in case properties file does not exist
	//		catch(IOException e) {
	//			e.printStackTrace();
	//		}
	//
	//		HashMap<String, String> toReturn = new HashMap<String, String>();
	//		try {
	//			ArrayList<String> toCheck = (ArrayList<String>) getASLSession().getAttribute("availablePortlets");
	//
	//			for (String item : toCheck) {
	//				if (item.compareTo(annotation) == 0)
	//					toReturn.put(StringConstants.ANNOTATION_LINK_KEY, annotation);
	//				else if (item.compareTo(contentviewer) == 0)
	//					toReturn.put(StringConstants.CONTENT_VIEWER_KEY, contentviewer);
	//				else if (item.compareTo(ontology) == 0)
	//					toReturn.put(StringConstants.ONTOLOGY_LINK_KEY, ontology);			
	//			}
	//		}//catch exception in case properties file does not exist
	//		catch(NullPointerException e) {
	//			_log.error("availablePortlets session var is null");
	//			return toReturn;
	//		}
	//
	//		return toReturn;
	//	}

	/**
	 * 
	 * @return an instance of the user WorkspaceArea
	 * @throws HomeNotFoundException 
	 * @throws InternalErrorException 
	 * @throws WorkspaceFolderNotFoundException 
	 * @throws WorkspaceNotFoundException
	 * @throws InternalErrorException
	 * @throws HomeNotFoundException
	 */
	protected Workspace getWorkspaceArea() throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException 	{
		return HomeLibrary.getUserWorkspace(getASLSession());	
	}


	/**
	 * reads from the file system and returns the user workspace as TreeNode object
	 */
	public TreeNode getWorkspaceTree() {
		WorkspaceFolder root = null;
		try {
			root = getWorkspaceArea().getRoot();

			return NewresultsetServiceUtil.fillWorkspaceTree(root);
		} catch (MalformedScopeExpressionException e) {	e.printStackTrace();
		} catch (InternalErrorException e) {e.printStackTrace();
		} catch (HomeNotFoundException e) {	e.printStackTrace();
		} catch (WorkspaceFolderNotFoundException e) {e.printStackTrace();

		}
		return null;
	}

	/**
	 * 
	 *
	 */
	public void increaseStartingPoint() {
		if (retrieveStartingPoint() == null)
			storeStartingPoint(new Integer(1));
		Integer tmp = retrieveStartingPoint();
		int resultsPerPage = readResultsPerPageFromSession();
		tmp = new Integer(tmp.intValue() + resultsPerPage);
		storeStartingPoint(tmp);
	}
	/**
	 * {@inheritDoc}
	 */
	public void init(){

		//		//_log.debug("Initializing ISClient client");
		//		try {
		//			//client = new ExistClient();
		//			//client = GHNContext.getImplementation(ISClient.class);
		//			//_log.debug("client =  new ExistClient(); --- OK");
		//		} catch (Exception e) {
		//			e.printStackTrace();
		//
		//		}
	}


	/**
	 * Check whether the porlet has been loaded after a search or not
	 * @return true if the user performed a search, false otherwise
	 */
	public boolean isSearchActive() {
		if (StringConstants.DEBUG)
			return true;
		else {
			//Retrieving the active ResultSetConsumer based on search type, and query-group and query ids :-)
			ASLSession session = getASLSession();

			if (getCollectionNames() == null) {
				_log.debug("getCollectionNames null");
			} else {
				String[] cols = getCollectionNames();
				for (int i = 0; i < cols.length; i++) 
					_log.debug(cols[i]);			
			}
			//NewresultsetServiceUtil.storeAnnMetadataCols(ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME, session);

			boolean active = (session.getAttribute(SessionConstants.activePresentationQueryNo) != null);
			_log.debug("isSearchActive() ? " + active);
			_log.debug("session.getAttribute(SessionConstants.activePresentationQueryNo= " + 
					session.getAttribute(SessionConstants.activePresentationQueryNo));
			return active;
		}		
	}
	/**
	 * Changes the internal query (in the query group) to be presented - based on collection name
	 * @param qid .
	 */
	public void loadResults(String qid) {
		//Changes the internal query (in the query group) to be presented - based on collection name
		ASLSession session = getASLSession();
		ResultSetConsumer.removeSessionVariables(session);
		session.setAttribute("QeuryIndexToPresent", qid);
		_log.debug("loadResults()");
	}

	/**
	 * need to get the saved elements from HL and the new elements from the session
	 * @param basket
	 */

	public BasketSerializable readBasketFromSession() {
		BasketSerializable toReturn = null;
		try {
			if (StringConstants.DEBUG) {
				List<BasketModelItem> children = new LinkedList<BasketModelItem>();
				toReturn = new BasketSerializable("0000", "nome", "path", children);
			}
			else {
				ASLSession session = getASLSession();
				toReturn = (BasketSerializable) session.getAttribute(CURRENT_OPEN_BASKET_ATTRIBUTE_NAME);
				if (toReturn != null) {
					String basketId = toReturn.getId();
					List<BasketModelItem> currItems = toReturn.getItems();
					List<BasketModelItem> savedItems = getBasketContent(basketId);

					for (BasketModelItem item : currItems) 	
						if (item.isNew()) {
							_log.debug("New Item: " + item.getName());
							savedItems.add(item);
						}

					toReturn.setItems(savedItems);
				}
			}
		} catch (ClassCastException e) {
			e.printStackTrace();
		}
		return toReturn; 
	}


	/**
	 * returns the number of results per page  read from the session for browsing
	 * @return
	 */
	private int readResultsPerPageFromSession() {
		ASLSession session = getASLSession();
		if (session.getAttribute(RESULTS_PER_PAGE_ATTRIBUTE_NAME) == null)
			return 10;
		else
			return ((Integer) session.getAttribute(RESULTS_PER_PAGE_ATTRIBUTE_NAME)).intValue();		
	}

	/**
	 * remove a single item in session
	 * @param item
	 * TODO: check if any error
	 */
	public Boolean removeBasketItemFromSession(BasketModelItem item) {
		BasketSerializable basket = readBasketFromSession();
		List<BasketModelItem> items = basket.getItems();
		if (items == null)
			return true;
		boolean removeResult = false;
		for (BasketModelItem itemToCheck : items) {
			if (itemToCheck.getOid().equals(item.getOid())) {
				items.remove(itemToCheck);
				removeResult = true;
				break;
			}				
		}
		storeBasketInSession(basket);
		_log.debug("Item Removed from session " + (item.getOid()));
		return new Boolean(removeResult);
	}

	/**
	 * 
	 * @return true if the last results were asked by google search
	 */
	private boolean resultsFromGoogleSearch() {
		ASLSession session = getASLSession();
		SearchHelper searchH = new SearchHelper(session);
		int qgid = ((Integer)session.getAttribute(SessionConstants.activePresentationQueryNo)).intValue();
		QueryGroup queries = searchH.getQuery(qgid);
		int qid = DEFAULTQNO;
		if(session.getAttribute("QeuryIndexToPresent") != null) {
			qid = Integer.parseInt(  session.getAttribute("QeuryIndexToPresent").toString());
		}
		Query q = queries.getQuery(qid);
		return (q.getSearchType().equalsIgnoreCase(SearchType.GoogleSearch));
	}


	/** 
	 * From where in the results to start presenting
	 */
	public Integer retrieveStartingPoint() {
		_log.debug("retrieveStartingPoint()");
		ASLSession session = getASLSession();
		if (session.getAttribute(SessionConstants.startingPoint) == null)
			return new Integer(1);
		return (Integer)session.getAttribute(SessionConstants.startingPoint);		
	}


	/**
	 * Calls the home library to save the current basket in session permanently	 * 
	 *
	 */
	public boolean saveBasket() {

		//
		if (StringConstants.DEBUG) {
			for (int i = 0; i < 15; i++) {
				File toMoveTo = new File("/tmp/output38127.html");
				String name = "pippotto"+i+".docx";
				if (i > 8)
					name = "pallino"+i+".html";
				String desc = name;
				String mimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
				saveInWorkSpace(name, desc, mimeType, toMoveTo);
			}
			return true;
		}
		else 
			return NewresultsetServiceUtil.saveBasket(this);
	}

	/**
	 * save the manifestation in default basket, overwrites if the file name exists already
	 * 
	 * @param name the name in the Workspace
	 * @param desc the desc 
	 * @param mimeType its mimetype
	 * @param payLoad a File instance 
	 */
	private boolean saveInWorkSpace(String name, String desc, String mimeType, File payLoad) {
		try {

			// Read the pdf input stream
			InputStream inputStream = new BufferedInputStream(new FileInputStream(payLoad));
			Workspace wp = getWorkspaceArea();
			WorkspaceFolder toSaveIn = wp.getRoot();

			if (toSaveIn.exists(name)) {
				_log.debug("Item exists already, deleting and creating new one");
				toSaveIn.removeChild(toSaveIn.find(name));
			}

			wp.createExternalFile(name, name, mimeType, inputStream, toSaveIn.getId());
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		} 

	}


	/**
	 * 
	 * @param basket
	 */
	protected void storeBasketInSession(BasketSerializable basket) {
		ASLSession session = getASLSession();
		session.setAttribute(CURRENT_OPEN_BASKET_ATTRIBUTE_NAME, basket);
	}

	/**
	 * add a single item in session
	 * @param item
	 * TODO: check if any error
	 */
	public Boolean storeBasketItemInSession(BasketModelItem item) {
		BasketSerializable basket = readBasketFromSession();

		List<BasketModelItem> items = basket.getItems();

		if (items == null)
			items = new LinkedList<BasketModelItem>();

		items.add(item);
		storeBasketInSession(basket);
		_log.debug("Item stored in session: NAME/URI" + item.getName()+"/"+item.getUri());
		_log.debug("Number of Items: " + items.size());
		return new Boolean(true);
	}


	/**
	 *  
	 * From where in the results to start presenting
	 */
	public void storeStartingPoint(Integer start)	{
		ASLSession session = getASLSession();
		session.setAttribute("startingPoint", start);		
	}

	/**
	 * @return a ResultNumber instance containing the num of results found so far
	 *  plus a boolean that say if is still counting or not
	 */
	public ResultNumber getResultsNo() {
		ASLSession session = getASLSession();

		if (session.getAttribute(NewresultsetServiceImpl.CURRENT_RESULTS_NO) == null)
			return new ResultNumber(false, 0, "");

		return (ResultNumber) session.getAttribute(NewresultsetServiceImpl.CURRENT_RESULTS_NO);
	}

	/**
	 * 
	 * @param queryTerm the query term to search
	 */
	public void submitSimpleQuery(String queryTerm) {
		ASLSession session = getASLSession();

		_log.debug("submitSimpleQuery aka browse: " + getQueryDescFromSession().getSortBy());

		SearchHelper shelper = new SearchHelper(session);
		QueryGroup queryGroup = shelper.getActiveQueryGroup();
		Query queryObj = queryGroup.getQuery(DEFAULTQNO);
		queryObj.setSortBy(getQueryDescFromSession().getSortBy());
		queryObj.setDistinct(false);
		_log.debug("\n**** setDistinct false ");
		session.setAttribute("browseFieldResult", new Boolean(true));
		session.setAttribute("sortByValue", queryTerm);
		session.setAttribute(SessionConstants.activePresentationQueryNo, new Integer(shelper.getActiveQueryGroupNo()));
		_log.debug("CALLING BROWSE, sortByValue:" + queryTerm);
		session.removeAttribute(RESULTS_PER_PAGE_ATTRIBUTE_NAME);

		try {
			queryObj.browse(session);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 

		int id = shelper.createQuery(shelper.getActiveQueryGroupNo());
		shelper.setActiveQueryGroup(id);

	}

	protected String getRealPath() {
		return this.getServletContext().getRealPath("");
	}

}
