package org.gcube.portlets.user.results.client.util;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * 
 * @author massi
 *
 */
public class QueryDescriptor implements IsSerializable{

	private String term;
	private List<String> selectedCollections;
	private String description;
	//private String expression; TODO:
	private String sortBy;
	private String schema;
	private String language;
	private QuerySearchType type;
	
	
	public QueryDescriptor() {}

	public QueryDescriptor(String qdesc) {
		term = qdesc;
		this.description = "";
		this.sortBy = "";
		this.language = "";
		this.schema = "";
		this.selectedCollections = null;

		this.type = QuerySearchType.QUICK;
		
	}


	public QueryDescriptor(String term, List<String> selectedCollections, String description, String schema, String language, QuerySearchType type, String sortBy) {
		super();
		this.description = description;
		this.sortBy = sortBy;
		this.language = language;
		this.schema = schema;
		this.selectedCollections = selectedCollections;
		this.term = term;
		this.type = type;
	}

////******** GETTERS n SETTERS
	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String getSortBy) {
		this.sortBy = getSortBy;
	}


	public String getLanguage() {
		return language;
	}



	public void setLanguage(String language) {
		this.language = language;
	}



	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public List<String> getSelectedCollections() {
		return selectedCollections;
	}
	public void setSelectedCollections(List<String> selectedCollections) {
		this.selectedCollections = selectedCollections;
	}
	public String getTerm() {
		return term;
	}
	public void setTerm(String term) {
		this.term = term;
	}



	public String getSchema() {
		return schema;
	}


	public void setSchema(String schema) {
		this.schema = schema;
	}


	public QuerySearchType getType() {
		return type;
	}



	public void setType(QuerySearchType type) {
		this.type = type;
	}	
	
}
