package org.gcube.portlets.user.results.client.dialogBox;

import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;

import com.google.gwt.user.client.ui.HTML;

public class ContentViewerPopup extends GCubeDialog {

	private String payload;
	private String divID;
	
	public ContentViewerPopup(String payload, String divID, boolean autoShow) {
		new ContentViewerPopup(payload, divID, -1, -1, autoShow);
	}
	
	
	public ContentViewerPopup(String payload, String divID, int width, int height, boolean autoShow) {
		this.payload = payload;
		this.divID = divID;
		HTML treePanel = new HTML("<div id=\"" + divID + "\" style=\"height: 450px; width: 600px\"></div>");	
		if (width != -1 && height != -1)
			this.setPixelSize(width, height);
		this.setText("Payload");
		this.setAutoHideEnabled(true);
		this.add(treePanel);
		if (autoShow) {
			this.show();
			showTree(this.divID, payload);
			this.center();
		}
	}
	
//	@Override
//	public void show() {
//		this.show();
//		showTree(divID, payload);
//	}
	
	public static native void showTree(String divid, String xml) 
	/*-{
		$wnd.showTree(divid, xml);
	}-*/;

}

