package org.gcube.portlets.admin.forwardindexportlet.gwt.server;

import gr.uoa.di.madgik.grs.buffer.IBuffer.Status;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.security.PortalSecurityManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.index.forwardindexnode.stubs.CreateResource;
import org.gcube.index.forwardindexnode.stubs.CreateResourceResponse;
import org.gcube.index.forwardindexnode.stubs.ForwardIndexNodeFactoryPortType;
import org.gcube.index.forwardindexnode.stubs.ForwardIndexNodePortType;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionArray;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionType;
import org.gcube.index.forwardindexnode.stubs.service.ForwardIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.forwardindexnode.stubs.service.ForwardIndexNodeServiceAddressingLocator;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService;
import org.gcube.portlets.admin.forwardindexportlet.gwt.server.util.GenericResourceManager;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.CollectionBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.FieldBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.ForwardIndexTypeBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.IndexBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.IndexKeyBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.IndexKeysBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.IndexTypeBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.MgmtPropertiesBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.RunningInstanceBean;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * A RemoteService implementation for the ManagementService following GWT RPC
 * design. Used in order to communicate with Management Resources and for
 * Management related queries towards DIS
 */
public class ManagementServiceImpl extends RemoteServiceServlet implements ManagementService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private static final long RSTIMEOUT = 10;
	private static final int NORESULTS = 25;

	/** Logger */
	private static Logger logger = Logger.getLogger(ManagementServiceImpl.class);

	private Map<String, GCUBEGenericResource> indexTypeResources;

	/** Class constructor */
	public ManagementServiceImpl() {
	}

	/**
	 * Returns a list of WSResource EPRs, given a list of resource property values and a namespace
	 * @param properties the RP values to search for
	 * @param namespace the namespace to search for
	 * @param scope the scope to search in
	 * @return the list of found WSResource EPRs
	 * @throws Exception
	 */
	private static List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
		String filter = "$result/child::*[local-name()='"+properties.get(0)[0].trim()+"' and namespace-uri(.)='"+namespace.trim()+"']/string() eq '"+properties.get(0)[1].trim()+"'";
		for (int i=1; i<properties.size(); i++)
			filter += " and $result/child::*[local-name()='"+properties.get(i)[0].trim()+"' and namespace-uri(.)='"+namespace.trim()+"']/string() eq '"+properties.get(i)[1].trim()+"'";

		ISClient client = GHNContext.getImplementation(ISClient.class);
		WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
		gquery.addGenericCondition(filter);

		List<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
		for(RPDocument d : client.execute(gquery, scope)){
			ret.add(d.getEndpoint());
		}
		return ret;
	}

	/**
	 * Returns the current GCUBE scope
	 * @return the scope
	 */
	private GCUBEScope getScope() {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
		return session.getScope();
	}

	private String getScopeName() {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
		return session.getScopeName();
	}

	/**
	 * Creates a stub proxy given a port-type object.
	 * @param <PORTTYPE> the type of the port-type stub
	 * @param portTypeStub the original port-type to generate a stub proxy for
	 * @return the stub proxy
	 * @throws Exception an error occured
	 */
	private <PORTTYPE extends Remote> PORTTYPE getStubProxy(PORTTYPE portTypeStub) throws Exception {
		/* Get the D4Science session object */
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);

		/* Create the security manager */
		GCUBESecurityManager secManager = new PortalSecurityManager(session.getScope());
		if(secManager.isSecurityEnabled())
		{
			try {
				secManager.useCredentials(session.getCredential());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		/* Get the stub proxy */
		try {
			return GCUBERemotePortTypeContext.getProxy(portTypeStub, session.getScope(), secManager);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService#getRunningInstances()
	 */
	public List<RunningInstanceBean> getRunningInstances() throws Exception {
		List<RunningInstanceBean> factoryEPRs = new LinkedList<RunningInstanceBean>();
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBEGenericQuery gquery = client.getQuery("RIEndpoint");
		gquery.addParameters(new QueryParameter("NAME", "ForwardIndexNode"),
				new QueryParameter("CLASS", "Index"),
				new QueryParameter("ENTRY", "gcube/index/ForwardIndexNodeFactory"));
		List<XMLResult> eprs = client.execute(gquery, getScope());			
		for(XMLResult r : eprs){
			for (String r1 : r.evaluate("//Endpoint/text()")) {
				RunningInstanceBean ribean = new RunningInstanceBean();
				ribean.setRunningInstanceEPR(r1);
				factoryEPRs.add(ribean);
			}
		}

		if (factoryEPRs.size() == 0) {
			throw new Exception("Unable to find any ForwardIndexNodeFactory service instances.");
		}

		return factoryEPRs;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @gwt.typeArgs <org.gcube.portlets.admin.forwardindexportlet.gwt.client.beans.CollectionsByNameBean>
	 */
	public List<CollectionBean> getCollections() throws Exception {
		System.out.println("-------->  getCollections() in " + getScope().toString());
		HashMap<String,CollectionBean> beanFromIDMap = new HashMap<String,CollectionBean>();
		String colID, colName;

		try {
			logger.debug("SCOPE " + getScope().getName() + " ( " + getScopeName() +")");
			List<DataCollection> collections = DataCollection.getCollectionsOfScope(true, getScopeName());
			logger.debug("Size of collections is " + collections.size());
			for (DataCollection c : collections) {
				colID = c.getID();
				colName = c.getName();

				logger.debug("Added collection -> " + colName + " (" + colID + ") to nameFromIDMap");
				CollectionBean collection = new CollectionBean();
				collection.setId(colID);
				collection.setName(colName);
				collection.setIsReal(true);
				beanFromIDMap.put(colID, collection);
			}

		} catch (ResourceRegistryException e) {
			logger.error("Failed to retrieve the content collections");
		}

		ISClient client = GHNContext.getImplementation(ISClient.class);

		CollectionBean fakeCollections = new CollectionBean();
		fakeCollections.setName("Empty Managers");

		List<RPDocument> indexData;
		try {
			WSResourceQuery wsquery = client.getQuery(WSResourceQuery.class);
			wsquery.addAtomicConditions(new AtomicCondition("//gc:ServiceName","ForwardIndexNode"));
			indexData = client.execute(wsquery, getScope());
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}


		String idxID;
		for (RPDocument d : indexData) {

			//TODO added here loop
			idxID = d.evaluate("//IndexID/text()").get(0);
			List<String> indexCollectionIDs = d.evaluate("//CollectionID/text()");
			if (indexCollectionIDs == null || indexCollectionIDs.isEmpty()) {
				IndexBean idx = new IndexBean();
				idx.setId(idxID);
				fakeCollections.addIndex(idx);
			}
			else {
				for (String idxColID : indexCollectionIDs ) {
					logger.debug("Found index resource for collection -> " + idxColID + " Going to check if it is real");
					CollectionBean collection = (CollectionBean) beanFromIDMap.get(idxColID);
					if (collection == null) {
						logger.debug("Found fake index with CollectionID=" + idxColID);
						//	collection = new CollectionBean();
						//	collection.setId(idxColID);
						//	collection.setIsReal(false);
						//	beanFromIDMap.put(idxColID, collection);
						//	fakeCollections.addCollection(collection);
					}
					else
						logger.debug("Found index for CollectionID=" + idxColID);

					if (idxID != null) {
						IndexBean idx = new IndexBean();
						idx.setId(idxID);
						collection.addIndex(idx);
					}
				}
			}
		}

		//add to return list and sort:
		ArrayList<CollectionBean> returnList = new ArrayList<CollectionBean>();
		returnList.addAll(beanFromIDMap.values());
		Collections.sort(returnList);

		returnList.add(fakeCollections);
		for(int i = 0; i < returnList.size(); i++ ){
			((CollectionBean)returnList.get(i)).sort();
		}

		logger.info("getCollections() -------->");
		return returnList;
	}

	/**
	 * {@inheritDoc}
	 */
	public IndexBean[] getIndices(String collectionID) throws Exception {
		logger.debug("Getting indices for the collection with ID -->> " + collectionID);
		List<String[]> props = new LinkedList<String[]>();
		String namespace = "http://gcube-system.org/namespaces/index/ForwardIndexNode/service";
		props.add(new String[] { "CollectionID", collectionID });
		List<EndpointReferenceType> eprs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

		String indexID = "";
		ForwardIndexNodePortType managementInstance = null;
		ForwardIndexNodeServiceAddressingLocator managementInstanceLocator = new ForwardIndexNodeServiceAddressingLocator();
		GetResourcePropertyResponse valueRP;

		IndexBean[] returnArray = new IndexBean[eprs.size()];
		for (int i = 0; i < eprs.size(); i++) {
			try {
				managementInstance = managementInstanceLocator.getForwardIndexNodePortTypePort(eprs.get(i));
				managementInstance = getStubProxy(managementInstance);
			} catch (Exception e) {
				e.printStackTrace();
			}
			valueRP = managementInstance.getResourceProperty(new QName(namespace, "IndexID"));
			indexID = valueRP.get_any()[0].getValue();

			QName resourceReference = new QName(namespace, "ForwardIndexNodeResourceReference");
			String epr = ObjectSerializer.toString(eprs.get(i), resourceReference);

			IndexBean indexBean = new IndexBean();
			indexBean.setId(indexID);
			indexBean.setName(indexID + "_name");
			indexBean.setHost(eprs.get(i).getAddress().getHost());
			indexBean.setEpr(epr);
			returnArray[i] = indexBean;

		}
		logger.debug("Returning the indices");
		return returnArray;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService#getAvailableIndexTypeIDs()
	 */
	public List<ForwardIndexTypeBean> getAvailableIndexTypeIDs() throws Exception {
		String condition = "contains($result/Profile/Name/string(), 'IndexType_fwd')";

		ISClient client =  GHNContext.getImplementation(ISClient.class);
		GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
		query.addParameters(new QueryParameter("FILTER", condition),
				new QueryParameter("TYPE", GCUBEGenericResource.TYPE),
				new QueryParameter("RESULT", "<Result>{$result/Profile/Name}</Result>"));

		List<XMLResult> result = client.execute(query, getScope());
		List<ForwardIndexTypeBean> ret = new LinkedList<ForwardIndexTypeBean>();

		for(XMLResult r : result){
			String indexTypeID = r.evaluate("//Name/text()").get(0);
			indexTypeID = indexTypeID.substring("IndexType_".length());
			ForwardIndexTypeBean ibean = new ForwardIndexTypeBean();
			ibean.setIndexTypeID(indexTypeID);
			ret.add(ibean);
		}
		return ret;
	}

	/**
	 * {@inheritDoc}
	 */
	public MgmtPropertiesBean getResourceProperties(String indexID) throws Exception {

		System.out.println("-------->   getResourceProperties");

		try {
			List<String[]> props = new LinkedList<String[]>();
			String namespace = "http://gcube-system.org/namespaces/index/ForwardIndexNode/service";
			props.add(new String[] { "IndexID", indexID });
			List<EndpointReferenceType> eprs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

			if (eprs.size() == 0) {
				throw new Exception("The index with the id [" + indexID + "] was not found in IS");
			}
			ForwardIndexNodePortType managementInstance = null;
			ForwardIndexNodeServiceAddressingLocator managementInstanceLocator = new ForwardIndexNodeServiceAddressingLocator();
			managementInstance = managementInstanceLocator.getForwardIndexNodePortTypePort(eprs.get(0));
			managementInstance = getStubProxy(managementInstance);

			QName RP_INDEX_KEYS = new QName(namespace, "KeyDescription");
			QName RP_CREATED = new QName(namespace, "Created");
			QName RP_MODIFIED = new QName(namespace, "Modified");

			QName[] qNames = { RP_INDEX_KEYS, RP_CREATED, RP_MODIFIED };

			GetMultipleResourcePropertiesResponse multipleRP = 
				managementInstance.getMultipleResourceProperties(new GetMultipleResourceProperties_Element(qNames));

			MgmtPropertiesBean properties = new MgmtPropertiesBean();

			Element tmp = null;
			IndexKeysBean indexKeys = new IndexKeysBean();
			int i=0;
			while (true) {
				tmp = multipleRP.get_any()[i].getAsDOM();
				if (!tmp.getLocalName().equals("KeyDescription"))
					break;
				indexKeys.addKey(new IndexKeyBean(
						tmp.getElementsByTagNameNS("*", "KeyName").item(0).getTextContent(),
						tmp.getElementsByTagNameNS("*", "IndexTypeID").item(0).getTextContent(),
						0
				));
				i++;
			}
			properties.setIndexKeys(indexKeys);
			//properties.setContentType(multipleRP.get_any()[i].getValue());
			properties.setCreated(multipleRP.get_any()[i].getValue());
			properties.setModified(multipleRP.get_any()[i+1].getValue());
			//properties.setStatus(multipleRP.get_any()[i+3].getValue());
			//properties.setDocumentCount(Integer.parseInt(multipleRP.get_any()[i+4].getValue()));
			properties.setHost(eprs.get(0).getAddress().getHost() + ":" + eprs.get(0).getAddress().getPort());

			System.out.println("getResourceProperties -------->");
			return properties;

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	private static String XMLDocToString(Node root) throws Exception {
		try {
			TransformerFactory tFactory = TransformerFactory.newInstance();
			Transformer transformer = tFactory.newTransformer();
			transformer.setOutputProperty("omit-xml-declaration", "yes");
			StringWriter sw = new StringWriter();
			StreamResult result = new StreamResult(sw);
			DOMSource source = new DOMSource(root);
			transformer.transform(source, result);
			return sw.getBuffer().toString();
		} catch (Exception e) {
			throw new Exception("Failed to transform DOM tree to string.", e);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public String createIndex(String indexID, String collectionID, String keyNames[], String indexTypeIDs[], String RIEPR) throws Exception {

		try {
		org.gcube.index.forwardindexnode.stubs.KeyDescriptionType[] desc = new KeyDescriptionType[keyNames.length];
		for(int i=0; i<keyNames.length; i++)
		{
			desc[i] = new org.gcube.index.forwardindexnode.stubs.KeyDescriptionType();
			desc[i].setKeyName(keyNames[i]);
			desc[i].setIndexTypeID(indexTypeIDs[i]);
		}

		CreateResource mgmtCreateArguments = new CreateResource();
		if (indexID != null && !indexID.trim().equals("")) {
			mgmtCreateArguments.setIndexID(indexID);
		}
		
		mgmtCreateArguments.setKeyDescription(new KeyDescriptionArray(desc));

		
			Address factoryAddress = new Address(RIEPR);
			System.out.println("Trying LookupFactory on host: "
					+ factoryAddress.getHost() + ", port: "
					+ factoryAddress.getPort());
			EndpointReferenceType mgmtFactoryEPR = new EndpointReferenceType();
			mgmtFactoryEPR.setAddress(factoryAddress);
			ForwardIndexNodeFactoryServiceAddressingLocator mgmtFactoryLocator = new ForwardIndexNodeFactoryServiceAddressingLocator();
			ForwardIndexNodeFactoryPortType mgmtFactory = mgmtFactoryLocator.getForwardIndexNodeFactoryPortTypePort(mgmtFactoryEPR);
			mgmtFactory = getStubProxy(mgmtFactory);
			CreateResourceResponse mgmtCreateResponse = mgmtFactory.createResource(mgmtCreateArguments);

			return mgmtCreateResponse.getIndexID();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public Integer removeIndex(String indexID) throws Exception {
		System.out.println("Destroying all ForwardIndexManagement resources with the ID: " + indexID);

		List<String[]> props = new LinkedList<String[]>();
		String namespace = "http://gcube-system.org/namespaces/index/ForwardIndexNode/service";
		props.add(new String[] { "IndexID", indexID });
		List<EndpointReferenceType> managementInstanceEPRs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());


		ForwardIndexNodePortType managementInstance = null;
		ForwardIndexNodeServiceAddressingLocator managementInstanceLocator = new ForwardIndexNodeServiceAddressingLocator();
		int counter = 0;
		for (int i = 0; i < managementInstanceEPRs.size(); i++) {
			EndpointReferenceType managementEPR = managementInstanceEPRs.get(i);
			try {
				managementInstance = managementInstanceLocator.getForwardIndexNodePortTypePort(managementEPR);
				managementInstance = getStubProxy(managementInstance);
				managementInstance.destroy(new Destroy());
				counter++;
			} catch (Exception e) {
				System.out.println("Problem deleting " + indexID + " ForwardIndexManagement resource.");
			}
		}
		if (counter == 0) {
			throw new Exception("No index removed. Wrong id?");
		}
		return counter;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService#getAllIndexTypes()
	 */
	public Map<String, IndexTypeBean> getAllIndexTypes() throws Exception {
		List<String[]> conditions = new LinkedList<String[]>();
		conditions.add(new String[] { "//SecondaryType", "ForwardIndexType" });
		Map<String, IndexTypeBean> retMap = new HashMap<String, IndexTypeBean>();
		indexTypeResources = new HashMap<String, GCUBEGenericResource>();
		for (GCUBEGenericResource gr : GenericResourceManager.retrieveGenericResource(conditions, getScope())) {
			indexTypeResources.put(gr.getID(), gr);
			retMap.put(gr.getID(), parseIndexType(gr));
		}
		return retMap;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService#saveIndexType(org.gcube.portlets.admin.forwardindexportlet.gwt.client.beans.IndexTypeBean)
	 */
	public String saveIndexType(IndexTypeBean idxType) throws Exception {
		String resourceID = idxType.getResourceID();
		GCUBEGenericResource gr = null;

		if (resourceID == null) {
			gr = GHNContext.getImplementation(GCUBEGenericResource.class);
			gr.setSecondaryType("ForwardIndexType");
			gr.setID("");
		}
		else {
			gr = indexTypeResources.get(resourceID);
		}

		gr.setName(idxType.getIndexTypeName());
		gr.setDescription(idxType.getIndexTypeDesc());
		gr.setBody(createIndexType(idxType.getIndexTypeFields()));

		resourceID = GenericResourceManager.updateGenericResource(gr, getScope());
		gr.setID(resourceID);
		indexTypeResources.put(resourceID, gr);

		return resourceID;
	}

	/**
	 * A method used parse an IndexType DOM document into FieldBeans
	 * 
	 * @param doc -
	 *            A DOM document representation of the IndexType
	 * @return - A list of all the fields of the IndexType in the form of
	 *         FieldBeans
	 */
	private IndexTypeBean parseIndexType(GCUBEGenericResource idxTypeResource) throws Exception {
		try {
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbFactory.newDocumentBuilder();
			Document idxTypeDoc = builder.parse(new InputSource(new StringReader(idxTypeResource.getBody())));
			XPath xpath = XPathFactory.newInstance().newXPath();
			Element elFieldList = (Element) xpath.evaluate("//field-list", idxTypeDoc.getDocumentElement(), XPathConstants.NODE);

			List<FieldBean> returnList = new LinkedList<FieldBean>();
			NodeList fieldList = elFieldList.getElementsByTagName("field");

			int fieldListLength = fieldList.getLength();

			for (int i = 0; i < fieldListLength; i++) {
				FieldBean fieldBean = new FieldBean();
				Node field = fieldList.item(i);
				NodeList fieldProperties = field.getChildNodes();
				String fieldName = field.getAttributes().getNamedItem("name").getNodeValue();
				//logger.debug("-----> " + fieldName);
				fieldBean.setName(fieldName);

				int propCount = fieldProperties.getLength();

				for (int j = 0; j<propCount; j++) {
					String propName = null;
					try {
						Node property = fieldProperties.item(j);

						if (property.getNodeType() == Node.ELEMENT_NODE) {
							Node textNode = property.getFirstChild();
							propName = property.getNodeName();

							if (propName.equalsIgnoreCase("index")) {
								fieldBean.setIndex("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("store")) {
								fieldBean.setStore("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("return")) {
								fieldBean.setReturned("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("tokenize")) {
								fieldBean.setTokenize("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("sort")) {
								fieldBean.setSort("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("boost")) {
								fieldBean.setBoost(textNode.getNodeValue());
							}
						}
					} catch (IllegalArgumentException e) {
					} // illegal property -- ignore
				}
				returnList.add(fieldBean);
			}

			IndexTypeBean itb = new IndexTypeBean();
			itb.setIndexTypeName(idxTypeResource.getName());
			itb.setIndexTypeDesc(idxTypeResource.getDescription());
			itb.setResourceID(idxTypeResource.getID());
			FieldBean[] fields = new FieldBean[returnList.size()];
			for (int i=0; i<returnList.size(); i++)
				fields[i] = returnList.get(i);
			itb.setIndexTypeFields(fields);
			return itb;
		} catch (Exception e) {
			logger.error("Failed to parse indexType from generic resource with name: " + idxTypeResource.getName(), e);
			throw new Exception("Failed to parse indexType from generic resource with name: " + idxTypeResource.getName(), e);
		}
	}

	/**
	 * Creates the XML string representation of an indexType, given the list
	 * of fields that the indexType contains.
	 * @param fields the list of indexType fields
	 * @return
	 */
	private String createIndexType(FieldBean[] fields) {
		StringBuilder indexType = new StringBuilder();
		indexType.append("<index-type name=\"default\"><field-list sort-xnear-stop-word-threshold=\"2E8\">");

		for (int i = 0; i < fields.length; i++) {
			FieldBean field = (FieldBean) fields[i];
			indexType.append("<field name=\"" + field.getName() + "\">");
			indexType.append("<index>" + (field.getIndex() ? "yes" : "no") + "</index>");
			indexType.append("<store>" + (field.getStore() ? "yes" : "no") + "</store>");
			indexType.append("<return>" + (field.getReturned() ? "yes" : "no") + "</return>");
			indexType.append("<tokenize>" + (field.getTokenize() ? "yes" : "no") + "</tokenize>");
			indexType.append("<sort>no</sort>");
			indexType.append("<boost>" + field.getBoost() + "</boost>");
			indexType.append("</field>");
		}
		indexType.append("</field-list></index-type>");

		return indexType.toString();
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService#deleteIndexType(org.gcube.portlets.admin.forwardindexportlet.gwt.client.beans.IndexTypeBean)
	 */
	public void deleteIndexType(IndexTypeBean idxType) throws Exception {
		String resourceID = idxType.getResourceID();
		GenericResourceManager.deleteGenericResource(resourceID, getScope());
		indexTypeResources.remove(resourceID);
	}

	 public String updateIndex(String indexID, String rsLocator) throws InvocationException {

			try {
				HttpSession httpSession = this.getThreadLocalRequest().getSession();
		        String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
				GCUBEScope scope = session.getScope();
				
				
	            // Find a suitable RI for creating an updater
	            CreateResourceResponse updaterCreateResponse = null;
	            
	            ISClient client = GHNContext.getImplementation(ISClient.class);
	            List<String> factoryEPRs = new LinkedList<String>();
	        	GCUBEGenericQuery gquery = client.getQuery("RIEndpoint");
	    		gquery.addParameters(new QueryParameter("NAME", "ForwardIndexNode"),
	    				new QueryParameter("CLASS", "Index"),
	    				new QueryParameter("ENTRY", "gcube/index/ForwardIndexNodeFactory"));
	    		List<XMLResult> eprs = client.execute(gquery, scope);			
	    		for(XMLResult r : eprs){
	    			for (String r1 : r.evaluate("//Endpoint/text()"))
	    				factoryEPRs.add(r1);
	    		}

	            if (factoryEPRs.size() == 0) {
	                Exception ie = new Exception("Unable to find a ForwardIndexNodeFactoryService in the VO.");
	                ie.printStackTrace();
	                throw ie;
	            }
	            
	            int i = 0;
	            while (true) {
	                try {
	                    Address factoryAddress = new Address(factoryEPRs.get(i));
	                    System.out.println("Trying UpdaterFactory on host: "
	                            + factoryAddress.getHost() + ", port: "
	                            + factoryAddress.getPort());
	                    EndpointReferenceType updaterFactoryEPR = new EndpointReferenceType();
	                    updaterFactoryEPR.setAddress(factoryAddress);
	                    ForwardIndexNodeFactoryServiceAddressingLocator updaterFactoryLocator = new ForwardIndexNodeFactoryServiceAddressingLocator();
	                    ForwardIndexNodeFactoryPortType updaterFactory = updaterFactoryLocator.getForwardIndexNodeFactoryPortTypePort(updaterFactoryEPR);
	                    updaterFactory = getStubProxy(updaterFactory);

	                    // Create updater resource and get endpoint reference of
	                    // WS-Resource:
	                    CreateResource updaterCreateArguments = new CreateResource();
	                    updaterCreateArguments.setIndexID(indexID);
	                    updaterCreateResponse = updaterFactory.createResource(updaterCreateArguments);
	                    break;
	                } catch (Exception e) {
	                    if (++i == factoryEPRs.size()) {
	                        throw e;
	                    }
	                    e.printStackTrace();
	                }
	            }

	            EndpointReferenceType updaterInstanceEPR = updaterCreateResponse.getEndpointReference();
	            ForwardIndexNodeServiceAddressingLocator updaterInstanceLocator = new ForwardIndexNodeServiceAddressingLocator();
	            ForwardIndexNodePortType updaterInstance = updaterInstanceLocator.getForwardIndexNodePortTypePort(updaterInstanceEPR);
	            updaterInstance = getStubProxy(updaterInstance);

	            // Start the update
	            updaterInstance.feedLocator(rsLocator);

	            QName resourceReference = new QName(
	                    "http://gcube-system.org/namespaces/index/ForwardIndexNode/service",
	                    "ForwardIndexNodeResourceReference");
	            String endpointString = ObjectSerializer.toString(updaterInstanceEPR, resourceReference);

	            return endpointString;
	        } catch (Exception e) {
	            e.printStackTrace();
	            throw new InvocationException("Unexpected server error.", e);
	        }
	    }
	 
	 public List<String> query(String queryString, String indexID) throws Exception {

	        System.out.println("-------->   query");

	        try {
	        	List<String[]> props = new LinkedList<String[]>();
	            String namespace = "http://gcube-system.org/namespaces/index/ForwardIndexNode/service";
	    		props.add(new String[] { "IndexID", indexID });
	            List<EndpointReferenceType> lookupInstanceEPRs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

	            if (lookupInstanceEPRs.size() == 0) {
	                throw new Exception("The lookup with the id [" + indexID + "] was not found on the IS");
	            }

	            ForwardIndexNodePortType lookupInstance = null;
	            ForwardIndexNodeServiceAddressingLocator lookupInstanceLocator = new ForwardIndexNodeServiceAddressingLocator();
	            lookupInstance = lookupInstanceLocator.getForwardIndexNodePortTypePort(lookupInstanceEPRs.get(0));
	            lookupInstance = getStubProxy(lookupInstance);
	                        
	            String rsEPR = lookupInstance.query(queryString);
	            return getListFromRS(rsEPR);

	        } catch (Exception e) {
	            e.printStackTrace();
	            throw e;
	        }
	    }
	 
	 /**
		 * A method used to harvest the first page of a ResultSet, and put xml
		 * representations all the results into a list of Strings
		 * 
		 * @param epr -
		 *            the epr of the ResultSet
		 * @return XML representation of each result in the first page in a list of
		 *         Strings
		 * @throws Exception -
		 *             When unable to read from the ResultSet
		 */
		private List<String> getListFromRS(String epr) throws Exception {

			ForwardReader<Record> reader = new ForwardReader<Record>(new URI(epr));
			Record result = null;

			ArrayList<String> returnList = new ArrayList<String>();

			int i = 0;
			while(i < NORESULTS) 
			{
				int counter = 0;
				int maxFail = 5;
				//read the next record
				while (true) {

					try {
						result = reader.get(RSTIMEOUT, TimeUnit.SECONDS);
						break;
					} catch (Exception e) {
						if (counter++ <= maxFail) {
							logger.error("getListFromRS failed for the "
									+ counter
									+ ". time.", e);
						} else {
							logger.error(" getListFromRS giving up. FAILED!",	e);
							throw e;
						}
					}
				}

				//if there is nothing else to read
				if(result == null && (reader.getStatus()==Status.Dispose || (reader.getStatus()==Status.Close && reader.availableRecords()==0))) 
				{
					break;
				}

				if(result != null) {
					StringBuilder builder =  new StringBuilder();
					builder.append("<record>");

					//read the fields
					Field[] fields = result.getFields();
					for(Field f : fields) {
						String fieldName = f.getFieldDefinition().getName();
						String fieldContent = ((StringField)f).getPayload();
						builder.append("<" + fieldName + ">" 
								+ fieldContent + "</" + fieldName + ">");
					}

					builder.append("</record>");

					returnList.add(builder.toString());

					i++;
				}
			}

			try{
				reader.close();
			} catch (Exception e) {
				logger.warn("could not close reader: ", e);
			}

			System.out.println("query    --------> ");
			return returnList;
		}
	
}
