package org.gcube.portlets.admin.forwardindexportlet.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * A class used to transport IndexManagement ResourceProperty information
 * between the client and the service
 */
public class MgmtPropertiesBean implements IsSerializable {

    /** The description of the keys of the IndexManagement */
  //  private IndexKeysBean indexKeys;

    /** The Content Type of the IndexManagement */
  //  private String contentType;

    /** The Creation Time of the IndexManagement */
    private String created;

    /** The Modified Time of the IndexManagement */
    private String modified;

    /** The Status property of the IndexManagement */
    private String status;

    /** The number of Updaters currently connected to the IndexManagement */
    private int updaterCount;

    /** The number of currently indexed documents */
    private int numDocs;
    
    /** The host of the index resource */
    private String host;
    
    private String clusterID;
    
    /** An empty constructor */
    public MgmtPropertiesBean() {
    }

    /**
     * Gets the Creation Time of the IndexManagement
     * 
     * @return the Creation Time of the IndexManagement
     */
    public String getCreated() {
        return created;
    }

    /**
     * Gets the Modified Time of the IndexManagement
     * 
     * @return the Modified Time of the IndexManagement
     */
    public String getModified() {
        return modified;
    }

    /**
     * Gets the Status property of the IndexManagement
     * 
     * @return the Status property of the IndexManagement
     */
    public String getStatus() {
        return status;
    }

    /**
     * Gets the number of Updaters currently connected to the IndexManagement
     * 
     * @return the number of Updaters currently connected to the IndexManagement
     */
    public int getUpdaterCount() {
        return updaterCount;
    }

    /**
     * Gets the number of currently indexed documents
     * @return the number of indexed documents
     */
    public int getDocumentCount() {
    	return numDocs;
    }
    
    /**
     * Gets the name of the host where the index resource resides
     * @return the host name
     */
    public String getHost() {
    	return host;
    }

    /**
     * Gets the Creation Time of the IndexManagement
     * 
     * @param created
     *            -Creation Time of the IndexManagement
     */
    public void setCreated(String created) {
        this.created = created;
    }

    /**
     * Gets the Modified Time of the IndexManagement
     * 
     * @param modified -
     *            the new Modified Time of the IndexManagement
     */
    public void setModified(String modified) {
        this.modified = modified;
    }

    /**
     * Gets the Status property of the IndexManagement
     * 
     * @param status -
     *            the new Status property of the IndexManagement
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Sets the number of Updaters currently connected to the IndexManagement
     * 
     * @param updaterCount
     *            -number of Updaters currently connected to the IndexManagement
     */
    public void setUpdaterCount(int updaterCount) {
        this.updaterCount = updaterCount;
    }
    
    /**
     * Sets the number of currently indexed documents
     * 
     * @param docCount the number of indexed documents
     */
    public void setDocumentCount(int docCount) {
    	this.numDocs = docCount;
    }
    
    /**
     * Sets the name of the host where the index resource resides
     * 
     * @param host the host name
     */
    public void setHost(String host) {
    	this.host = host;
    }

	public String getClusterID() {
		return clusterID;
	}

	public void setClusterID(String clusterID) {
		this.clusterID = clusterID;
	}
    
    
}
