package org.gcube.portlets.admin.forwardindexportlet.gwt.client.ui.indexmanagement.index;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ItemAddedListener;
import org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementService;
import org.gcube.portlets.admin.forwardindexportlet.gwt.client.interfaces.ManagementServiceAsync;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.ForwardIndexTypeBean;
import org.gcube.portlets.admin.forwardindexportlet.gwt.shared.RunningInstanceBean;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * A panel with the functionality and GUI components needed to add an Index to
 * the current collection, or to a new collection, fake, collection if non is
 * selected
 */
public class AddIndexPanel extends Composite implements ClickHandler {

	/** An GWT RPC interface to the ManagementService */
	private ManagementServiceAsync mgmtService = null;

	/** The outper panel holding all the widgets of the AddIndexPanel */
	private VerticalPanel outerPanel;

	/** A text box allowing the user to add the IndexID of the Index to be added */
	private TextBox indexIDBox;

	/**
	 * A text box allowing the user to add the CollectionID of the Index to be
	 * added. (if no collection has already been selected)
	 */
	//   private TextBox collectionIDBox;

	/**
	 * A label containing the CollectionID of the Index to be added. (if a
	 * collection has been selected)
	 */
	//   private Label collectionIDLabel;

	/**
	 * A text box allowing the user to add the ContentType of the Index to be
	 * added
	 */
	// private TextBox contentTypeBox;

	/**
	 * A table containing the description of the index keys (name + indexType)
	 */
	private FlexTable indexKeysTable;

	/**
	 * A listbox allowing the user to select the Running Instance to use for creating
	 * the new index
	 */
	private ListBox runningInstanceList;

	/** A button for the user to push in order to create the Index */
	private Button createButton;

	/** A Label informing the user that the Index was successfully added */
	private Label successLabel;

	/** A Label informing the user that there was an error adding Index */
	private Label errorLabel;

	/** A List of listeners needing information of added Indices */
	private ArrayList<ItemAddedListener> listeners = new ArrayList<ItemAddedListener>();

	/** An array containing all the available indexType IDs */
	private String[] availIndexTypeIDs;

	/** A constructor, initializing the panel */
	public AddIndexPanel() {
		outerPanel = new VerticalPanel();
		createButton = new Button("Create");
		createButton.addClickHandler(this);
		successLabel = new Label();
		errorLabel = new Label();
		indexIDBox = new TextBox();
		indexIDBox.setVisibleLength(30);
		//        collectionIDBox = new TextBox();
		//       collectionIDBox.setVisibleLength(30);
		//       collectionIDLabel = new Label();
		indexKeysTable = new FlexTable();
		indexKeysTable.setCellSpacing(0);
		indexKeysTable.setCellPadding(2);
		indexKeysTable.setStyleName("indexKeysTable");
		indexKeysTable.setWidget(0, 0, new Label("Key name"));
		indexKeysTable.setWidget(0, 1, new Label("Key indexType"));
		runningInstanceList = new ListBox();
		runningInstanceList.setVisibleItemCount(0);

		mgmtService = (ManagementServiceAsync) GWT.create(ManagementService.class);

		successLabel.setVisible(false);
		successLabel.addStyleName("diligent-success");
		errorLabel.setVisible(false);
		errorLabel.addStyleName("diligent-error");

		//5
		Grid grid = new Grid(3, 2);

		grid.setWidget(0, 0, new Label("IndexID (optional): "));
		grid.setWidget(0, 1, indexIDBox);

		//   HorizontalPanel hp = new HorizontalPanel();
		//   hp.add(collectionIDBox);
		//   hp.add(collectionIDLabel);
		//  grid.setWidget(1, 0, new Label("Collection ID: "));
		//   grid.setWidget(1, 1, hp);

		//grid.setWidget(1, 0, new Label("ContentType: "));
		//grid.setWidget(1, 1, contentTypeBox);

		Label lbl = new Label("Service Instance to use: ");
		lbl.setWordWrap(false);
		grid.setWidget(1, 0, lbl);
		grid.setWidget(1, 1, runningInstanceList);

		grid.setWidget(2, 0, new Label("Index keys: "));
		VerticalPanel vp = new VerticalPanel();
		vp.add(this.indexKeysTable);
		Button addFieldBtn = new Button("Add new key");
		addFieldBtn.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				addIndexKeyRow();
			}

		});
		vp.add(addFieldBtn);
		grid.setWidget(2, 1, vp);

		outerPanel.add(grid);
		outerPanel.add(createButton);
		outerPanel.add(successLabel);
		outerPanel.add(errorLabel);

		ServiceDefTarget endpoint = (ServiceDefTarget) mgmtService;
		String moduleRelativeURL = GWT.getModuleBaseURL() + "/MgmtService";
		endpoint.setServiceEntryPoint(moduleRelativeURL);

		/**
		 * The callback which will handle the result of the ManagementService
		 * call for retrieving the Index management running instances,
		 * in accordance with the GWT RPC framework
		 */
		AsyncCallback<List<RunningInstanceBean>> callback = new AsyncCallback<List<RunningInstanceBean>>() {
			/**
			 * {@inheritDoc}
			 */
			public void onSuccess(List<RunningInstanceBean> result) {
				createButton.setEnabled(true);
				errorLabel.setVisible(false);
				for (RunningInstanceBean ribean : result) {
					runningInstanceList.addItem(ribean.getRunningInstanceEPR());
				}
			}

			/**
			 * {@inheritDoc}
			 */
			public void onFailure(Throwable caught) {
				errorLabel.setText("Error: " + caught.getMessage());
				successLabel.setVisible(false);
				errorLabel.setVisible(true);
				createButton.setEnabled(false);
			}
		};
		mgmtService.getRunningInstances(callback);

		/**
		 * The callback which will handle the result of the ManagementService
		 * call for retrieving the available index type IDs,
		 * in accordance with the GWT RPC framework
		 */
		AsyncCallback<List<ForwardIndexTypeBean>> callback2 = new AsyncCallback<List<ForwardIndexTypeBean>>() {
			/**
			 * {@inheritDoc}
			 */
			public void onSuccess(List<ForwardIndexTypeBean> result) {
				createButton.setEnabled(true);
				errorLabel.setVisible(false);
				availIndexTypeIDs = new String[result.size()];
				int i=0;
				for (ForwardIndexTypeBean itbean : result) {
					availIndexTypeIDs[i] = itbean.getIndexTypeID();
					i++;
				}
				addIndexKeyRow();
			}

			/**
			 * {@inheritDoc}
			 */
			public void onFailure(Throwable caught) {
				errorLabel.setText("Error: " + caught.getMessage());
				successLabel.setVisible(false);
				errorLabel.setVisible(true);
				createButton.setEnabled(false);
			}
		};
		mgmtService.getAvailableIndexTypeIDs(callback2);


		initWidget(outerPanel);
	}

	/**
	 * A method which invokes the ManagementService asynchronously in order to
	 * create a new Index using the current values of the textBoxes.
	 * 
	 */
	private void create() {   
		/** The indexID to be used by the callback inner class */
		final String indexID = indexIDBox.getText();
		/** The RI EPR to be used */
		final String RIEPR = runningInstanceList.getItemText(runningInstanceList.getSelectedIndex());

		int numKeys = this.indexKeysTable.getRowCount() - 1;
		//TODO changed to 1 instead of 0
		if (numKeys == 0) {
			Window.alert("Please define some keys for the new index.");
			return;
		}
		String keyNames[] = new String[numKeys];
		String indexTypeIDs[] = new String[numKeys];
		for (int i=0; i<numKeys; i++) {
			keyNames[i] = ((TextBox) this.indexKeysTable.getWidget(i+1, 0)).getText();
			ListBox l = (ListBox) this.indexKeysTable.getWidget(i+1, 1);
			indexTypeIDs[i] = l.getItemText(l.getSelectedIndex());
		}

		/**
		 * The callback which will handle the result of the ManagementService
		 * call in accordance with the GWT RPC framework
		 */
		AsyncCallback<String> callback = new AsyncCallback<String>() {
			/**
			 * {@inheritDoc}
			 */
			public void onSuccess(String result) {
				IndexItemContent content = new IndexItemContent(null, result);
				successLabel.setText("Index was successfully created");
				successLabel.setVisible(true);
				createButton.setEnabled(true);
				errorLabel.setVisible(false);
				for (int i = 0; i < listeners.size(); i++) {
					((ItemAddedListener) listeners.get(i)).itemAdded(content);
				}
			}

			/**
			 * {@inheritDoc}
			 */
			public void onFailure(Throwable caught) {
				errorLabel.setText("Error: " + caught.getMessage());
				successLabel.setVisible(false);
				errorLabel.setVisible(true);
				createButton.setEnabled(true);
			}
		};
		mgmtService.createIndex(indexID, null, keyNames, indexTypeIDs, RIEPR, callback);
		createButton.setEnabled(false);
	}

	/**
	 * Updates the panels when a new collection has been selected, or a "New
	 * Fake Collection" has been requested.
	 * 
	 * @param collectionID -
	 *            the ID of the selected collection. NULL if none is selected.
	 */
	public void update(String collectionID) {
		indexIDBox.setText("");
		//      collectionIDBox.setText("");
		//   contentTypeBox.setText("gDocContent");
		successLabel.setVisible(false);
		errorLabel.setVisible(false);
		createButton.setEnabled(true);
		/*  if (collectionID == null) {
            collectionIDLabel.setVisible(false);
            collectionIDBox.setVisible(true);
        } else {
            collectionIDBox.setVisible(false);
            collectionIDLabel.setText(collectionID);
            collectionIDLabel.setVisible(true);
        }*/
	}

	private void addIndexKeyRow() {
		int z = this.indexKeysTable.getRowCount();// + 1;

		/* Add "key name" box */
		TextBox tbKeyName = new TextBox();
		tbKeyName.setText("");
		this.indexKeysTable.setWidget(z, 0, tbKeyName);

		ListBox indexTypeIDList = new ListBox();
		indexTypeIDList.setVisibleItemCount(0);
		for (String idxType : availIndexTypeIDs)
			indexTypeIDList.addItem(idxType);
		this.indexKeysTable.setWidget(z, 1, indexTypeIDList);

		/* Add "delete key name" button */
		final HTML deleteField = new HTML("<div rowNum=\"" + z + "\" class=\"diligent-indexTypeField-delete\"> </div>");
		deleteField.addClickHandler(new ClickHandler() {
			/* (non-Javadoc)
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(ClickEvent event) {
				int rowNum = Integer.valueOf(deleteField.getElement().getElementsByTagName("div").getItem(0).getAttribute("rowNum"));
				indexKeysTable.removeRow(rowNum);
				for (int j=rowNum; j<indexKeysTable.getRowCount(); j++)
					indexKeysTable.getWidget(j, 2).getElement().getElementsByTagName("div").getItem(0).setAttribute("rowNum", String.valueOf(j));
			}
		});
		this.indexKeysTable.setWidget(z, 2, deleteField);
	}

	/**
	 * A method to add a listener needing information of added Indices to the
	 * list of listeners.
	 * 
	 * @param listener -
	 *            the listener to be added
	 */
	public void addItemAddedListener(ItemAddedListener listener) {
		listeners.add(listener);
	}

	public void onClick(ClickEvent event) {
		create();
	}
}
