/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.fulltextindexportlet.gwt.server.util;

import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class GenericResourceManager {
    private static Logger logger = Logger.getLogger(GenericResourceManager.class);

    public static List<GenericResource> retrieveGenericResource(List<String> conditions, String scope) throws Exception {
        try {
            XQuery query = ICFactory.queryFor(GenericResource.class);
            for (String cond : conditions) {
                query.addCondition(cond);
            }
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List result = client.submit((Query)query);
            if (result == null || result.size() == 0) {
                throw new Exception("No generic resources found for the given conditions.");
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve generic resources.", (Throwable)e);
            throw new Exception("Failed to retrieve generic resources.", e);
        }
    }

    public static String updateGenericResource(GenericResource resource, String scope) throws Exception {
        ScopeProvider.instance.set(scope);
        RegistryPublisher publisher = RegistryPublisherFactory.create();
        GenericResource updatedResource = (GenericResource)publisher.update((Resource)resource);
        return updatedResource.id();
    }

    public static void deleteGenericResource(GenericResource resource, String scope) throws Exception {
        ScopeProvider.instance.set(scope);
        RegistryPublisher publisher = RegistryPublisherFactory.create();
        publisher.remove((Resource)resource);
    }
}

