/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.fulltextindexportlet.gwt.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.fulltextindexnode.client.library.beans.Types;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeCLProxyI;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeDSL;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeFactoryCLProxyI;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeFactoryDSL;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.server.util.GenericResourceManager;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.server.util.XMLUtils;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.CollectionBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FieldBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FullTextIndexTypeBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexTypeBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.MgmtPropertiesBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.RunningInstanceBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ManagementServiceImpl
extends RemoteServiceServlet
implements ManagementService {
    private static final long serialVersionUID = 2262958144498861061L;
    private static final long RSTIMEOUT = 10L;
    private static final int NORESULTS = 25;
    private static Logger logger = Logger.getLogger(ManagementServiceImpl.class);
    private Map<String, GenericResource> indexTypeResources;

    public ManagementServiceImpl() {
        try {
            ResourceRegistry.startBridging();
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Error starting rr bridging", (Throwable)e);
        }
    }

    private String getScope() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session.getScope();
    }

    public List<RunningInstanceBean> getRunningInstances() {
        ScopeProvider.instance.set(this.getScope());
        ArrayList<RunningInstanceBean> factoryEPRs = new ArrayList<RunningInstanceBean>();
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Index'").addCondition("$resource/Profile/ServiceName/text() eq 'FullTextIndexNode'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List resources = client.submit((Query)query);
        for (GCoreEndpoint ge : resources) {
            String endpoint = ((GCoreEndpoint.Profile.Endpoint)ge.profile().endpointMap().get("gcube/index/FullTextIndexNodeFactory")).uri().toString();
            RunningInstanceBean ribean = new RunningInstanceBean();
            ribean.setRunningInstanceEPR(endpoint);
            factoryEPRs.add(ribean);
        }
        return factoryEPRs;
    }

    public List<String> query(String queryString, String indexID) {
        logger.debug((Object)"-------->   query");
        logger.debug((Object)("Quering using --> indexID and term : " + indexID + " -- " + queryString));
        try {
            ScopeProvider.instance.set(this.getScope());
            StatefulQuery q = FullTextIndexNodeDSL.getSource().withIndexID(indexID).build();
            List refs = q.fire();
            FullTextIndexNodeCLProxyI proxyRandom = (FullTextIndexNodeCLProxyI)FullTextIndexNodeDSL.getFullTextIndexNodeProxyBuilder().at((W3CEndpointReference)refs.get(0)).build();
            String rsEPR = proxyRandom.query(queryString);
            logger.info((Object)("FT index Query RSepr -> " + rsEPR));
            return this.getListFromRS(rsEPR);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while quering index", (Throwable)e);
            return null;
        }
    }

    public List<CollectionBean> getCollections() {
        logger.debug((Object)("--------> START of getCollections() in " + this.getScope()));
        HashMap<String, CollectionBean> beanFromIDMap = new HashMap<String, CollectionBean>();
        try {
            logger.debug((Object)("SCOPE " + this.getScope()));
            List collections = DataCollection.getCollectionsOfScope((boolean)true, (String)this.getScope());
            logger.debug((Object)("Size of collections is " + collections.size()));
            for (DataCollection c : collections) {
                String colID = c.getID();
                String colName = c.getName();
                logger.debug((Object)("Added collection -> " + colName + " (" + colID + ") to nameFromIDMap"));
                CollectionBean collection = new CollectionBean();
                collection.setId(colID);
                collection.setName(colName);
                collection.setIsReal(true);
                beanFromIDMap.put(colID, collection);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to retrieve the collections", (Throwable)e);
            e.printStackTrace();
        }
        CollectionBean fakeCollections = new CollectionBean();
        fakeCollections.setName("Empty Managers");
        XQuery query = ICFactory.queryFor(ServiceInstance.class);
        query.addCondition("$resource/Data/gcube:ServiceName/text() eq 'FullTextIndexNode'");
        DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
        List resources = client.submit((Query)query);
        XPath xpath = XPathFactory.newInstance().newXPath();
        String idxID = null;
        for (ServiceInstance w : resources) {
            try {
                NodeList list;
                Element wsResourceCustomProperties = w.properties().customProperties();
                String indexID = (String)xpath.evaluate("/doc/*[local-name()='IndexID']/text()", wsResourceCustomProperties, XPathConstants.STRING);
                if (indexID != null) {
                    idxID = indexID;
                    logger.debug((Object)("Index ID --> " + idxID));
                }
                if ((list = (NodeList)xpath.evaluate("/doc/*[local-name()='CollectionID']/text()", wsResourceCustomProperties, XPathConstants.NODESET)) != null && list.getLength() > 0) {
                    for (int i = 0; i < list.getLength(); ++i) {
                        String collectionID = XMLUtils.createStringFromDomTree((Node)list.item(i));
                        logger.debug((Object)("Fond index resource for collection -> " + collectionID + " Going to check if it is real"));
                        CollectionBean collection = (CollectionBean)beanFromIDMap.get(collectionID);
                        if (collection == null) {
                            logger.debug((Object)("Found fake index with CollectionID = " + collectionID));
                            continue;
                        }
                        logger.debug((Object)("Found index for CollectionID = " + collectionID));
                        if (idxID == null) continue;
                        IndexBean idx = new IndexBean();
                        idx.setId(idxID);
                        collection.addIndex(idx);
                    }
                    continue;
                }
                IndexBean idx = new IndexBean();
                idx.setId(idxID);
                fakeCollections.addIndex(idx);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while parsing the values of the index resources", (Throwable)e);
            }
        }
        ArrayList<CollectionBean> returnList = new ArrayList<CollectionBean>();
        returnList.addAll(beanFromIDMap.values());
        Collections.sort(returnList);
        returnList.add(fakeCollections);
        for (int i = 0; i < returnList.size(); ++i) {
            ((CollectionBean)returnList.get(i)).sort();
        }
        logger.debug((Object)"END of getCollections() -------->");
        return returnList;
    }

    public IndexBean[] getIndices(String collectionID) {
        ScopeProvider.instance.set(this.getScope());
        XQuery query = ICFactory.queryFor(ServiceInstance.class);
        query.addNamespace("ns1", URI.create("http://gcube-system.org/namespaces/index/FullTextIndexNode/service")).addCondition("$resource/Data/gcube:ServiceName/text() eq 'FullTextIndexNode'").addCondition("$resource/Data/ns1:CollectionID/text() eq '" + collectionID + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
        List resources = client.submit((Query)query);
        XPath xpath = XPathFactory.newInstance().newXPath();
        String indexID = "";
        IndexBean[] returnArray = new IndexBean[resources.size()];
        int i = 0;
        for (ServiceInstance w : resources) {
            try {
                Element wsResourceCustomProperties = w.properties().customProperties();
                indexID = (String)xpath.evaluate("/doc/*[local-name()='IndexID']/text()", wsResourceCustomProperties, XPathConstants.STRING);
                if (indexID != null) {
                    logger.debug((Object)("Index ID --> " + indexID));
                }
                IndexBean indexBean = new IndexBean();
                indexBean.setId(indexID);
                indexBean.setName(indexID + "_name");
                indexBean.setHost(w.endpoint().getHost());
                indexBean.setEpr(w.endpoint().toString());
                returnArray[i] = indexBean;
            }
            catch (XPathExpressionException e) {
                logger.error((Object)"Exception while parsing the values of the index resources", (Throwable)e);
            }
            ++i;
        }
        return returnArray;
    }

    public List<FullTextIndexTypeBean> getAvailableIndexTypeIDs() {
        ScopeProvider.instance.set(this.getScope());
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("contains($resource/Profile/Name/string(), 'IndexType_ft')").setResult("$resource/Profile/Name/text()");
        DiscoveryClient client = ICFactory.client();
        List names = client.submit((Query)query);
        LinkedList<FullTextIndexTypeBean> ret = new LinkedList<FullTextIndexTypeBean>();
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                String indexTypeID = name.substring("IndexType_".length());
                FullTextIndexTypeBean ibean = new FullTextIndexTypeBean();
                ibean.setIndexTypeID(indexTypeID);
                ret.add(ibean);
            }
        }
        return ret;
    }

    public String getIndexTypeID(String indexID) {
        logger.debug((Object)"-------->   getIndexTypeID");
        ScopeProvider.instance.set(this.getScope());
        try {
            StatefulQuery q = FullTextIndexNodeDSL.getSource().withIndexID(indexID).build();
            List refs = q.fire();
            FullTextIndexNodeCLProxyI proxyRandom = (FullTextIndexNodeCLProxyI)FullTextIndexNodeDSL.getFullTextIndexNodeProxyBuilder().at((W3CEndpointReference)refs.get(0)).build();
            Types.GetIndexInformationResponse indexInformation = proxyRandom.getIndexInformation();
            String idxType = indexInformation.IndexID;
            logger.debug((Object)"getIndexTypeID -------->");
            return idxType;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to get the indexTypeID", (Throwable)e);
            return null;
        }
    }

    public MgmtPropertiesBean getResourceProperties(String indexID) {
        logger.debug((Object)"-------->   getResourceProperties");
        ScopeProvider.instance.set(this.getScope());
        try {
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            query.addNamespace("ns1", URI.create("http://gcube-system.org/namespaces/index/FullTextIndexNode/service")).addCondition("$resource/Data/gcube:ServiceName/text() eq 'FullTextIndexNode'").addCondition("$resource/Data/ns1:IndexID/text() eq '" + indexID + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
            List resources = client.submit((Query)query);
            if (resources.size() == 0) {
                throw new Exception("The index with the id [" + indexID + "] was not found in IS");
            }
            ServiceInstance se = (ServiceInstance)resources.get(0);
            Element wsResourceCustomProperties = se.properties().customProperties();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String host = se.endpoint().getHost();
            String port = new Integer(se.endpoint().getPort()).toString();
            String lastModified = (String)xpath.evaluate("/doc/*[local-name()='Modified']/text()", wsResourceCustomProperties, XPathConstants.STRING);
            String created = (String)xpath.evaluate("/doc/*[local-name()='Created']/text()", wsResourceCustomProperties, XPathConstants.STRING);
            String clusterID = (String)xpath.evaluate("/doc/*[local-name()='ClusterID']/text()", wsResourceCustomProperties, XPathConstants.STRING);
            MgmtPropertiesBean properties = new MgmtPropertiesBean();
            properties.setCreated(created);
            properties.setModified(lastModified);
            properties.setClusterID(clusterID);
            properties.setHost(host + ":" + port);
            logger.debug((Object)"getResourceProperties -------->");
            return properties;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while trying to read the index resource properties", (Throwable)e);
            return null;
        }
    }

    public String createIndex(String clusterID, String collectionID, String RIEPR) {
        ScopeProvider.instance.set(this.getScope());
        try {
            FullTextIndexNodeFactoryCLProxyI proxyRandomf = (FullTextIndexNodeFactoryCLProxyI)FullTextIndexNodeFactoryDSL.getFullTextIndexNodeFactoryProxyBuilder().at(new URI(RIEPR)).build();
            Types.CreateResource createResource = new Types.CreateResource();
            if (clusterID != null && !clusterID.trim().equals("")) {
                createResource.ClusterID = clusterID;
            }
            Types.CreateResourceResponse output = proxyRandomf.createResource(createResource);
            return output.IndexID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean removeIndex(String indexID, String collectionID) {
        logger.debug((Object)("Destroying all FullTextIndexManagement resources with the ID: " + indexID + " for the collection with ID --> " + collectionID));
        ScopeProvider.instance.set(this.getScope());
        boolean toReturn = true;
        XQuery query = ICFactory.queryFor(ServiceInstance.class);
        query.addNamespace("ns1", URI.create("http://gcube-system.org/namespaces/index/FullTextIndexNode/service")).addCondition("$resource/Data/gcube:ServiceName/text() eq 'FullTextIndexNode'");
        if (collectionID != null) {
            query.addCondition("$resource/Data/ns1:CollectionID/text() eq '" + collectionID + "'");
        }
        if (indexID != null) {
            query.addCondition("$resource/Data/ns1:IndexID/text() eq '" + indexID + "'");
        }
        DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
        List resources = client.submit((Query)query);
        for (ServiceInstance se : resources) {
            try {
                FullTextIndexNodeCLProxyI proxyRandom = (FullTextIndexNodeCLProxyI)FullTextIndexNodeDSL.getFullTextIndexNodeProxyBuilder().at((W3CEndpointReference)se.reference()).build();
                if (collectionID != null) {
                    boolean isDeleted = proxyRandom.deleteCollection(collectionID);
                    if (isDeleted) continue;
                    toReturn = isDeleted;
                    continue;
                }
                toReturn = proxyRandom.destroyNode();
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Exception while trying to remove the index resource for the selected collection", (Throwable)e);
                toReturn = false;
            }
            catch (FullTextIndexNodeException e) {
                logger.error((Object)"Exception while trying to remove the index resource for the selected collection", (Throwable)e);
                toReturn = false;
            }
        }
        return toReturn;
    }

    public Map<String, IndexTypeBean> getAllIndexTypes() {
        ScopeProvider.instance.set(this.getScope());
        LinkedList<String> conditions = new LinkedList<String>();
        conditions.add("$resource/Profile/SecondaryType/text() eq 'FullTextIndexType'");
        HashMap<String, IndexTypeBean> retMap = new HashMap<String, IndexTypeBean>();
        this.indexTypeResources = new HashMap();
        try {
            for (GenericResource gr : GenericResourceManager.retrieveGenericResource(conditions, (String)this.getScope())) {
                this.indexTypeResources.put(gr.id(), gr);
                retMap.put(gr.id(), this.parseIndexType(gr));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the indexTypes of the Index generic resources. An exception was thrown", (Throwable)e);
        }
        return retMap;
    }

    public String saveIndexType(IndexTypeBean idxType) {
        ScopeProvider.instance.set(this.getScope());
        String resourceID = idxType.getResourceID();
        LinkedList<String> conditions = new LinkedList<String>();
        conditions.add("$resource/ID eq '" + resourceID + "'");
        try {
            List resources = GenericResourceManager.retrieveGenericResource(conditions, (String)this.getScope());
            if (resources != null && !resources.isEmpty()) {
                GenericResource gr = (GenericResource)resources.get(0);
                gr.profile().name(idxType.getIndexTypeName());
                gr.profile().description(idxType.getIndexTypeDesc());
                gr.profile().newBody(this.createIndexType(idxType.getIndexTypeFields()));
                resourceID = GenericResourceManager.updateGenericResource((GenericResource)gr, (String)this.getScope());
                this.indexTypeResources.put(resourceID, gr);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to update the generic resource with ID --> " + resourceID));
        }
        return resourceID;
    }

    private IndexTypeBean parseIndexType(GenericResource idxTypeResource) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document idxTypeDoc = builder.parse(new InputSource(new StringReader(idxTypeResource.profile().bodyAsString())));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element elFieldList = (Element)xpath.evaluate("//field-list", idxTypeDoc.getDocumentElement(), XPathConstants.NODE);
            LinkedList<FieldBean> returnList = new LinkedList<FieldBean>();
            NodeList fieldList = elFieldList.getElementsByTagName("field");
            int fieldListLength = fieldList.getLength();
            for (int i = 0; i < fieldListLength; ++i) {
                FieldBean fieldBean = new FieldBean();
                Node field = fieldList.item(i);
                NodeList fieldProperties = field.getChildNodes();
                String fieldName = field.getAttributes().getNamedItem("name").getNodeValue();
                fieldBean.setName(fieldName);
                int propCount = fieldProperties.getLength();
                for (int j = 0; j < propCount; ++j) {
                    String propName = null;
                    try {
                        Node property = fieldProperties.item(j);
                        if (property.getNodeType() != 1) continue;
                        Node textNode = property.getFirstChild();
                        propName = property.getNodeName();
                        if (propName.equalsIgnoreCase("index")) {
                            fieldBean.setIndex("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            continue;
                        }
                        if (propName.equalsIgnoreCase("store")) {
                            fieldBean.setStore("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            continue;
                        }
                        if (propName.equalsIgnoreCase("return")) {
                            fieldBean.setReturned("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            continue;
                        }
                        if (propName.equalsIgnoreCase("tokenize")) {
                            fieldBean.setTokenize("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            continue;
                        }
                        if (propName.equalsIgnoreCase("sort")) {
                            fieldBean.setSort("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            continue;
                        }
                        if (!propName.equalsIgnoreCase("boost")) continue;
                        fieldBean.setBoost(textNode.getNodeValue());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                returnList.add(fieldBean);
            }
            IndexTypeBean itb = new IndexTypeBean();
            itb.setIndexTypeName(idxTypeResource.profile().name());
            itb.setIndexTypeDesc(idxTypeResource.profile().description());
            itb.setResourceID(idxTypeResource.id());
            FieldBean[] fields = new FieldBean[returnList.size()];
            for (int i = 0; i < returnList.size(); ++i) {
                fields[i] = (FieldBean)returnList.get(i);
            }
            itb.setIndexTypeFields(fields);
            return itb;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to parse indexType from generic resource with name: " + idxTypeResource.profile().name()), (Throwable)e);
            return null;
        }
    }

    private String createIndexType(FieldBean[] fields) {
        StringBuilder indexType = new StringBuilder();
        indexType.append("<index-type name=\"default\"><field-list sort-xnear-stop-word-threshold=\"2E8\">");
        for (int i = 0; i < fields.length; ++i) {
            FieldBean field = fields[i];
            indexType.append("<field name=\"" + field.getName() + "\">");
            indexType.append("<index>" + (field.getIndex() ? "yes" : "no") + "</index>");
            indexType.append("<store>" + (field.getStore() ? "yes" : "no") + "</store>");
            indexType.append("<return>" + (field.getReturned() ? "yes" : "no") + "</return>");
            indexType.append("<tokenize>" + (field.getTokenize() ? "yes" : "no") + "</tokenize>");
            indexType.append("<sort>no</sort>");
            indexType.append("<boost>" + field.getBoost() + "</boost>");
            indexType.append("</field>");
        }
        indexType.append("</field-list></index-type>");
        return indexType.toString();
    }

    public void deleteIndexType(IndexTypeBean idxType) {
        String resourceID = idxType.getResourceID();
        LinkedList<String> conditions = new LinkedList<String>();
        conditions.add("$resource/ID eq '" + resourceID + "'");
        try {
            List resources = GenericResourceManager.retrieveGenericResource(conditions, (String)this.getScope());
            if (resources != null && !resources.isEmpty()) {
                GenericResource gr = (GenericResource)resources.get(0);
                GenericResourceManager.deleteGenericResource((GenericResource)gr, (String)this.getScope());
                this.indexTypeResources.remove(resourceID);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to delete the index generic resource");
        }
    }

    private List<String> getListFromRS(String epr) throws Exception {
        ForwardReader reader = new ForwardReader(new URI(epr));
        Record result = null;
        ArrayList<String> returnList = new ArrayList<String>();
        int i = 0;
        while (i < 25) {
            Field[] fields;
            int counter = 0;
            int maxFail = 5;
            while (true) {
                try {
                    result = reader.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (counter++ <= maxFail) {
                        logger.error((Object)("getListFromRS failed for the " + counter + ". time."), (Throwable)e);
                        continue;
                    }
                    logger.error((Object)" getListFromRS giving up. FAILED!", (Throwable)e);
                    throw e;
                }
                break;
            }
            if (result == null && (reader.getStatus() == IBuffer.Status.Dispose || reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0)) break;
            if (result == null) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("<record>");
            for (Field f : fields = result.getFields()) {
                String fieldName = f.getFieldDefinition().getName();
                String fieldContent = ((StringField)f).getPayload();
                builder.append("<" + fieldName + ">" + fieldContent + "</" + fieldName + ">");
            }
            builder.append("</record>");
            returnList.add(builder.toString());
            ++i;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            logger.warn((Object)"could not close reader: ", (Throwable)e);
        }
        System.out.println("query    --------> ");
        return returnList;
    }

    public String updateIndex(String indexID, String rsLocator) {
        ScopeProvider.instance.set(this.getScope());
        StatefulQuery q = FullTextIndexNodeDSL.getSource().withIndexID(indexID).build();
        List refs = q.fire();
        if (refs.size() <= 0) {
            logger.debug((Object)"Could not find an index resource with the given index ID");
        } else {
            try {
                FullTextIndexNodeCLProxyI proxyRandom = (FullTextIndexNodeCLProxyI)FullTextIndexNodeDSL.getFullTextIndexNodeProxyBuilder().at((W3CEndpointReference)refs.get(0)).build();
                proxyRandom.feedLocator(rsLocator);
                return ((EndpointReference)refs.get(0)).toString();
            }
            catch (FullTextIndexNodeException e) {
                logger.debug((Object)"Got an exception from index cliend while trying to feed the index", (Throwable)e);
            }
        }
        return null;
    }
}

