/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.fulltextindexportlet.gwt.client.ui.intextypemanagement;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.client.FTIndexManagementPortlet;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.client.ui.intextypemanagement.IndexTypeEditorPanel;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FieldBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexTypeBean;

public class IndexTypeEditorPanel
extends Composite {
    private ListBox indexTypesList;
    private int selectedIdxType = -1;
    private Button refreshIdxTypesBtn;
    private Button addIdxTypeBtn;
    private Button copyIdxTypeBtn;
    private Button deleteIdxTypeBtn;
    private TextBox idxTypeNameBox;
    private TextBox idxTypeDescBox;
    private Widget idxTypeDetailsPanel;
    private FlexTable indexTypeTable;
    private Label successLabel;
    private Label errorLabel;
    private Map<String, IndexTypeBean> idxTypeResources = null;
    private Button saveIdxTypeButton;

    public IndexTypeEditorPanel() {
        Grid hp = new Grid(1, 3);
        hp.setWidget(0, 0, this.createIndexTypeListPanel());
        hp.getCellFormatter().setWidth(0, 0, "50px");
        hp.setWidget(0, 1, (Widget)new HTML("<div style=\"width: 2px; height: 400px; border-right: 1px solid rgb(250,250,250); border-left: 1px solid rgb(100,100,100);\"> </div>"));
        hp.getCellFormatter().setWidth(0, 1, "2px");
        this.idxTypeDetailsPanel = this.createIndexTypeDetailsPanel();
        hp.setWidget(0, 2, this.idxTypeDetailsPanel);
        hp.setCellPadding(10);
        this.initWidget((Widget)hp);
        this.populateIndexTypeList();
        this.idxTypeListSelectionChange();
    }

    private void populateIndexTypeList() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        FTIndexManagementPortlet.mgmtService.getAllIndexTypes((AsyncCallback)callback);
    }

    private void idxTypeListSelectionChange() {
        if (this.selectedIdxType == -1) {
            this.deleteIdxTypeBtn.setEnabled(false);
            this.copyIdxTypeBtn.setEnabled(false);
            this.idxTypeDetailsPanel.setVisible(false);
        } else {
            this.deleteIdxTypeBtn.setEnabled(true);
            this.copyIdxTypeBtn.setEnabled(true);
            IndexTypeBean selectedIndexType = (IndexTypeBean)this.idxTypeResources.get(this.indexTypesList.getValue(this.selectedIdxType));
            this.updateIndexTypeDetails(selectedIndexType);
            this.idxTypeDetailsPanel.setVisible(true);
        }
    }

    private Widget createIndexTypeListPanel() {
        VerticalPanel idxTypesListPanel = new VerticalPanel();
        idxTypesListPanel.add((Widget)new Label("Available indexTypes:"));
        this.indexTypesList = new ListBox();
        this.indexTypesList.setVisibleItemCount(15);
        this.indexTypesList.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.indexTypesList.setWidth("200px");
        idxTypesListPanel.add((Widget)this.indexTypesList);
        this.refreshIdxTypesBtn = new Button("Refresh List", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshIdxTypesBtn.setWidth("200px");
        idxTypesListPanel.add((Widget)this.refreshIdxTypesBtn);
        this.addIdxTypeBtn = new Button("New indexType", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addIdxTypeBtn.setWidth("200px");
        idxTypesListPanel.add((Widget)this.addIdxTypeBtn);
        this.deleteIdxTypeBtn = new Button("Delete indexType", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteIdxTypeBtn.setWidth("200px");
        idxTypesListPanel.add((Widget)this.deleteIdxTypeBtn);
        this.copyIdxTypeBtn = new Button("Copy indexType", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.copyIdxTypeBtn.setWidth("200px");
        idxTypesListPanel.add((Widget)this.copyIdxTypeBtn);
        return idxTypesListPanel;
    }

    private Widget createIndexTypeDetailsPanel() {
        VerticalPanel idxDetailsPanel = new VerticalPanel();
        idxDetailsPanel.setWidth("100%");
        Grid hp = new Grid(2, 2);
        hp.setWidget(0, 0, (Widget)new Label("IndexType name:"));
        this.idxTypeNameBox = new TextBox();
        this.idxTypeNameBox.setVisibleLength(20);
        hp.setWidget(0, 1, (Widget)this.idxTypeNameBox);
        hp.setWidget(1, 0, (Widget)new Label("IndexType description:"));
        this.idxTypeDescBox = new TextBox();
        this.idxTypeDescBox.setVisibleLength(50);
        hp.setWidget(1, 1, (Widget)this.idxTypeDescBox);
        hp.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_MIDDLE);
        hp.getRowFormatter().setVerticalAlign(1, HasVerticalAlignment.ALIGN_MIDDLE);
        idxDetailsPanel.add((Widget)hp);
        this.indexTypeTable = new FlexTable();
        this.indexTypeTable.setCellSpacing(0);
        this.indexTypeTable.setCellPadding(2);
        this.saveIdxTypeButton = new Button("Save", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        VerticalPanel vp = new VerticalPanel();
        vp.setWidth("100%");
        vp.add((Widget)this.indexTypeTable);
        Button addFieldBtn = new Button("Add new field");
        addFieldBtn.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        vp.add((Widget)addFieldBtn);
        ScrollPanel sp = new ScrollPanel((Widget)vp);
        sp.setWidth("100%");
        sp.setHeight("350px");
        idxDetailsPanel.add((Widget)sp);
        idxDetailsPanel.add((Widget)this.saveIdxTypeButton);
        this.successLabel = new Label();
        this.successLabel.setVisible(false);
        this.successLabel.addStyleName("diligent-success");
        this.errorLabel = new Label();
        this.errorLabel.setVisible(false);
        this.errorLabel.addStyleName("diligent-error");
        idxDetailsPanel.add((Widget)this.successLabel);
        idxDetailsPanel.add((Widget)this.errorLabel);
        this.indexTypeTable.setWidth("100%");
        return idxDetailsPanel;
    }

    private void updateIndexTypeDetails(IndexTypeBean idxType) {
        int i;
        this.idxTypeNameBox.setText(idxType.getIndexTypeName());
        this.idxTypeDescBox.setText(idxType.getIndexTypeDesc());
        FieldBean[] indexTypeFields = idxType.getIndexTypeFields();
        this.indexTypeTable.clear();
        this.indexTypeTable.setWidget(0, 0, (Widget)new Label("name"));
        this.indexTypeTable.getCellFormatter().addStyleName(0, 0, "diligent-indexType-header");
        this.indexTypeTable.setWidget(0, 1, (Widget)new Label("index"));
        this.indexTypeTable.getCellFormatter().addStyleName(0, 1, "diligent-indexType-header");
        this.indexTypeTable.setWidget(0, 2, (Widget)new Label("store"));
        this.indexTypeTable.getCellFormatter().addStyleName(0, 2, "diligent-indexType-header");
        this.indexTypeTable.setWidget(0, 3, (Widget)new Label("return"));
        this.indexTypeTable.getCellFormatter().addStyleName(0, 3, "diligent-indexType-header");
        this.indexTypeTable.setWidget(0, 4, (Widget)new Label("boost"));
        this.indexTypeTable.getCellFormatter().addStyleName(0, 4, "diligent-indexType-header");
        this.indexTypeTable.setWidget(0, 5, (Widget)new Label("tokenize"));
        this.indexTypeTable.getCellFormatter().addStyleName(0, 5, "diligent-indexType-header");
        int numRows = this.indexTypeTable.getRowCount();
        for (i = numRows - 1; i > 0; --i) {
            this.indexTypeTable.removeRow(i);
        }
        for (i = 0; i < indexTypeFields.length; ++i) {
            this.addIndexFieldRow(indexTypeFields[i].getName(), indexTypeFields[i].getIndex(), indexTypeFields[i].getStore(), indexTypeFields[i].getReturned(), indexTypeFields[i].getBoost(), indexTypeFields[i].getTokenize());
        }
        this.saveIdxTypeButton.setEnabled(true);
    }

    private void addIndexFieldRow(String name, boolean bIndex, boolean bStore, boolean bReturn, String boost, boolean bTokenize) {
        int z = this.indexTypeTable.getRowCount();
        TextBox tbFieldName = new TextBox();
        tbFieldName.setText(name);
        this.indexTypeTable.setWidget(z, 0, (Widget)tbFieldName);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 0, "diligent-indexType");
        CheckBox indexed = new CheckBox();
        indexed.setChecked(bIndex);
        this.indexTypeTable.setWidget(z, 1, (Widget)indexed);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 1, "diligent-indexType");
        CheckBox stored = new CheckBox();
        stored.setChecked(bStore);
        this.indexTypeTable.setWidget(z, 2, (Widget)stored);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 2, "diligent-indexType");
        CheckBox returned = new CheckBox();
        returned.setChecked(bReturn);
        this.indexTypeTable.setWidget(z, 3, (Widget)returned);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 3, "diligent-indexType");
        TextBox tbBoost = new TextBox();
        tbBoost.setText(boost);
        tbBoost.setVisibleLength(3);
        this.indexTypeTable.setWidget(z, 4, (Widget)tbBoost);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 4, "diligent-indexType");
        CheckBox tokenized = new CheckBox();
        tokenized.setChecked(bTokenize);
        this.indexTypeTable.setWidget(z, 5, (Widget)tokenized);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 5, "diligent-indexType");
        HTML deleteField = new HTML("<div rowNum=\"" + z + "\" class=\"diligent-indexTypeField-delete\"> </div>");
        deleteField.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.indexTypeTable.setWidget(z, 6, (Widget)deleteField);
        this.indexTypeTable.getCellFormatter().addStyleName(z, 5, "diligent-indexType");
    }

    static /* synthetic */ ListBox access$000(IndexTypeEditorPanel x0) {
        return x0.indexTypesList;
    }

    static /* synthetic */ Map access$102(IndexTypeEditorPanel x0, Map x1) {
        x0.idxTypeResources = x1;
        return x0.idxTypeResources;
    }

    static /* synthetic */ int access$202(IndexTypeEditorPanel x0, int x1) {
        x0.selectedIdxType = x1;
        return x0.selectedIdxType;
    }

    static /* synthetic */ void access$300(IndexTypeEditorPanel x0) {
        x0.idxTypeListSelectionChange();
    }

    static /* synthetic */ void access$400(IndexTypeEditorPanel x0, IndexTypeBean x1) {
        x0.updateIndexTypeDetails(x1);
    }

    static /* synthetic */ Widget access$500(IndexTypeEditorPanel x0) {
        return x0.idxTypeDetailsPanel;
    }

    static /* synthetic */ TextBox access$600(IndexTypeEditorPanel x0) {
        return x0.idxTypeNameBox;
    }

    static /* synthetic */ int access$200(IndexTypeEditorPanel x0) {
        return x0.selectedIdxType;
    }

    static /* synthetic */ Map access$100(IndexTypeEditorPanel x0) {
        return x0.idxTypeResources;
    }

    static /* synthetic */ FlexTable access$700(IndexTypeEditorPanel x0) {
        return x0.indexTypeTable;
    }

    static /* synthetic */ TextBox access$800(IndexTypeEditorPanel x0) {
        return x0.idxTypeDescBox;
    }

    static /* synthetic */ void access$900(IndexTypeEditorPanel x0, String x1, boolean x2, boolean x3, boolean x4, String x5, boolean x6) {
        x0.addIndexFieldRow(x1, x2, x3, x4, x5, x6);
    }
}

